/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.lpt;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ngwdm.lpt.TEEVPL;
import com.huawei.nglct.nemgr.ip.ngwdm.lpt.TEIPUtils;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;

public class TEGetEplForLpt
extends TENEExplorerBean {
    private static final String VLAN_NULL = "65535";
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 31443;
    private static final int NSCMD_CFG_GET_LPTFLAG = 30137;
    private static final int VCTRUNK = 32768;
    private HashMap portMap = new HashMap();
    private static final int BIDIRECTION = 1;
    private static final String DISABLE = "0";

    public void handleMessage(int neid, ArrayList operationList, SubFunc subFunc) {
        BussinessParams bussinessParams = new BussinessParams();
        this.outputData.setBussinessParams(bussinessParams);
        Operation operation = null;
        boolean hasFault = false;
        boolean hasSucc = false;
        ArrayList errList = null;
        ArrayList eplList = new ArrayList();
        Output output = null;
        ArrayList returnList = null;
        int size = operationList.size();
        for (int i = 0; i < size; ++i) {
            int j;
            operation = (Operation)operationList.get(i);
            if (31443 == operation.getCmdid()) {
                for (j = operation.getOutputCount() - 1; j >= 0; --j) {
                    output = operation.getOutput(j);
                    int srcPort = Integer.parseInt(output.getPartValue("srcPort"));
                    int snkPort = Integer.parseInt(output.getPartValue("snkPort"));
                    if (VLAN_NULL.equals(output.getPartValue("srcVlan")) && VLAN_NULL.equals(output.getPartValue("snkVlan")) && (32768 >= srcPort || 32768 >= snkPort) && (32768 <= srcPort || 32768 <= snkPort)) continue;
                    operation.removeOutput(j);
                }
                errList = this.parseVlanSwitchLink(operation, eplList);
                if (errList.size() > 0) {
                    hasFault = true;
                    int errNum = errList.size();
                    for (int errIndex = 0; errIndex < errNum; ++errIndex) {
                        bussinessParams.addRowParams((RowParams)errList.get(errIndex));
                    }
                }
                if (eplList.size() > 0) {
                    hasSucc = true;
                }
                returnList = this.coupleEPL(eplList);
            }
            if (30137 != operation.getCmdid()) continue;
            for (j = operation.getOutputCount() - 1; j >= 0; --j) {
                output = operation.getOutput(j);
                String port = output.getPartValue("port");
                String lptEnable = output.getPartValue("W32BRD_ATTR_LPTENABLE");
                this.portMap.put(port, lptEnable);
            }
        }
        this.returnData(returnList, bussinessParams);
        this.outputData.setErrorMessage(new ErrorMessage());
        if (!hasFault) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else if (!hasSucc) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        }
    }

    private void setRowParam(RowParams rowparam) {
        rowparam.getParam("vcTrunk").setValue("");
        rowparam.getParam("direction").setValue("");
        rowparam.getParam("lptThrough").setValue("");
    }

    private void returnData(ArrayList returnList, BussinessParams bussinessParams) {
        RowParams rowparams = null;
        Param param = null;
        TEEVPL link = null;
        int size = returnList.size();
        for (int i = 0; i < size; ++i) {
            String lptEnable;
            link = (TEEVPL)((Object)returnList.get(i));
            if (1 != link.direction) continue;
            rowparams = new RowParams();
            if (32768 > link.srcPort) {
                param = new Param("portid", "" + link.srcPort);
                rowparams.addParam(param);
                param = new Param("port", "PORT" + link.srcPort);
                rowparams.addParam(param);
            } else {
                param = new Param("vctrunkid", "" + link.srcPort);
                rowparams.addParam(param);
                param = new Param("vcTrunk", "VCTRUNK" + (link.srcPort - 32768));
                rowparams.addParam(param);
            }
            if (32768 > link.snkPort) {
                param = new Param("portid", "" + link.snkPort);
                rowparams.addParam(param);
                param = new Param("port", "PORT" + link.snkPort);
                rowparams.addParam(param);
            } else {
                param = new Param("vctrunkid", "" + link.snkPort);
                rowparams.addParam(param);
                param = new Param("vcTrunk", "VCTRUNK" + (link.snkPort - 32768));
                rowparams.addParam(param);
            }
            param = new Param("direction", "" + link.direction);
            rowparams.addParam(param);
            int portid = link.srcPort;
            if (32768 < portid) {
                portid = link.snkPort;
            }
            param = null != (lptEnable = (String)this.portMap.get("" + portid)) ? new Param("W32BRD_ATTR_LPTENABLE", lptEnable) : new Param("W32BRD_ATTR_LPTENABLE", DISABLE);
            rowparams.addParam(param);
            bussinessParams.addRowParams(rowparams);
        }
        this.portMap.clear();
        returnList.clear();
    }

    private void createRow(String port, BussinessParams bussinessParams) {
        RowParams rowparams = null;
        Param param = null;
        rowparams = new RowParams();
        param = new Param("port", "PORT" + port);
        rowparams.addParam(param);
        param = new Param("vcTrunk", "");
        rowparams.addParam(param);
        param = new Param("derection", "");
        rowparams.addParam(param);
        param = new Param("lptThrough", "");
        rowparams.addParam(param);
        bussinessParams.addRowParams(rowparams);
    }

    private ArrayList parseVlanSwitchLink(Operation operation, ArrayList eplList) {
        ArrayList<RowParams> errList = new ArrayList<RowParams>();
        Output output = null;
        TEEVPL link = null;
        RowParams errRow = null;
        int linkNum = operation.getOutputCount();
        for (int j = 0; j < linkNum; ++j) {
            output = operation.getOutput(j);
            errRow = TEIPUtils.handleRowError(output);
            if (errRow != null) {
                errList.add(errRow);
                continue;
            }
            link = new TEEVPL();
            int partNum = output.getPartCount();
            for (int k = 0; k < partNum; ++k) {
                link.setPropValue(output.getPart(k));
            }
            link.direction = 0;
            link.linkType = 0;
            if (link.upLinkID > 0) {
                eplList.add(link);
                continue;
            }
            TELogFactory.getNormalLogger().error("parseVlanSwitchLink() invalid link=" + (Object)((Object)link));
        }
        return errList;
    }

    private ArrayList coupleEPL(ArrayList eplList) {
        ArrayList<TEEVPL> resultList = new ArrayList<TEEVPL>();
        ArrayList tempEplList = new ArrayList();
        TEEVPL cur = null;
        TEEVPL newLink = null;
        tempEplList.addAll(eplList);
        int curIndex = 0;
        while (curIndex < tempEplList.size()) {
            cur = (TEEVPL)((Object)tempEplList.get(curIndex));
            if (1 == cur.direction) {
                resultList.add(cur);
                tempEplList.remove(curIndex);
                continue;
            }
            int foundIndex = this.findCoupleEpl(cur, tempEplList, curIndex + 1);
            if (foundIndex >= 0) {
                newLink = new TEEVPL(cur);
                newLink.direction = 1;
                newLink.downLinkID = ((TEEVPL)((Object)tempEplList.get((int)foundIndex))).upLinkID;
                newLink.coupledFlag = true;
                ((TEEVPL)((Object)tempEplList.get((int)foundIndex))).coupledFlag = true;
                resultList.add(newLink);
                tempEplList.remove(curIndex);
                continue;
            }
            ++curIndex;
        }
        for (curIndex = 0; curIndex < tempEplList.size(); ++curIndex) {
            cur = (TEEVPL)((Object)tempEplList.get(curIndex));
            if (cur.coupledFlag) continue;
            cur.direction = 0;
            resultList.add(cur);
        }
        return resultList;
    }

    private int findCoupleEpl(TEEVPL seed, ArrayList linkList, int fromIndex) {
        for (int foundIndex = fromIndex; foundIndex < linkList.size(); ++foundIndex) {
            if (!this.isCoupleEpl(seed, (TEEVPL)((Object)linkList.get(foundIndex)))) continue;
            return foundIndex;
        }
        return -1;
    }

    private boolean isCoupleEpl(TEEVPL first, TEEVPL second) {
        return first.srcPort == second.snkPort && first.snkPort == second.srcPort;
    }
}

