/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation.mclag.script;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.script.TEScriptCmd;
import com.huawei.nglct.cbb.script.TEScriptHandler;
import com.huawei.nglct.cbb.script.TEScriptOperationMgr;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation.mclag.db.TEMCLAGDbMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.mcsp.db.TEMCSPDbMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherMCLAGMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherMCSPMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;

public class TEMCLAGScriptHandler
implements TEScriptHandler {
    private static final Logger logger = TELogFactory.getNormalLogger();
    private static final int INT_DEFAULT_VALUE = -1;
    private static final String STR_DEFAULT_VALUE = "";
    private static final int ALL_SLOT = -1;

    public int doExport(int neID, int item) {
        int result = 0;
        if (!TENEListMgr.getInstance().isAddedNE(neID)) {
            return result;
        }
        return this.writeExportDataToScript(neID, item);
    }

    private int writeExportDataToScript(int neID, int item) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        List<TEEtherMCLAGMOPO> molagObjRes = TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB(neID, -1, errRet);
        List<TEEtherMCSPMOPO> mcspObjRes = TEMCSPDbMgr.getAllEtherMCSPMOFromDB(neID, -1, errRet);
        if (0 != errRet.getResult()) {
            return 1092743443;
        }
        if (molagObjRes.isEmpty()) {
            logger.info("mclagMO is null! neID->" + neID);
            return 0;
        }
        HashMap<Integer, TEEtherMCSPMOPO> pathMap = new HashMap<Integer, TEEtherMCSPMOPO>(mcspObjRes.size());
        for (TEEtherMCSPMOPO mcspMo : mcspObjRes) {
            pathMap.put(mcspMo.getPathID(), mcspMo);
        }
        for (TEEtherMCLAGMOPO mclagMo : molagObjRes) {
            TEScriptCmd cmd;
            int pathID = mclagMo.getPathID();
            TEEtherMCSPMOPO mcspMo = (TEEtherMCSPMOPO)pathMap.get(pathID);
            if (null == mcspMo) {
                logger.info("mcspMO is null! neID->" + neID + " pathID->" + pathID);
            }
            if (null == (cmd = this.constructScriptCmd(mclagMo, mcspMo, item))) {
                return 0;
            }
            TEScriptOperationMgr.getInstance().writeCommand(neID, item, cmd);
        }
        return 0;
    }

    private TEScriptCmd constructScriptCmd(TEEtherMCLAGMOPO molagObj, TEEtherMCSPMOPO mcspObj, int item) {
        String rvtmodeVal;
        TEScriptCmd cmd = new TEScriptCmd();
        cmd.setCmdCode(item);
        int board = molagObj.getBoard();
        int lagid = molagObj.getLagID();
        int peerport = molagObj.getPeerPort();
        int pathid = molagObj.getPathID();
        int servicetype = molagObj.getServiceType();
        int rvtmode = molagObj.getRvtMode();
        int rvttime = molagObj.getRvtTime();
        String assportlist = molagObj.getASSPortList();
        if (-1 != board) {
            cmd.addPara("board", board, false, false);
        }
        if (-1 != lagid) {
            cmd.addPara("lagid", lagid, false, false);
        }
        if (-1 != peerport) {
            cmd.addPara("peerport", peerport, false, false);
        }
        if (-1 != pathid) {
            cmd.addPara("pathid", pathid, false, false);
        }
        if (-1 != servicetype) {
            cmd.addPara("servicetype", servicetype, false, false);
        }
        if (!STR_DEFAULT_VALUE.equals(assportlist)) {
            cmd.addPara("assportlist", assportlist, false, false);
        }
        if (null != mcspObj) {
            int pathport = mcspObj.getPortID();
            int hellointerval = mcspObj.getHelloInterval();
            if (-1 != pathport) {
                cmd.addPara("pathport", pathport, false, false);
            }
            if (-1 != hellointerval) {
                cmd.addPara("hellointerval", hellointerval, false, false);
            }
        }
        switch (rvtmode) {
            case 0: {
                rvtmodeVal = "rvt";
                break;
            }
            case 1: {
                rvtmodeVal = "norvt";
                break;
            }
            default: {
                rvtmodeVal = STR_DEFAULT_VALUE;
            }
        }
        if (!STR_DEFAULT_VALUE.equals(rvtmodeVal)) {
            cmd.addPara("rvtmode", rvtmodeVal, false, false);
        }
        if (-1 != rvttime) {
            cmd.addPara("rvttime", rvttime, false, false);
        }
        return cmd;
    }

    public int doImport(int neID, int item, List<TEScriptCmd> contents) {
        return 0;
    }
}

