/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation.mclag.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.explorer.beanplugin.TEBeanPluginLog;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherMCLAGMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public class TEMCLAGDbMgr {
    public static final String UNKNOWN = "UNKNOWN";
    private static final Logger LOGGER = TELogFactory.getNormalLogger();

    private TEMCLAGDbMgr() {
    }

    public static TEEtherMCLAGMOPO getEtherMCLAGMOFromDB(int neID, int slotID, int lagNO, TEErrInfoReturn error) {
        String tip = "TEMCLAGDbMgr.getEtherMCLAGMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCLAGDbMgr.getEtherMCLAGMOFromDB");
        if (null == error) {
            return null;
        }
        TEDaoOperationResult dbResult = null;
        TEEtherMCLAGMOPO moObject = null;
        try {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            criteria.add(new TEDaoNameValuePair("Board", String.valueOf(slotID)));
            criteria.add(new TEDaoNameValuePair("LagID", String.valueOf(lagNO)));
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEEtherMCLAGMOPO.class, criteria);
        }
        catch (Exception err) {
            TEMCLAGDbMgr.logExceptionOnGet(neID, err);
            TEMCLAGDbMgr.setOperFail(neID, error, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getEtherMCLAGMOFromDB");
            return moObject;
        }
        if (null == dbResult) {
            TEMCLAGDbMgr.logNullErrorOnGet(neID);
            TEMCLAGDbMgr.setOperFail(neID, error, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getEtherMCLAGMOFromDB");
            return moObject;
        }
        int retCode = dbResult.getResult();
        if (1090613273 == retCode) {
            TEMCLAGDbMgr.logNullNEError(neID);
            TEMCLAGDbMgr.setOperFail(neID, error, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getEtherMCLAGMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List dataObj = dbResult.getData();
            if (null != dataObj && !dataObj.isEmpty()) {
                moObject = (TEEtherMCLAGMOPO)dataObj.get(0);
            }
        } else {
            TEMCLAGDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEMCLAGDbMgr.setOperFail(neID, error, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getEtherMCLAGMOFromDB");
        return moObject;
    }

    public static List<TEEtherMCLAGMOPO> getAllEtherMCLAGMOFromDB(int neID, int slotID, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB");
        if (null == errRet) {
            return new ArrayList<TEEtherMCLAGMOPO>(0);
        }
        ArrayList<Object> moObject = new ArrayList<TEEtherMCLAGMOPO>(0);
        TEDaoOperationResult dbResult = null;
        try {
            ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
            if (slotID != -1) {
                criteria.add(new TEDaoNameValuePair("Board", String.valueOf(slotID)));
            }
            dbResult = TECommonDaoService.findByID((int)neID, (int[])new int[]{neID}, TEEtherMCLAGMOPO.class, criteria);
        }
        catch (Exception e) {
            TEMCLAGDbMgr.logExceptionOnGet(neID, e);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB");
            return moObject;
        }
        if (null == dbResult) {
            TEMCLAGDbMgr.logNullErrorOnGet(neID);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB");
            return moObject;
        }
        int retCode = dbResult.getResult();
        if (1090613273 == retCode) {
            TEMCLAGDbMgr.logNullNEError(neID);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1090596385);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB");
            return moObject;
        }
        if (0 == retCode) {
            List data = dbResult.getData();
            if (null != data && !data.isEmpty()) {
                moObject = new ArrayList(data.size());
                for (Object obj : data) {
                    moObject.add((TEEtherMCLAGMOPO)obj);
                }
            }
        } else {
            TEMCLAGDbMgr.logRetCodeErrorOnGet(neID, retCode);
            TEMCLAGDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.getAllEtherMCLAGMOFromDB");
        return moObject;
    }

    public static void createOrUpdateEtherMCLAGMOToDB(int neID, TEEtherMCLAGMOPO mclagMO, TEErrInfoReturn errRet, boolean updateFlag) {
        String FUNC_NAME = "TEMCLAGDbMgr.createOrUpdateEtherMCLAGMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCLAGDbMgr.createOrUpdateEtherMCLAGMOToDB");
        if (null == mclagMO) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = updateFlag ? TECommonDaoService.update((int)neID, (int[])new int[]{neID}, (Object)mclagMO) : TECommonDaoService.create((int)neID, (int[])new int[]{neID}, (Object)mclagMO);
        }
        catch (Exception e) {
            TEMCLAGDbMgr.logExceptionErrorOnUpdate(neID, e);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.createOrUpdateEtherMCLAGMOToDB");
            return;
        }
        if (null == dbResult) {
            TEMCLAGDbMgr.logNullErrorOnUpdate(neID);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.createOrUpdateEtherMCLAGMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEMCLAGDbMgr.logRetCodeErrorOnUpdate(neID, retCode);
            TEMCLAGDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.createOrUpdateEtherMCLAGMOToDB");
    }

    public static void delMCLAGMOToDB(int neID, TEEtherMCLAGMOPO moObject, TEErrInfoReturn errRet) {
        String MCLAG_FUNC_NAME = "TEMCLAGDbMgr.delMCLAGMOToDB";
        TEBeanPluginLog.logFuncBegin((String)"TEMCLAGDbMgr.delMCLAGMOToDB");
        if (null == moObject) {
            return;
        }
        if (null == errRet) {
            return;
        }
        TEDaoOperationResult dbResult = null;
        try {
            dbResult = TECommonDaoService.delete((int)neID, (int[])new int[]{neID}, (Object)moObject);
        }
        catch (Exception e) {
            TEMCLAGDbMgr.logExceptionErrorOnDel(neID, e);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.delMCLAGMOToDB");
            return;
        }
        if (null == dbResult) {
            TEMCLAGDbMgr.logNullErrorOnDel(neID);
            TEMCLAGDbMgr.setOperFail(neID, errRet, 1092743443);
            TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.delMCLAGMOToDB");
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            TEMCLAGDbMgr.logRetCodeErrorOnDel(neID, retCode);
            TEMCLAGDbMgr.setOperFail(neID, errRet, retCode);
        }
        TEBeanPluginLog.logFuncEnd((String)"TEMCLAGDbMgr.delMCLAGMOToDB");
    }

    private static void setOperFail(int neID, TEErrInfoReturn rspErrRet, int retCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = ne.getNEName();
        rspErrRet.setResult(1090605056);
        rspErrRet.addErrInfo(TEMCLAGDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, retCode).getErrList());
    }

    public static TEErrInfoReturn constructErrInfoReturn(int neID, int errorCode) {
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        String neName = UNKNOWN;
        if (null != ne) {
            neName = ne.getNEName();
        }
        return TEMCLAGDbMgr.constructErrInfoReturn(new int[]{neID}, new String[]{neName}, errorCode);
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, String[] objName, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setObjName(TEMCLAGDbMgr.getObjName(objName));
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    public static String getObjName(String[] objName) {
        StringBuffer objNameBuffer = new StringBuffer();
        int len = objName.length;
        for (int i = 0; i < len; ++i) {
            if (0 != i) {
                objNameBuffer.append('-');
            }
            objNameBuffer.append(objName[i]);
        }
        return objNameBuffer.toString();
    }

    private static void logNullNEError(int neID) {
        LOGGER.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get mo from db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnGet(int neID) {
        LOGGER.error("get mo from db fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionOnGet(int neID, Exception e) {
        LOGGER.error("get mo from db fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnUpdate(int neID, int retCode) {
        String tipStr = String.format("update mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }

    private static void logNullErrorOnUpdate(int neID) {
        LOGGER.error("update mo to db device fail! dbResult is null! neID->" + neID);
    }

    private static void logExceptionErrorOnUpdate(int neID, Exception e) {
        LOGGER.error("update mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logNullErrorOnDel(int neID) {
        LOGGER.error("delete mo to db device fail! neID->" + neID);
    }

    private static void logExceptionErrorOnDel(int neID, Exception e) {
        LOGGER.error("delete mo to db device fail! neID->" + neID, (Throwable)e);
    }

    private static void logRetCodeErrorOnDel(int neID, int retCode) {
        String tipStr = String.format("delete mo to db device fail! neID:%d, retCode:%d", neID, retCode);
        LOGGER.error(tipStr);
    }
}

