/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation.mclag;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.TENGWDMIPUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TEQueryMCLagPort
extends TENEExplorerBean {
    private static final int NSCMD_ETHN_GET_LINKAGG = 34226;
    private static final int NSCMD_ETHN_GET_LINKAGG_EX = 34211;
    private static final int NSCMD_ETHN_SET_MCLAG_ASSPORT = 38013;
    private static final int BDTYPE_TN51TEM28 = 2292;
    private static final int VCTRUNK_BASE = 32768;
    private Set usedLagPortSet = new HashSet();
    private Set usedSouthPortSet = new HashSet();
    private List ethnPortList = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.getPortAndVCtrunk(neid, this.inputData);
        Operation operation = null;
        Output output = null;
        int m = operationList.size();
        block4: for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            switch (operation.getCmdid()) {
                case 34211: 
                case 34226: {
                    byte[] bTmp;
                    int nParaSize;
                    int nPos;
                    int nCount;
                    byte[] bValue;
                    int n = operation.getOutputCount();
                    for (int j = 0; j < n; ++j) {
                        output = operation.getOutput(j);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.usedLagPortSet.add(Integer.valueOf(output.getPartValue("mainPort")));
                        int branchPortNum = Integer.parseInt(output.getPartValue("branchPortNum"));
                        if (branchPortNum <= 0) continue;
                        bValue = output.getPartValue("branchPort").getBytes();
                        nCount = 6;
                        nPos = 0;
                        nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 2, bTmp, 0, 4);
                            this.usedLagPortSet.add(new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0)));
                            nPos += nCount;
                        }
                    }
                    continue block4;
                }
                case 38013: {
                    byte[] bTmp;
                    int nParaSize;
                    int nPos;
                    int nCount;
                    byte[] bValue;
                    int t = operation.getOutputCount();
                    for (int k = 0; k < t; ++k) {
                        int portNum;
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0") || (portNum = Integer.parseInt(output.getPartValue("portNum"))) <= 0) continue;
                        bValue = output.getPartValue("portList").getBytes();
                        nCount = 4;
                        nPos = 0;
                        nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                            this.usedSouthPortSet.add(new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0)));
                            nPos += nCount;
                        }
                    }
                    continue block4;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEQueryMCLagPort.handleMessage() getCmdid:" + operation.getCmdid() + " not in case!");
                }
            }
        }
        this.constructOutputData();
    }

    private void constructOutputData() {
        this.outputData.setBussinessParams(new BussinessParams());
        String slotID = this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, Integer.valueOf(slotID).intValue());
        if (this.ethnPortList.size() > 0) {
            Option option;
            Integer portId;
            RowParams rowParams = new RowParams();
            Param param = new Param("mainPort", "");
            int mm = this.ethnPortList.size();
            for (int ii = 0; ii < mm; ++ii) {
                portId = (Integer)this.ethnPortList.get(ii);
                if (boardType == 2292 && portId > 32768) continue;
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.ethnPortList.removeAll(this.usedLagPortSet);
            this.ethnPortList.removeAll(this.usedSouthPortSet);
            param = new Param("southPort", "");
            int nn = this.ethnPortList.size();
            for (int jj = 0; jj < nn; ++jj) {
                portId = (Integer)this.ethnPortList.get(jj);
                option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getPortAndVCtrunk(int neid, Datainterface inputData) {
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        Param boardTypeParam = Datainterface.getParam((Param[])params, (String)"boardType");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        boardTypeParam = Datainterface.getParam((Param[])params, (String)"slotid");
        int slotId = Integer.parseInt(boardTypeParam.getValue());
        this.ethnPortList.addAll(TENGWDMIPUtil.getEthPortList(neid, slotId, boardType));
    }
}

