/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation.TELAGUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;

public class TESetLagParams
extends TENEExplorerBean {
    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            TELogInfo loginfo = null;
            int userID = 0;
            if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
                try {
                    userID = Integer.parseInt(user);
                }
                catch (Exception e) {
                    userID = 0;
                }
            }
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo = new TELogInfo();
            loginfo.setOperateDesc(this.getDetailDesc());
            if (errorCode != 0 && errorCode != 2 && errorCode != 1) {
                loginfo.setResult(2);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else if (errorCode == 0) {
                loginfo.setResult(0);
                loginfo.setErrCode(errorCode);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                RowParams[] rows = outputData.getBussinessParams().getRowParams();
                int m = rows.length;
                for (int i = 0; i < m; ++i) {
                    boolean errFlag = false;
                    RowErrors[] rowErrorses = rows[i].getRowErrors();
                    int n = rowErrorses.length;
                    for (int j = 0; j < n; ++j) {
                        int errCode;
                        if (null == rowErrorses[j].getErrorMessage() || 0 == (errCode = Integer.parseInt(rowErrorses[j].getErrorMessage().getErrorcode()))) continue;
                        errFlag = true;
                        loginfo.setErrCode(errCode);
                        loginfo.setErrInfo(rowErrorses[j].getErrorMessage().getErrorinfo());
                        break;
                    }
                    if (errFlag) break;
                }
                loginfo.setResult(errorCode);
            }
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(userID);
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            loginfo.setOperateName(subfunc.getSubFuncDes(neid));
            loginfo.setOperateObject(operObj);
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    public String getDetailDesc() {
        TEResourceUtil res = TELAGUtil.getResourceUtil(this.neid);
        StringBuffer sb = new StringBuffer(res.getString("portPriority")).append(":");
        String sysPrio = res.getString("systemPriority") + ":";
        RowParams[] rowParamses = this.inputData.getBussinessParams().getRowParams();
        int m = rowParamses.length;
        for (int i = 0; i < m; ++i) {
            int slotId = Integer.parseInt(rowParamses[i].getParam("slotid").getValue());
            if (i == 0) {
                sysPrio = TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotId) + "," + sysPrio;
            }
            if (rowParamses[i].getParam("LAGSystemPriority") != null) {
                sysPrio = sysPrio + rowParamses[i].getParam("LAGSystemPriority").getValue();
                continue;
            }
            int portId = Integer.parseInt(rowParamses[i].getParam("portid").getValue());
            String portName = TELAGUtil.getPortName(portId);
            sb.append(portName).append(":").append(rowParamses[i].getParam("LAGPortPriority").getValue()).append(",");
        }
        return sysPrio + "," + sb.substring(0, sb.length() - 1);
    }
}

