/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TEQueryLagPort
extends TENEExplorerBean {
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK = 31443;
    private static final int NSCMD_ETHN_GET_VLANSWITCHLINK_EX = 34293;
    private static final int NSCMD_ETHN_GET_QINQLINK = 31458;
    private static final int NSCMD_ETHN_GET_QINQLINK_EX = 34298;
    private static final int NSCMD_ETHN_GET_LINKAGG = 34226;
    private static final int NSCMD_ETHN_GET_LINKAGG_EX = 34211;
    private Set usedPortSet = new HashSet();
    private List ethnPortList = new ArrayList();
    private Set servicePortSet = new HashSet();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        this.getPortAndVCtrunk(neid, this.inputData);
        Operation operation = null;
        Output output = null;
        int m = operationList.size();
        block4: for (int i = 0; i < m; ++i) {
            operation = (Operation)operationList.get(i);
            switch (operation.getCmdid()) {
                case 34211: 
                case 34226: {
                    int n = operation.getOutputCount();
                    for (int j = 0; j < n; ++j) {
                        output = operation.getOutput(j);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.usedPortSet.add(Integer.valueOf(output.getPartValue("mainPort")));
                        int branchPortNum = Integer.parseInt(output.getPartValue("branchPortNum"));
                        if (branchPortNum <= 0) continue;
                        byte[] bValue = output.getPartValue("branchPort").getBytes();
                        int nCount = 4;
                        int nPos = 0;
                        int nParaSize = bValue.length;
                        while (nPos + nCount <= nParaSize) {
                            byte[] bTmp = new byte[4];
                            System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                            this.usedPortSet.add(new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0)));
                            nPos += nCount;
                        }
                    }
                    continue block4;
                }
                case 31443: 
                case 31458: 
                case 34293: 
                case 34298: {
                    int t = operation.getOutputCount();
                    for (int k = 0; k < t; ++k) {
                        output = operation.getOutput(k);
                        if (!output.getFault(0).getCode().equals("0")) continue;
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("srcPort")));
                        this.servicePortSet.add(Integer.valueOf(output.getPartValue("snkPort")));
                    }
                    continue block4;
                }
                default: {
                    TELogFactory.getNormalLogger().info("TEQueryLagPort.handleMessage() getCmdid:" + operation.getCmdid() + " not in case!");
                }
            }
        }
        this.ethnPortList.removeAll(this.usedPortSet);
        this.servicePortSet.removeAll(this.usedPortSet);
        this.outputData.setBussinessParams(new BussinessParams());
        String slotID = this.inputData.getBussinessParams().getRowParams(0).getParam("slotID").getValue();
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, Integer.valueOf(slotID).intValue());
        for (int index = this.ethnPortList.size() - 1; index >= 0; --index) {
            int portId = (Integer)this.ethnPortList.get(index);
            if (boardType == 1067 && portId == 3) {
                this.ethnPortList.remove(index);
            }
            if (boardType != 1095 || portId <= 32768) continue;
            this.ethnPortList.remove(index);
        }
        if (this.ethnPortList.size() > 0) {
            RowParams rowParams = new RowParams();
            Param param = new Param("mainport", "");
            int mm = this.ethnPortList.size();
            for (int ii = 0; ii < mm; ++ii) {
                Integer portId = (Integer)this.ethnPortList.get(ii);
                Option option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.ethnPortList.removeAll(this.servicePortSet);
            param = new Param("branchport", "");
            int nn = this.ethnPortList.size();
            for (int jj = 0; jj < nn; ++jj) {
                Integer portId = (Integer)this.ethnPortList.get(jj);
                Option option = new Option(String.valueOf(portId));
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    private void getPortAndVCtrunk(int neid, Datainterface inputData) {
        Param[] params = inputData.getBussinessParams().getRowParams(0).getParam();
        Param boardTypeParam = Datainterface.getParam((Param[])params, (String)"boardType");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        boardTypeParam = Datainterface.getParam((Param[])params, (String)"slotid");
        int slotId = Integer.parseInt(boardTypeParam.getValue());
        TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();
        ArrayList vcTrunkPortList = mgr.getETHVCTrunkPort(neid, slotId, boardType);
        ArrayList macPortList = mgr.getLogicPortList(neid, slotId);
        this.ethnPortList.addAll(macPortList);
        this.ethnPortList.addAll(vcTrunkPortList);
    }
}

