/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.linkaggregation;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;

public class TEQueryLACPInfo
extends TENEExplorerBean {
    private static final String RECIVIED_LACP = "1";
    private static final String RECIVIED_FAULT_LACP = "2";
    private static final String SENT_LACP = "3";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subfunc = subFunc;
        this.inputData = inputData;
        RowParams ngwdmRowParams = inputData.getBussinessParams().getRowParams(0);
        String ports = ngwdmRowParams.getParam("portid").getValue();
        String slotid = ngwdmRowParams.getParam("slotid").getValue();
        this.outputData = new Datainterface();
        this.operationList = this.constructOperationList(ports, slotid);
        int retCode = this.sendMessage(neid);
        if (retCode == 0) {
            this.handleMessage(neid, this.operationList, subFunc);
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)retCode));
        }
        this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        return this.outputData;
    }

    private ArrayList constructOperationList(String ports, String slotid) {
        String[] ngwdmPortList = ports.split(",");
        ArrayList<Object> operationList = new ArrayList<Object>();
        Operation oper = null;
        Input input = null;
        int len = ngwdmPortList.length;
        for (int i = 0; i < len; ++i) {
            oper = (Operation)TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_LINKAGGPCK").clone();
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", ngwdmPortList[i]);
            input.setPartValue("lagpacType", RECIVIED_LACP);
            operationList.add(oper.clone());
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", ngwdmPortList[i]);
            input.setPartValue("lagpacType", RECIVIED_FAULT_LACP);
            operationList.add(oper.clone());
            input = oper.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", ngwdmPortList[i]);
            input.setPartValue("lagpacType", SENT_LACP);
            operationList.add(oper.clone());
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        Operation oper = null;
        Output output = null;
        Part ngwdmPartType = null;
        Part partNum = null;
        int operLength = operationList.size();
        for (int i = 0; i < operLength; ++i) {
            oper = (Operation)operationList.get(i);
            int outputLength = oper.getOutputCount();
            for (int j = 0; j < outputLength; ++j) {
                output = oper.getOutput(j);
                if (!output.getFault(0).getCode().equals("0")) continue;
                ngwdmPartType = output.getPart("lagpacType");
                partNum = output.getPart("lagpacNum");
                Part newPart = new Part();
                if (RECIVIED_LACP.equals(ngwdmPartType.getValue())) {
                    newPart.setName("receivedLACP");
                } else if (RECIVIED_FAULT_LACP.equals(ngwdmPartType.getValue())) {
                    newPart.setName("receivedFaultLACP");
                } else if (SENT_LACP.equals(ngwdmPartType.getValue())) {
                    newPart.setName("sentLACP");
                }
                newPart.setValue(partNum.getValue());
                output.addPart(newPart);
                output.removePart(ngwdmPartType);
                output.removePart(partNum);
            }
        }
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList);
    }

    public String getDetailStr(RowParams rowparams) {
        int slotId = Integer.parseInt(rowparams.getParam("slotid").getValue());
        return TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotId);
    }
}

