/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.igmp;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.igmp.TEQuickLeaveObject;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEQueryQuickLeaveBean
extends TENEExplorerBean {
    private static final int SVL = 1;

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        try {
            this.outputData = new Datainterface();
            this.outputData.setBussinessParams(new BussinessParams());
            ArrayList quickOperList = this.constuctOperationList(operationList);
            if (!quickOperList.isEmpty()) {
                int result = this.sendMessage(neid, quickOperList);
                if (result == 0) {
                    this.outputData = this.dealOperationList(quickOperList);
                } else {
                    this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("handleMessage fail!", (Throwable)e);
        }
    }

    private ArrayList constuctOperationList(List operationList) {
        Operation quickOper = TECreateObjectFactory.getOperation((int)this.neid, (String)"NSCMD_ETHN_GET_IGMP_QKLEAVEEN");
        ArrayList<Object> quickOperList = new ArrayList<Object>();
        Operation operation = (Operation)operationList.get(0);
        Output output = operation.getOutput(0);
        int errorCode = Integer.parseInt(output.getFault(0).getCode());
        if (0 == errorCode) {
            quickOper.getInput().setPartValue("slotid", output.getPartValue("slotid"));
            String vbid = output.getPartValue("vbid");
            quickOper.getInput().setPartValue("vbid", vbid);
            int bridgeMode = Integer.parseInt(output.getPartValue("vbstudytype"));
            if (1 == bridgeMode) {
                quickOper.getInput().setPartValue("vlanid", "65534");
                quickOperList.add(quickOper);
            } else {
                operation = (Operation)operationList.get(1);
                int m = operation.getOutputCount();
                for (int i = 0; i < m; ++i) {
                    output = operation.getOutput(i);
                    if (!"0".equals(output.getFault(0).getCode())) continue;
                    quickOper.getInput().setPartValue("vlanid", output.getPartValue("vlanid"));
                    quickOperList.add(quickOper.clone());
                }
            }
        }
        return quickOperList;
    }

    private Datainterface dealOperationList(List quickOperList) {
        int slotid = 0;
        int vbid = 0;
        int vlanid = 0;
        int port = 0;
        int state = 0;
        Operation operation = null;
        Output output = null;
        ArrayList<RowErrors> errorDataList = new ArrayList<RowErrors>();
        HashMap<TEQuickLeaveObject, TEQuickLeaveObject> portList = new HashMap<TEQuickLeaveObject, TEQuickLeaveObject>();
        int len = quickOperList.size();
        for (int i = 0; i < len; ++i) {
            operation = (Operation)quickOperList.get(i);
            int m = operation.getOutputCount();
            for (int j = 0; j < m; ++j) {
                output = operation.getOutput(j);
                if ("0".equals(output.getFault(0).getCode())) {
                    slotid = Integer.parseInt(output.getPartValue("slotid"));
                    vbid = Integer.parseInt(output.getPartValue("vbid"));
                    vlanid = Integer.parseInt(output.getPartValue("vlanid"));
                    port = Integer.parseInt(output.getPartValue("port"));
                    state = Integer.parseInt(output.getPartValue("state"));
                    TEQuickLeaveObject object = new TEQuickLeaveObject(slotid, vbid, vlanid);
                    TEQuickLeaveObject objectTmp = (TEQuickLeaveObject)portList.get(object);
                    if (objectTmp == null) {
                        objectTmp = object;
                        portList.put((TEQuickLeaveObject)object.clone(), object);
                    }
                    objectTmp.addPort(port);
                    objectTmp.addState(state);
                    continue;
                }
                errorDataList.add(TEDataConverter.handleErrorData((int)this.neid, (SubFunc)this.subfunc, (Input)operation.getInput(), (Output)output));
            }
        }
        Datainterface result = this.convertDataToOutput(portList, errorDataList);
        return result;
    }

    private Datainterface convertDataToOutput(Map<TEQuickLeaveObject, TEQuickLeaveObject> portList, ArrayList errorDataList) {
        Datainterface outputData = new Datainterface();
        Set<Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject>> set = portList.entrySet();
        Iterator<Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject>> iterator = set.iterator();
        Map.Entry<TEQuickLeaveObject, TEQuickLeaveObject> entry = null;
        TEQuickLeaveObject objTmp = null;
        RowParams tmpRow = null;
        BussinessParams bp = new BussinessParams();
        String boardName = "";
        while (iterator.hasNext()) {
            entry = iterator.next();
            objTmp = entry.getValue();
            tmpRow = new RowParams();
            tmpRow.addParam("slotid", objTmp.getSlotID() + "");
            int boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, objTmp.getSlotID());
            boardName = TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardType);
            tmpRow.addParam("boardname", boardName);
            tmpRow.addParam("vbid", objTmp.getVbID() + "");
            tmpRow.addParam("vlanid", objTmp.getVlanID() + "");
            if (objTmp.getPortList().size() <= 0) continue;
            tmpRow.addParam("portlist", this.combinArrayList(objTmp.getPortList()));
            tmpRow.addParam("statelist", this.combinArrayList(objTmp.getLeavestate()));
            bp.addRowParams(tmpRow);
        }
        outputData.setBussinessParams(bp);
        if (null != errorDataList && !errorDataList.isEmpty()) {
            tmpRow = new RowParams();
            RowErrors rErrors = null;
            int size = errorDataList.size();
            for (int i = 0; i < size; ++i) {
                rErrors = (RowErrors)errorDataList.get(i);
                tmpRow.addRowErrors(rErrors);
            }
            bp.addRowParams(tmpRow);
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        } else {
            outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        }
        return outputData;
    }

    private String combinArrayList(List<Integer> list) {
        StringBuffer result = new StringBuffer("");
        String str = "";
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            result.append(str).append(list.get(i).toString());
            str = ",";
        }
        return result.toString();
    }
}

