/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethupload;

import com.huawei.nglct.cbb.datamanage.integration.handler.TECIUpLoadHandler;
import com.huawei.nglct.cbb.datamanage.integration.handler.TECfgItem;
import com.huawei.nglct.cbb.datamanage.integration.model.TEDataCfgUploadPara;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.List;
import org.slf4j.Logger;

public class TEVBUploadHandler
implements TECIUpLoadHandler {
    private static final String ITEM_UPLOAD_VB_NAME = "IP EVPN";
    private static final int ITEM_UPLOAD_VB_ID = 720937;
    private static final Logger E2ELOGGER = TELogFactory.getE2ELogger();

    public TECfgItem getOperIF(int OperType) {
        return null;
    }

    public String getItemName() {
        return ITEM_UPLOAD_VB_NAME;
    }

    public int getItemID() {
        return 720937;
    }

    public int upLoad(TEDataCfgUploadPara pPara) {
        E2ELOGGER.info("Upload vb begin.");
        int neID = pPara.getTmpNEInfo().getNeID();
        int slotID = -1;
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            String tipStr = "upload vb fail! ";
            tipStr = tipStr + String.format("[neID:%d, retCode:%d]", neID, retCode);
            E2ELOGGER.error(tipStr);
            E2ELOGGER.info("Upload vb end.");
            return retCode;
        }
        List boardList = TEConfigurationDataMgr.getInstance().getBoardList(neID);
        int boardType = -1;
        boolean isAllFail = true;
        boolean isAllSuccess = true;
        TEErrInfoReturn errInfoReturn = new TEErrInfoReturn();
        for (TEBoard board : boardList) {
            boardType = board.getBoardType();
            if (!TEEthXCUtil.isBoardSupportVB(boardType)) continue;
            slotID = board.getSlotID();
            int errorCode = TEE2EVBUtil.getVBFromNE(neID, slotID);
            if (0 != errorCode) {
                TEErrInfo errInfo = new TEErrInfo();
                errInfo.setObjID(new int[]{neID, slotID});
                errInfo.setErrorCode(errorCode);
                errInfoReturn.addErrInfo(errInfo);
                isAllSuccess = false;
                continue;
            }
            String tipStr = "upload vb for the board fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errorCode:%d]", neID, slotID, errorCode);
            E2ELOGGER.error(tipStr);
            isAllFail = false;
        }
        if (isAllSuccess) {
            errInfoReturn.setResult(0);
        } else if (isAllFail) {
            errInfoReturn.setResult(1090650122);
        } else {
            errInfoReturn.setResult(1090650126);
        }
        E2ELOGGER.info("Upload vb end.");
        return 0;
    }
}

