/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam_v2r7c01;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMDBHandler;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEQueryMDMA
extends TENEExplorerBean {
    private static final int QUERY_NULL_ERR = 38662;
    private Map mdMap = new HashMap();
    private ArrayList errCodeList = new ArrayList();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        boolean isSucc = false;
        boolean isFail = false;
        this.outputData.setBussinessParams(new BussinessParams());
        Operation queryMD = (Operation)operationList.get(0);
        Output output = null;
        int errCode = 0;
        int size = queryMD.getOutputCount();
        for (int i = 0; i < size; ++i) {
            output = queryMD.getOutput(i);
            errCode = Integer.parseInt(output.getFault(0).getCode());
            if (errCode == 0) {
                Integer mdid = Integer.valueOf(output.getPart("mdid").getValue());
                MD temp = new MD(output);
                this.mdMap.put(mdid, temp);
                isSucc = true;
                continue;
            }
            if (errCode == 38662) {
                isSucc = true;
                continue;
            }
            isFail = true;
            this.handleErrData(queryMD, errCode);
        }
        Operation queryMA = (Operation)operationList.get(1);
        int size2 = queryMA.getOutputCount();
        for (int i = 0; i < size2; ++i) {
            output = queryMA.getOutput(i);
            errCode = Integer.parseInt(output.getFault(0).getCode());
            if (errCode == 0) {
                Integer mdid = Integer.valueOf(output.getPart("mdid").getValue());
                ((MD)this.mdMap.get(mdid)).addMA(new MA(output));
                isSucc = true;
                continue;
            }
            if (errCode == 38662) {
                isSucc = true;
                continue;
            }
            isFail = true;
            this.handleErrData(queryMA, errCode);
        }
        this.handleOutputData();
        if (isSucc && isFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)1));
        } else if (isSucc && !isFail) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)0));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)neid, (int)2));
        }
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEEthServiceOAMDBHandler.saveEthServiceOAMMDMAToDB(neid, this.inputData, this.outputData);
        }
    }

    private void handleOutputData() {
        Collection values = this.mdMap.values();
        Iterator ite = values.iterator();
        ArrayList list = new ArrayList();
        while (ite.hasNext()) {
            list.add(ite.next());
        }
        Collections.sort(list);
        RowParams rowParams = null;
        Param param = null;
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            MD temp = (MD)list.get(i);
            rowParams = new RowParams();
            param = new Param("mdid", "");
            param.setValue(String.valueOf(temp.mdid));
            rowParams.addParam(param);
            param = new Param("mdName", "");
            param.setValue(temp.mdName);
            rowParams.addParam(param);
            param = new Param("mdNameType", "");
            param.setValue(temp.mdNameType);
            rowParams.addParam(param);
            param = new Param("mdLevel", "");
            param.setValue(String.valueOf(temp.mdLevel));
            rowParams.addParam(param);
            param = new Param("maList", "");
            Collections.sort(temp.maList);
            int size1 = temp.maList.size();
            for (int j = 0; j < size1; ++j) {
                Option option = new Option(((MA)temp.maList.get(j)).toString());
                param.addOption(option);
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void handleErrData(Operation oper, int errCode) {
        RowParams rowParams = new RowParams();
        RowErrors rowErr = new RowErrors();
        if (this.errCodeList.contains(errCode)) {
            return;
        }
        this.errCodeList.add(errCode);
        Param param = new Param("slotid", oper.getInput().getPartValue("slotid"));
        rowErr.addParam(param);
        int slotid = Integer.parseInt(oper.getInput().getPartValue("slotid"));
        int boardtype = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotid);
        param = new Param("boardname", TEConfigurationDataMgr.getInstance().getBoardTypeName(this.neid, boardtype));
        rowErr.addParam(param);
        rowErr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)errCode));
        rowParams.addRowErrors(rowErr);
        this.outputData.getBussinessParams().addRowParams(rowParams);
    }

    class MA
    implements Comparable {
        int maid;
        String maName;

        public MA(Output output) {
            this.maid = Integer.parseInt(output.getPart("maid").getValue());
            this.maName = IOStreamConvertor.replaceSpecialStr((String)output.getPart("maName").getValue());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maName == null ? 0 : this.maName.hashCode());
            result = 31 * result + this.maid;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MA other = (MA)obj;
            if (this.maName == null ? other.maName != null : !this.maName.equals(other.maName)) {
                return false;
            }
            return this.maid == other.maid;
        }

        public int compareTo(Object o) {
            if (this.equals(0)) {
                return 0;
            }
            return this.maid - ((MA)o).maid;
        }

        public String toString() {
            return this.maid + "," + this.maName;
        }
    }

    class MD
    implements Comparable {
        int mdid;
        int mdLevel;
        String mdNameType;
        String mdName;
        List maList = new ArrayList();

        public MD(Output output) {
            this.mdid = Integer.parseInt(output.getPart("mdid").getValue());
            this.mdLevel = Integer.parseInt(output.getPart("level").getValue());
            this.mdNameType = output.getPart("mdNameType").getValue();
            this.mdName = IOStreamConvertor.replaceSpecialStr((String)output.getPart("mdName").getValue());
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.maList == null ? 0 : ((Object)this.maList).hashCode());
            result = 31 * result + this.mdLevel;
            result = 31 * result + (this.mdName == null ? 0 : this.mdName.hashCode());
            result = 31 * result + (this.mdNameType == null ? 0 : this.mdNameType.hashCode());
            result = 31 * result + this.mdid;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            MD other = (MD)obj;
            if (this.maList == null ? other.maList != null : !((Object)this.maList).equals(other.maList)) {
                return false;
            }
            if (this.mdLevel != other.mdLevel) {
                return false;
            }
            if (this.mdName == null ? other.mdName != null : !this.mdName.equals(other.mdName)) {
                return false;
            }
            if (this.mdNameType == null ? other.mdNameType != null : !this.mdNameType.equals(other.mdNameType)) {
                return false;
            }
            return this.mdid == other.mdid;
        }

        public void addMA(MA ma) {
            this.maList.add(ma);
        }

        public int compareTo(Object o) {
            if (this.equals(o)) {
                return 0;
            }
            return this.mdid - ((MD)o).mdid;
        }
    }
}

