/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam_v2r7c01;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMDBHandler;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.List;

public class TEQueryEthServiceOAMBean
extends TENEExplorerBean {
    private static final int QUERYRESULT_NULL_1800 = 41382;
    private static final String NE_NOT_LOGIN = "37926";
    private static final int NON_VLANID = 65535;
    private TEConfigurationDataMgr mgr = TEConfigurationDataMgr.getInstance();

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> errorCodeList = new ArrayList<Integer>();
        errorCodeList.add(38662);
        errorCodeList.add(39326);
        errorCodeList.add(41382);
        return errorCodeList;
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList opers = super.getOperation(neid, subFunc, inputData, memeryData);
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("slotid");
        if (param == null) {
            return opers;
        }
        String slotId = param.getValue();
        Operation tmpOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_VLANSWITCHLINK");
        tmpOper.getInput().getPart("slotID").setValue(slotId);
        opers.add(tmpOper);
        tmpOper = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_QINQLINK");
        tmpOper.getInput().getPart("slotID").setValue(slotId);
        opers.add(tmpOper);
        return opers;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        Operation qinqLinkOper = (Operation)operationList.remove(operationList.size() - 1);
        Operation vlanSwitchLinkOper = (Operation)operationList.remove(operationList.size() - 1);
        ArrayList<Operation> tmpOpers = new ArrayList<Operation>();
        tmpOpers.add(qinqLinkOper);
        tmpOpers.add(vlanSwitchLinkOper);
        Operation queryMAOper = (Operation)operationList.remove(operationList.size() - 1);
        Operation queryMDOper = (Operation)operationList.remove(operationList.size() - 1);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        int ret = Integer.parseInt(this.outputData.getErrorMessage().getErrorcode());
        BussinessParams bussinessParams = this.outputData.getBussinessParams();
        RowParams[] rowParams = bussinessParams.getRowParams();
        if (0 != ret) {
            RowParams rowparam1 = null;
            RowErrors rowErrors = null;
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                rowparam1 = rowParams[i];
                if (0 == rowparam1.getRowErrorsCount() || !(rowErrors = rowparam1.getRowErrors(0)).getErrorMessage().getErrorcode().equals(NE_NOT_LOGIN)) continue;
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(NE_NOT_LOGIN)));
                for (int j = rowparam1.getRowErrorsCount() - 1; j >= 0; --j) {
                    rowparam1.removeRowErrors(rowparam1.getRowErrors(j));
                }
                return;
            }
        }
        boolean errFlag = false;
        RowParams rowparam = null;
        RowErrors rowErrors = null;
        int slotId = 0;
        int portId = 0;
        String mpid = "";
        String cmpid = "";
        String ccMac = "";
        String ccMacStr = "";
        int sinkPort = -1;
        int vlanId = -1;
        int linkId = -1;
        Param tmpParam = null;
        if (0 == ret || 1 == ret) {
            int len = rowParams.length;
            for (int i = 0; i < len; ++i) {
                errFlag = false;
                rowparam = rowParams[i];
                if (0 != rowparam.getRowErrorsCount() && !(rowErrors = rowparam.getRowErrors(0)).getErrorMessage().getErrorcode().equals("0")) {
                    errFlag = true;
                }
                if (errFlag) continue;
                slotId = Integer.parseInt(rowparam.getParam("slotid").getValue());
                portId = Integer.parseInt(rowparam.getParam("port").getValue());
                rowparam.getParam("portname").setValue(this.getPortName(slotId, portId));
                mpid = rowparam.getParam("mpid").getValue();
                cmpid = mpid.substring(0, 2) + "-" + mpid.substring(2, 4) + "-" + mpid.substring(4);
                rowparam.getParam("mpid").setValue(cmpid);
                vlanId = Integer.valueOf(rowparam.getParam("vlanid").getValue());
                linkId = Integer.valueOf(rowparam.getParam("serviceid").getValue());
                sinkPort = this.getSinkPort(linkId, portId, vlanId, tmpOpers);
                if (sinkPort != -1) {
                    tmpParam = new Param("sinkPortName", this.getPortName(slotId, sinkPort));
                    rowparam.addParam(tmpParam);
                }
                if (rowparam.getParam("mdid").getValue().equals("")) {
                    rowparam.getParam("mdid").setValue("0");
                    rowparam.getParam("mdName").setValue("NULL");
                    rowparam.getParam("mAName").setValue("NULL");
                    continue;
                }
                ccMac = rowparam.getParam("ccMac").getValue();
                if (!"".equals(ccMac)) {
                    ccMacStr = ccMac.substring(0, 2) + "-" + ccMac.substring(2, 4) + "-" + ccMac.substring(4, 6) + "-" + ccMac.substring(6, 8) + "-" + ccMac.substring(8, 10) + "-" + ccMac.substring(10, 12);
                    rowparam.getParam("ccMac").setValue(ccMacStr);
                }
                this.handleMDMAOper(rowparam, queryMDOper, queryMAOper);
            }
        }
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            TEEthServiceOAMDBHandler.saveEthServiceOAMMPToDB(neid, this.inputData, this.outputData);
        }
    }

    private String getPortName(int slotId, int portId) {
        String portName = "";
        int boardType = this.mgr.getBoardType(this.neid, slotId);
        int portType = this.mgr.getPortType(this.neid, boardType, portId);
        portName = portType == 61005 ? TEConfigurationDataMgr.getVCTrunkName((int)(portId - 32768)) : TEConfigurationDataMgr.getMACName((int)portId);
        return portName;
    }

    private void handleMDMAOper(RowParams rowparam, Operation mdOper, Operation maOper) {
        int i;
        String mdid = rowparam.getParam("mdid").getValue();
        String maid = rowparam.getParam("maid").getValue();
        Output output = null;
        for (i = mdOper.getOutputCount() - 1; i >= 0; --i) {
            output = mdOper.getOutput(i);
            if (!output.getFault(0).getCode().equals("0")) {
                mdOper.removeOutput(i);
                continue;
            }
            if (!output.getPart("mdid").getValue().equals(mdid)) continue;
            rowparam.getParam("mdName").setValue(IOStreamConvertor.replaceSpecialStr((String)output.getPart("mdName").getValue()));
            rowparam.getParam("level").setValue(output.getPart("level").getValue());
            break;
        }
        for (i = maOper.getOutputCount() - 1; i >= 0; --i) {
            output = maOper.getOutput(i);
            if (!output.getFault(0).getCode().equals("0")) {
                maOper.removeOutput(i);
                continue;
            }
            if (!output.getPart("mdid").getValue().equals(mdid) || !output.getPart("maid").getValue().equals(maid)) continue;
            rowparam.getParam("maName").setValue(IOStreamConvertor.replaceSpecialStr((String)output.getPart("maName").getValue()));
            break;
        }
    }

    private int getSinkPort(int linkId, int srcPort, int vlanId, List<Operation> opers) {
        int destSrcPort = -1;
        int destVlanId = -1;
        int sinkPort = -1;
        int destLinkId = -1;
        for (Operation tmpOper : opers) {
            int len = tmpOper.getOutputCount();
            for (int i = 0; i < len; ++i) {
                Output tmpOutput = tmpOper.getOutput(i);
                if (!String.valueOf(0).equals(tmpOutput.getFault(0).getCode())) continue;
                if ("NSCMD_ETHN_GET_VLANSWITCHLINK".equals(tmpOper.getName())) {
                    destLinkId = Integer.valueOf(tmpOutput.getPartValue("linkID"));
                    destSrcPort = Integer.parseInt(tmpOutput.getPartValue("srcPort"));
                    sinkPort = Integer.valueOf(tmpOutput.getPartValue("snkPort"));
                    destVlanId = Integer.valueOf(tmpOutput.getPartValue("srcVlan"));
                } else if ("NSCMD_ETHN_GET_QINQLINK".equals(tmpOper.getName())) {
                    destLinkId = Integer.valueOf(tmpOutput.getPartValue("linkID"));
                    destSrcPort = Integer.valueOf(tmpOutput.getPartValue("srcPort"));
                    destVlanId = Integer.valueOf(tmpOutput.getPartValue("srcSVlan"));
                    if (destVlanId == 65535) {
                        destVlanId = Integer.valueOf(tmpOutput.getPartValue("srcVlan"));
                    }
                    sinkPort = Integer.valueOf(tmpOutput.getPartValue("snkPort"));
                }
                if (destLinkId != linkId || srcPort != destSrcPort || destVlanId != vlanId) continue;
                return sinkPort;
            }
        }
        return -1;
    }
}

