/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.mooperation;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoNameValuePair;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.po.embeddednemgrmo.eth.TEWebLCTRmepMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TEMarmepDBMgr {
    private static final Logger logger = TELogFactory.getNormalLogger();

    private TEMarmepDBMgr() {
    }

    private static void logRetCodeErr(int neID, int retCode) {
        String tipStr = String.format("delete  fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }

    public static List<TEWebLCTRmepMOPO> getAllMepFromDB(int neID, int slotid, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEMepDBMgr.getAllMepFromDB";
        logger.info("TEMepDBMgr.getAllMepFromDB: begin.");
        ArrayList<TEWebLCTRmepMOPO> mepList = new ArrayList<TEWebLCTRmepMOPO>();
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                TEMarmepDBMgr.logNullNEError(neID);
                errRet.setResult(1090596385);
                TEMarmepDBMgr.logFunEnd("TEMepDBMgr.getAllMepFromDB");
                return mepList;
            }
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findAll((int[])new int[]{neID, slotid}, TEWebLCTRmepMOPO.class) : TECommonDaoService.findAll_NonLock((int[])new int[]{neID, slotid}, TEWebLCTRmepMOPO.class);
        }
        catch (Exception e) {
            logger.error("get mep from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.getAllMepFromDB");
            return mepList;
        }
        if (null == dbRet) {
            logger.error("get mep from db fail! dbRet is null! neID->" + neID);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.getAllMepFromDB");
            return mepList;
        }
        int retCode = dbRet.getResult();
        if (0 == retCode) {
            List data = dbRet.getData();
            if (null != data && !data.isEmpty()) {
                for (Object obj : data) {
                    mepList.add((TEWebLCTRmepMOPO)obj);
                }
            }
        } else {
            TEMarmepDBMgr.logRetCodeErrorOnGet(neID, retCode);
            errRet.setResult(retCode);
        }
        TEMarmepDBMgr.logFunEnd("TEMepDBMgr.getAllMepFromDB");
        return mepList;
    }

    private static void logExpErrOnCreate(int neID, Exception e) {
        logger.error("create  fail! neID->" + neID, (Throwable)e);
    }

    public static TEWebLCTRmepMOPO getMepByid(int neID, int slotid, int mdid, int maid, TEErrInfoReturn errRet) {
        ArrayList<TEDaoNameValuePair> criteria = new ArrayList<TEDaoNameValuePair>();
        TEDaoNameValuePair aPair = new TEDaoNameValuePair("Mdid", String.valueOf(mdid));
        criteria.add(aPair);
        aPair = new TEDaoNameValuePair("Maid", String.valueOf(maid));
        criteria.add(aPair);
        TEWebLCTRmepMOPO mopo = null;
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.findByID((int[])new int[]{neID, slotid}, TEWebLCTRmepMOPO.class, criteria) : TECommonDaoService.findByID_NonLock((int[])new int[]{neID, slotid}, TEWebLCTRmepMOPO.class, criteria);
            if (null == dbResult) {
                String tipStr = "Get TEWebLCTRmepMOPO fail! The dbResult is null!! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                logger.error(tipStr);
                return mopo;
            }
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTRmepMOPO fail! DB oper error! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            logger.error(tipStr, (Throwable)e);
            return mopo;
        }
        if (0 == dbResult.getResult() && dbResult.getData().size() > 0) {
            mopo = (TEWebLCTRmepMOPO)dbResult.getData().get(0);
        }
        return mopo;
    }

    public static void updateMepToDB(int neID, TEWebLCTRmepMOPO mo, TEErrInfoReturn errRet) {
        TEDaoOperationResult dbResult = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbResult = ne.isDataCfgStausNeedLock() ? TECommonDaoService.update((int[])new int[]{neID, mo.getBoard()}, (Object)mo) : TECommonDaoService.update_NonLock((int[])new int[]{neID, mo.getBoard()}, (Object)mo);
        }
        catch (Exception e) {
            String tipStr = "Get TEWebLCTRmepMOPO fail! ";
            logger.error(tipStr, (Throwable)e);
            errRet.setResult(1092743443);
            return;
        }
        if (null == dbResult) {
            TEMarmepDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            return;
        }
        int retCode = dbResult.getResult();
        if (0 != retCode) {
            errRet.setResult(retCode);
        }
    }

    public static void delMepFromDB(int neID, TEWebLCTRmepMOPO stgSrcMO, TEErrInfoReturn errRet) {
        String FUNC_NAME = "TEMepDBMgr.delMepFromDB";
        logger.info("TEMepDBMgr.delMepFromDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.delete((int[])new int[]{neID}, (Object)stgSrcMO) : TECommonDaoService.delete_NonLock((int[])new int[]{neID}, (Object)stgSrcMO);
        }
        catch (Exception e) {
            logger.error("delete mep from db fail! neID->" + neID, (Throwable)e);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.delMepFromDB");
            return;
        }
        if (null == dbRet) {
            TEMarmepDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.delMepFromDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEMarmepDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEMarmepDBMgr.logFunEnd("TEMepDBMgr.delMepFromDB");
    }

    private static void logNullError(int neID) {
        logger.error("delete  to db device fail! neID->" + neID);
    }

    private static void logFunEnd(String funcName) {
        logger.info(funcName + ": end.");
    }

    public static void createMepToDB(int neID, TEWebLCTRmepMOPO mep, TEErrInfoReturn errRet) {
        String FUNCNAME = "TEMepDBMgr.createMepToDB";
        logger.info("TEMepDBMgr.createMepToDB: begin.");
        TEDaoOperationResult dbRet = null;
        try {
            TENE ne = TENEListMgr.getInstance().getNE(neID);
            dbRet = ne.isDataCfgStausNeedLock() ? TECommonDaoService.create((int[])new int[]{neID, mep.getBoard()}, (Object)mep) : TECommonDaoService.create_NonLock((int[])new int[]{neID, mep.getBoard()}, (Object)mep);
        }
        catch (Exception e) {
            TEMarmepDBMgr.logExpErrOnCreate(neID, e);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.createMepToDB");
            return;
        }
        if (null == dbRet) {
            TEMarmepDBMgr.logNullError(neID);
            errRet.setResult(1092743443);
            TEMarmepDBMgr.logFunEnd("TEMepDBMgr.createMepToDB");
            return;
        }
        int retCode = dbRet.getResult();
        if (0 != retCode) {
            TEMarmepDBMgr.logRetCodeErr(neID, retCode);
            errRet.setResult(retCode);
        }
        TEMarmepDBMgr.logFunEnd("TEMepDBMgr.createMepToDB");
    }

    private static void logNullNEError(int neID) {
        logger.error("ne is null! neID->" + neID);
    }

    private static void logRetCodeErrorOnGet(int neID, int retCode) {
        String tipStr = String.format("get db device fail! neID:%d, retCode:%d", neID, retCode);
        logger.error(tipStr);
    }
}

