/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.TEPingTestReport;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class TEStartPingBean
implements TENEMgrInterface {
    private static final int TIME_OUT = 10;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    Datainterface outputData = new Datainterface();
    BussinessParams rtnBParams = new BussinessParams();
    ArrayList rowErrorList = new ArrayList();
    private int neID = -1;
    private static final String SERVICE_OAM_RES = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "serviceoam" + File.separator + "serviceoamres_" + LANGUAGE + ".ini";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int slotID = Integer.parseInt(slotidParam.getValue());
        TEPingTestReport pingReport = TEPingTestReport.getInstance();
        if (!pingReport.hasRegisterd()) {
            pingReport.register(neid);
        }
        this.neID = neid;
        this.outputData.setBussinessParams(new BussinessParams());
        int errorCode11 = 0;
        RowParams[] rParams = inputData.getBussinessParams().getRowParams();
        String pingChangeFlag = rParams[0].getParam("pingChangeFlag").getValue();
        String changeFlag = rParams[0].getParam("ipChangeFlag").getValue();
        if ("true".equalsIgnoreCase(pingChangeFlag)) {
            errorCode11 = this.setPingParameter(rParams[0]);
        }
        if (0 == errorCode11) {
            if ("true".equalsIgnoreCase(changeFlag)) {
                errorCode11 = this.setIPAddress(rParams[0]);
            }
            if (0 == errorCode11 && 0 == (errorCode11 = this.startPing(rParams[0]))) {
                this.deleteDirtyData(this.neID, slotID, rParams[0]);
            }
        }
        int size = this.rowErrorList.size();
        for (int ii = 0; ii < size; ++ii) {
            RowParams rParam = new RowParams();
            RowErrors rError = (RowErrors)this.rowErrorList.get(ii);
            rParam.addRowErrors(rError);
            this.rtnBParams.addRowParams(rParam);
        }
        if (0 == errorCode11) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        } else if (2 == errorCode11) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)2));
        }
        this.outputData.setBussinessParams(this.rtnBParams);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int setPingParameter(RowParams rParamsArr) {
        ArrayList<Operation> sendOperList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_ETHOAM_SET_OAMPINGPARA");
        Input input1 = operation.getInput();
        input1.setPartValue("slotid", rParamsArr.getParam("slotid").getValue());
        String[] strMPIPArry = rParamsArr.getParam("mpID").getValue().split("-");
        input1.setPartValue("mpID", strMPIPArry[0] + strMPIPArry[1] + strMPIPArry[2]);
        input1.setPartValue("frameLength", rParamsArr.getParam("frameLength").getValue());
        input1.setPartValue("timeout", rParamsArr.getParam("timeout").getValue());
        sendOperList.add(operation);
        OperationResult resultPGID = TENECommMgr.getInstance().sendCommand(this.neID, sendOperList, 10);
        if (resultPGID.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)resultPGID.retCode));
            return resultPGID.retCode;
        }
        Operation tmpOper = (Operation)sendOperList.get(0);
        for (Output outputPGID : tmpOper.getOutput()) {
            Fault[] faultArrPGID = outputPGID.getFault();
            int acode = -1;
            for (Fault fault : faultArrPGID) {
                acode = Integer.parseInt(fault.getCode());
                if (0 == acode) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neID, (int)acode));
                RowErrors rowError1 = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neID + "Set Ping Parameter");
                rowError1.addParam(errorParam);
                rowError1.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)acode));
                this.rowErrorList.add(rowError1);
                return 2;
            }
        }
        return 0;
    }

    public int setIPAddress(RowParams rParamsArr) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_ETHOAM_SET_MPIP");
        Input input = operation.getInput();
        input.setPartValue("slotid", rParamsArr.getParam("slotid").getValue());
        String[] strMPIDArry = rParamsArr.getParam("mpID").getValue().split("-");
        String strTemp = strMPIDArry[0] + strMPIDArry[1] + strMPIDArry[2];
        input.setPartValue("mpID", strTemp);
        String[] strMPIPArry = rParamsArr.getParam("mpIP").getValue().replace('.', '-').split("-");
        StringBuffer strBuffer = new StringBuffer(0);
        int len = strMPIPArry.length;
        for (int i = 0; i < len; ++i) {
            strMPIPArry[i] = Integer.toHexString(Integer.parseInt(strMPIPArry[i]));
            if (2 > strMPIPArry[i].length()) {
                strMPIPArry[i] = "0" + strMPIPArry[i];
            }
            strBuffer.append(strMPIPArry[i]);
        }
        input.setPartValue("mpIP", strBuffer.toString());
        operList.add(operation);
        OperationResult resultPGID = TENECommMgr.getInstance().sendCommand(this.neID, operList, 10);
        if (resultPGID.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)resultPGID.retCode));
            return resultPGID.retCode;
        }
        Operation tmpOperPGID = (Operation)operList.get(0);
        for (Output outputPGID : tmpOperPGID.getOutput()) {
            Fault[] faultArrPGID = outputPGID.getFault();
            int code = -1;
            for (Fault fault : faultArrPGID) {
                code = Integer.parseInt(fault.getCode());
                if (0 == code) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neID, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neID + "Set IP Address");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)code));
                this.rowErrorList.add(rowError);
                return 2;
            }
        }
        return 0;
    }

    public int startPing(RowParams rParamsArr) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_ETHOAM_START_PING");
        Input input11 = operation.getInput();
        input11.setPartValue("slotid", rParamsArr.getParam("slotid").getValue());
        String[] strMPIDArry = rParamsArr.getParam("mpID").getValue().split("-");
        String strTemp = strMPIDArry[0] + strMPIDArry[1] + strMPIDArry[2];
        input11.setPartValue("srcMPID", strTemp);
        String[] strMPIPArry = rParamsArr.getParam("destMPIP").getValue().replace('.', '-').split("-");
        StringBuffer strbuf = new StringBuffer(0);
        int len = strMPIPArry.length;
        for (int i = 0; i < len; ++i) {
            strMPIPArry[i] = Integer.toHexString(Integer.parseInt(strMPIPArry[i]));
            if (2 > strMPIPArry[i].length()) {
                strMPIPArry[i] = "0" + strMPIPArry[i];
            }
            strbuf.append(strMPIPArry[i]);
        }
        input11.setPartValue("destMPIP", strbuf.toString());
        input11.setPartValue("pingTimes", rParamsArr.getParam("pingTimes").getValue());
        operList.add(operation);
        OperationResult resultPGID = TENECommMgr.getInstance().sendCommand(this.neID, operList, 10);
        if (resultPGID.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)resultPGID.retCode));
            return resultPGID.retCode;
        }
        Operation tmpOperPGID = (Operation)operList.get(0);
        for (Output outputPGID : tmpOperPGID.getOutput()) {
            Fault[] pgidArr = outputPGID.getFault();
            int code = -1;
            for (Fault fault : pgidArr) {
                code = Integer.parseInt(fault.getCode());
                if (0 == code) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neID, (int)code));
                RowErrors rowError1 = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neID + "Set IP Address11");
                rowError1.addParam(errorParam);
                rowError1.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)code));
                this.rowErrorList.add(rowError1);
                return 2;
            }
        }
        return 0;
    }

    private void deleteDirtyData(int neid, int slotID, RowParams rParamsArr) {
        String[] strMPIDArry = rParamsArr.getParam("mpID").getValue().split("-");
        String mpID = strMPIDArry[0] + strMPIDArry[1] + strMPIDArry[2];
        List<RowParams> reportList = TEPingTestReport.getInstance().getReportData(neid, slotID);
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        String tempMPID = "";
        for (int len = reportList.size() - 1; len >= 0; --len) {
            tempMPID = reportList.get(len).getParam("mpID").getValue();
            RowParams rowparams = (RowParams)reportList.get(len).clone();
            if (!tempMPID.equals(mpID)) continue;
            bussinessParams.addRowParams(rowparams);
            reportList.remove(len);
        }
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int pingNeid = neid;
        final Datainterface pingIntputData1 = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEStartPingBean.this.operationDescribtion(pingNeid, pingIntputData1);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion(int neID, Datainterface inputData) {
        TEResourceUtil resourceUtil = TEGetFilePath.getResource((int)neID, (String)SERVICE_OAM_RES);
        StringBuffer operDescNgwdm = new StringBuffer();
        RowParams rParamsArr = inputData.getBussinessParams().getRowParams()[0];
        String slotid = rParamsArr.getParam("slotid").getValue();
        operDescNgwdm.append(TEBoardUtil.getShelfBoardName((int)neID, (int)Integer.parseInt(slotid))).append(',');
        String pingTimes = rParamsArr.getParam("pingTimes").getValue();
        if ("65535".equals(pingTimes)) {
            operDescNgwdm.append(resourceUtil.getString("continueMode")).append(',');
        } else {
            operDescNgwdm.append(resourceUtil.getString("burstMode")).append(',').append(resourceUtil.getString("pingTimes")).append(':').append(rParamsArr.getParam("pingTimes").getValue()).append(',');
        }
        operDescNgwdm.append(resourceUtil.getString("frameLength")).append(':').append(rParamsArr.getParam("frameLength").getValue()).append(',').append(resourceUtil.getString("timeout")).append(':').append(rParamsArr.getParam("timeout").getValue()).append(resourceUtil.getString("second")).append(',').append(resourceUtil.getString("mpIP")).append(':').append(rParamsArr.getParam("mpIP").getValue()).append(',').append(resourceUtil.getString("destMPIP")).append(':').append(rParamsArr.getParam("destMPIP").getValue());
        return operDescNgwdm.toString();
    }
}

