/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TEWriteLogCommonImpl;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.TEPerformanceTestReport;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEStartPerformanceBean
implements TENEMgrInterface {
    Datainterface outputData = new Datainterface();
    BussinessParams rtnBParams = new BussinessParams();
    ArrayList rowErrorList = new ArrayList();
    private int neID = -1;
    private static final int TIME_OUT = 10;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String SERVICE_OAM_RES = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "serviceoam" + File.separator + "serviceoamres_" + LANGUAGE + ".ini";
    private TEResourceUtil resourceUtil = null;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        TEPerformanceTestReport perforReport = TEPerformanceTestReport.getInstance();
        if (!perforReport.hasRegisterd()) {
            perforReport.register(neid);
        }
        this.neID = neid;
        this.outputData.setBussinessParams(new BussinessParams());
        int errorCode = 0;
        RowParams[] rParamsArr = inputData.getBussinessParams().getRowParams();
        String performanceChangeFlag = rParamsArr[0].getParam("performanceChangeFlag").getValue();
        if ("true".equalsIgnoreCase(performanceChangeFlag)) {
            errorCode = this.setPerformanceParameter(rParamsArr[0]);
        }
        if (0 == errorCode) {
            errorCode = this.startPerformance(rParamsArr[0]);
        }
        int size = this.rowErrorList.size();
        for (int i = 0; i < size; ++i) {
            RowParams rParam = new RowParams();
            RowErrors rError = (RowErrors)this.rowErrorList.get(i);
            rParam.addRowErrors(rError);
            this.rtnBParams.addRowParams(rParam);
        }
        if (0 == errorCode) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)0));
        } else if (2 == errorCode) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)2));
        }
        this.outputData.setBussinessParams(this.rtnBParams);
        if (this.isNeedOperationlog()) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    public int setPerformanceParameter(RowParams rParamsArr) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_ETHOAM_SET_OAMPDPARA");
        Input input = operation.getInput();
        input.setPartValue("slotid", rParamsArr.getParam("slotid").getValue());
        String[] strMPIPArry = rParamsArr.getParam("srcmpid").getValue().split("-");
        String strTemp = strMPIPArry[0] + strMPIPArry[1] + strMPIPArry[2];
        input.setPartValue("srcmpid", strTemp);
        input.setPartValue("frameLength", rParamsArr.getParam("frameLength").getValue());
        input.setPartValue("timeout", rParamsArr.getParam("timeout").getValue());
        operList.add(operation);
        OperationResult result = TENECommMgr.getInstance().sendCommand(this.neID, operList, 10);
        if (result.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)result.retCode));
            return result.retCode;
        }
        Operation tmpOperPGID = (Operation)operList.get(0);
        for (Output outputPGID : tmpOperPGID.getOutput()) {
            Fault[] faultArr = outputPGID.getFault();
            int code = -1;
            for (Fault fault : faultArr) {
                code = Integer.parseInt(fault.getCode());
                if (0 == code) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neID, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neID + "Set Performance Parameter");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)code));
                this.rowErrorList.add(rowError);
                return 2;
            }
        }
        return 0;
    }

    public int startPerformance(RowParams rParamsArr) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Operation operation = TECreateObjectFactory.getOperation((int)this.neID, (String)"NSCMD_ETHN_ETHOAM_START_PD");
        Input input = operation.getInput();
        input.setPartValue("slotid", rParamsArr.getParam("slotid").getValue());
        String[] strMPIDArry = rParamsArr.getParam("srcmpid").getValue().split("-");
        String strTemp = strMPIDArry[0] + strMPIDArry[1] + strMPIDArry[2];
        input.setPartValue("srcmpid", strTemp);
        strMPIDArry = rParamsArr.getParam("snkmpid").getValue().split("-");
        strTemp = strMPIDArry[0] + strMPIDArry[1] + strMPIDArry[2];
        input.setPartValue("snkmpid", strTemp);
        input.setPartValue("detecttimes", rParamsArr.getParam("detecttimes").getValue());
        operList.add(operation);
        OperationResult resultPGID = TENECommMgr.getInstance().sendCommand(this.neID, operList, 10);
        if (resultPGID.retCode != 0) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)resultPGID.retCode));
            return resultPGID.retCode;
        }
        Operation tmpOperPGID = (Operation)operList.get(0);
        for (Output outputPGID : tmpOperPGID.getOutput()) {
            Fault[] faultArrPGID = outputPGID.getFault();
            int code = -1;
            for (Fault fault : faultArrPGID) {
                code = Integer.parseInt(fault.getCode());
                if (0 == code) continue;
                TELogFactory.getNormalLogger().info(TEErrorResourceUtil.getErrCodeResWithDot((int)this.neID, (int)code));
                RowErrors rowError = new RowErrors();
                Param errorParam = new Param("errorBbj", this.neID + "Start Performance Test");
                rowError.addParam(errorParam);
                rowError.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neID, (int)code));
                this.rowErrorList.add(rowError);
                return 2;
            }
        }
        return 0;
    }

    public boolean isNeedOperationlog() {
        return true;
    }

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        final int performanceNeid = neid;
        final Datainterface sinputData = inputData;
        new TEWriteLogCommonImpl(){

            public String getOperationDescribtion() {
                return TEStartPerformanceBean.this.operationDescribtion(performanceNeid, sinputData);
            }
        }.writeLog(neid, subfunc, inputData, user, ipAddress, outputData);
    }

    private String operationDescribtion(int neID, Datainterface inputData) {
        StringBuffer operDesc = new StringBuffer();
        RowParams rParamsArr = inputData.getBussinessParams().getRowParams()[0];
        this.resourceUtil = TEGetFilePath.getResource((int)neID, (String)SERVICE_OAM_RES);
        String slotid = rParamsArr.getParam("slotid").getValue();
        operDesc.append(TEBoardUtil.getShelfBoardName((int)neID, (int)Integer.parseInt(slotid))).append(',');
        String pingTimes = rParamsArr.getParam("detecttimes").getValue();
        if ("FFFF".equalsIgnoreCase(pingTimes)) {
            operDesc.append(this.resourceUtil.getString("continueMode")).append(',');
        } else {
            operDesc.append(this.resourceUtil.getString("burstMode")).append(',').append(this.resourceUtil.getString("detecttimes")).append(':').append(rParamsArr.getParam("detecttimes").getValue()).append(',');
        }
        operDesc.append(this.resourceUtil.getString("frameLength")).append(':').append(rParamsArr.getParam("frameLength").getValue()).append(',').append(this.resourceUtil.getString("timeout")).append(':').append(rParamsArr.getParam("timeout").getValue()).append(this.resourceUtil.getString("second")).append(',').append(this.resourceUtil.getString("srcmp")).append(':').append(rParamsArr.getParam("srcmpid").getValue()).append(',').append(this.resourceUtil.getString("snkmp")).append(':').append(rParamsArr.getParam("snkmpid").getValue());
        return operDesc.toString();
    }
}

