/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.TEOAMUtils;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class TEQueryRemoteOAMBean
extends TECommonWriteLogBean {
    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        List<Operation> queryMdMaList = this.parseOperationList(neid, operationList);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (this.outputData.getErrorMessage().getErrorcode().equals(String.valueOf(0))) {
            Map<String, String> mdmaNameMap = TEOAMUtils.queryMDMAId2NameMap(neid, queryMdMaList);
            this.appendMDMANameParam(mdmaNameMap);
        }
    }

    private void appendMDMANameParam(Map<String, String> mdmaNameMap) {
        BussinessParams bussiness = this.outputData.getBussinessParams();
        RowParams row = null;
        Param param = null;
        int len = bussiness.getRowParamsCount();
        for (int i = 0; i < len; ++i) {
            row = bussiness.getRowParams(i);
            if (row.getRowErrorsCount() > 0) continue;
            String strmdid = row.getParam("mdid").getValue();
            param = row.getParam("mdname");
            if (null == param) {
                param = new Param("mdname", "");
                row.addParam(param);
            }
            param.setValue(TEOAMUtils.getMdNameFromMap(mdmaNameMap, strmdid));
            String strmaid = row.getParam("maid").getValue();
            param = row.getParam("maname");
            if (null == param) {
                param = new Param("maname", "");
                row.addParam(param);
            }
            param.setValue(TEOAMUtils.getMaNameFromMap(mdmaNameMap, strmaid));
        }
    }

    private List<Operation> parseOperationList(int neid, List<Operation> operationList) {
        HashSet<Integer> mdIdList = new HashSet<Integer>();
        HashSet<Integer> maIdList = new HashSet<Integer>();
        Operation oper = null;
        Output output = null;
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            int j;
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            ArrayList<Output> outputList = new ArrayList<Output>();
            int lenj = oper.getOutputCount();
            for (j = 0; j < lenj; ++j) {
                output = oper.getOutput(j);
                int mdid = Integer.parseInt(output.getPartValue("mdid"));
                mdIdList.add(mdid);
                int maid = Integer.parseInt(output.getPartValue("maid"));
                maIdList.add(maid);
                outputList.addAll(this.parseRMMepID(output));
            }
            oper.clearOutput();
            lenj = outputList.size();
            for (j = 0; j < lenj; ++j) {
                oper.addOutput((Output)outputList.get(j));
            }
        }
        int slotid = Integer.parseInt(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        List<Operation> queryMdMaList = TEOAMUtils.getQuryMDNameOperation(neid, slotid, mdIdList);
        queryMdMaList.addAll(TEOAMUtils.getQuryMANameOperation(neid, slotid, maIdList));
        return queryMdMaList;
    }

    private List<Output> parseRMMepID(Output output) {
        ArrayList<Output> outputList = new ArrayList<Output>();
        int rmmepnum = 0;
        rmmepnum = Integer.parseInt(output.getPartValue("rmmepnum"));
        String rmmepid = output.getPartValue("rmmepid");
        Output outputTemp = null;
        for (int i = 0; i < rmmepnum; ++i) {
            outputTemp = (Output)output.clone();
            outputTemp.setPartValue("rmmepid", rmmepid.substring(i * 8, (i + 1) * 8));
            outputList.add(outputTemp);
        }
        return outputList;
    }
}

