/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEOAMUtils {
    private static final String NSCMD_ETHN_ETHOAM_GET_MD = "NSCMD_ETHN_ETHOAM_GET_MD";
    private static final String NSCMD_ETHN_ETHOAM_GET_MA = "NSCMD_ETHN_ETHOAM_GET_MA";
    private static final String MD_PROFIX = "md";
    private static final String MA_PROFIX = "ma";
    private static final int TIME_OUT = 20;

    private TEOAMUtils() {
    }

    public static List<Operation> getQuryMDNameOperation(int neid, int slotid, Set<Integer> mdidList) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Iterator<Integer> iterator = mdidList.iterator();
        Operation mdoper = null;
        while (iterator.hasNext()) {
            mdoper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_ETHOAM_GET_MD);
            mdoper.getInput().setPartValue("slotid", String.valueOf(slotid));
            mdoper.getInput().setPartValue("mdid", iterator.next().toString());
            operList.add(mdoper);
        }
        return operList;
    }

    public static List<Operation> getQuryMANameOperation(int neid, int slotid, Set<Integer> maidList) {
        ArrayList<Operation> operList = new ArrayList<Operation>();
        Iterator<Integer> iterator = maidList.iterator();
        Operation maoper = null;
        while (iterator.hasNext()) {
            maoper = TECreateObjectFactory.getOperation((int)neid, (String)NSCMD_ETHN_ETHOAM_GET_MA);
            maoper.getInput().setPartValue("slotid", String.valueOf(slotid));
            maoper.getInput().setPartValue("maid", iterator.next().toString());
            operList.add(maoper);
        }
        return operList;
    }

    public static Map<String, String> queryMDMAId2NameMap(int neid, List<Operation> queryMDMANameOperList) {
        if (!queryMDMANameOperList.isEmpty()) {
            OperationResult result = TENECommMgr.getInstance().sendCommand(neid, queryMDMANameOperList, 20);
            if (result.retCode != 0) {
                TELogFactory.getNormalLogger().info("queryMDMAName fail!result=" + result.retCode);
                return null;
            }
            return TEOAMUtils.parseOperationList(queryMDMANameOperList);
        }
        return null;
    }

    public static Map<String, String> parseOperationList(List<Operation> operationList) {
        Operation oper = null;
        Object output = null;
        HashMap<String, String> map = new HashMap<String, String>();
        String id = "";
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = operationList.get(i);
            if (!oper.getOutput(0).getFault(0).getCode().equals(String.valueOf(0))) continue;
            if (oper.getName().equals(NSCMD_ETHN_ETHOAM_GET_MD)) {
                id = oper.getOutput(0).getPartValue("mdid");
                map.put(MD_PROFIX + id, IOStreamConvertor.removeSpecialStr((String)oper.getOutput(0).getPartValue("mdName")));
            }
            if (!oper.getName().equals(NSCMD_ETHN_ETHOAM_GET_MA)) continue;
            id = oper.getOutput(0).getPartValue("maid");
            map.put(MA_PROFIX + id, IOStreamConvertor.removeSpecialStr((String)oper.getOutput(0).getPartValue("maName")));
        }
        return map;
    }

    public static String getMdNameFromMap(Map<String, String> mdmaNameMap, String mdid) {
        String name = "";
        if (null != mdmaNameMap && mdmaNameMap.containsKey(MD_PROFIX + mdid)) {
            name = mdmaNameMap.get(MD_PROFIX + mdid);
        }
        return name;
    }

    public static String getMaNameFromMap(Map<String, String> mdmaNameMap, String maid) {
        String name = "";
        if (null != mdmaNameMap && mdmaNameMap.containsKey(MA_PROFIX + maid)) {
            name = mdmaNameMap.get(MA_PROFIX + maid);
        }
        return name;
    }
}

