/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.cbb.log.TELogInfo;
import com.huawei.nglct.cbb.log.TELogMgr;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.sysmanager.TESysManagerConstants;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public abstract class TENewEthServiceOAMBeanSuper
extends TENEExplorerBean {
    private static final int VCTRUNK_BASE_NUM = 32768;
    private static final String LANGUAGE = TESysManagerBean.getInstance().getlanguage();
    private static final String SERVICE_OAM_RES = "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "serviceoam" + File.separator + "serviceoamres_" + LANGUAGE + ".ini";
    private TEResourceUtil res = null;
    private TEConfigurationDataMgr mgr = null;

    public void writeLog(int neid, SubFunc subfunc, Datainterface inputData, String user, String ipAddress, Datainterface outputData) {
        try {
            this.res = TEGetFilePath.getResource((int)neid, (String)SERVICE_OAM_RES);
            TELogInfo loginfo = new TELogInfo();
            TENE neObj = TENEListMgr.getInstance().getNE(neid);
            String operObj = "";
            operObj = null == neObj ? String.valueOf(neid) : neObj.getNEName();
            loginfo.setCmdID(subfunc.getCode());
            loginfo.setLocation(ipAddress);
            loginfo.setUserID(this.getUserID(user));
            loginfo.setUserName(TESysManagerBean.getInstance().getSysUser());
            String operateName = subfunc.getSubFuncDes(neid);
            loginfo.setOperateName(operateName);
            loginfo.setOperateObject(operObj);
            StringBuffer desc = new StringBuffer();
            RowParams rowParams = inputData.getBussinessParams().getRowParams(0);
            this.mgr = TEConfigurationDataMgr.getInstance();
            int slot = Integer.parseInt(rowParams.getParam("slotid").getValue());
            int boardType = this.mgr.getBoardType(neid, slot);
            int port = Integer.parseInt(rowParams.getParam("port").getValue());
            desc.append(this.res.getString("node")).append(":").append(TEBoardUtil.getShelfBoardName((int)neid, (int)slot)).append("-").append(this.getPortName(slot, boardType, port)).append(",");
            desc.append(this.res.getString("vlanid")).append(":").append(rowParams.getParam("vlanid").getValue()).append(",");
            this.appendMpidToLog(desc, rowParams);
            int type = this.appendTypeToLog(desc, rowParams);
            this.appendDirectionToLog(desc, rowParams, port);
            this.appendLevelToLog(desc, rowParams);
            this.appendMDMAToLog(desc, rowParams);
            if (1 == type) {
                this.appendMEPInfoToLog(desc, rowParams);
            }
            loginfo.setOperateDesc(desc.toString());
            int errorCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
            if (0 == errorCode) {
                loginfo.setResult(0);
                loginfo.setErrCode(0);
                loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
            } else {
                this.processFailedOutput(outputData, loginfo, errorCode);
            }
            TELogMgr.writeLog((TELogInfo)loginfo);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Writer Log Fault:\n", (Throwable)e);
            return;
        }
    }

    private void appendMDMAToLog(StringBuffer desc, RowParams rowParams) {
        if (null != rowParams.getParam("mdName")) {
            desc.append(",").append("MD").append(":");
            desc.append(rowParams.getParam("mdName").getValue());
        }
        if (null != rowParams.getParam("maName")) {
            desc.append(",").append("MA").append(":");
            desc.append(rowParams.getParam("maName").getValue());
        }
    }

    private void processFailedOutput(Datainterface outputData, TELogInfo loginfo, int errorCode) {
        loginfo.setResult(2);
        if (1 == errorCode || 2 == errorCode) {
            RowParams rowParams = outputData.getBussinessParams().getRowParams(0);
            int errorCount = rowParams.getRowErrorsCount();
            for (int j = 0; j < errorCount; ++j) {
                RowErrors rowErrors = rowParams.getRowErrors(j);
                loginfo.setErrCode(Integer.parseInt(rowErrors.getErrorMessage().getErrorcode()));
                loginfo.setErrInfo(rowErrors.getErrorMessage().getErrorinfo());
            }
        } else {
            loginfo.setResult(2);
            loginfo.setErrCode(errorCode);
            loginfo.setErrInfo(TEErrorResourceUtil.getErrCodeResWithDot((int)errorCode));
        }
    }

    private void appendMEPInfoToLog(StringBuffer desc, RowParams rowParams) {
        desc.append(",").append(this.res.getString("ccstatus")).append(":");
        int status = Integer.parseInt(rowParams.getParam("ccstatus").getValue());
        if (1 == status) {
            desc.append(this.res.getString("active"));
        } else {
            desc.append(this.res.getString("inactive"));
        }
        desc.append(",").append(this.res.getString("lbtesttime")).append(":").append(rowParams.getParam("lbtesttime").getValue()).append("ms");
        desc.append(",").append(this.res.getString("lttesttime")).append(":").append(rowParams.getParam("lttesttime").getValue()).append("ms");
        desc.append(",").append(this.res.getString("ccperiod")).append(":").append(rowParams.getParam("ccperiod").getValue()).append("ms");
    }

    private void appendLevelToLog(StringBuffer desc, RowParams rowParams) {
        desc.append(this.res.getString("level")).append(":");
        int level = Integer.parseInt(rowParams.getParam("level").getValue());
        String levelStr = "";
        switch (level) {
            case 0: {
                levelStr = this.res.getString("level0");
                break;
            }
            case 1: {
                levelStr = this.res.getString("level1");
                break;
            }
            case 2: {
                levelStr = this.res.getString("level2");
                break;
            }
            case 3: {
                levelStr = this.res.getString("level3");
                break;
            }
            case 4: {
                levelStr = this.res.getString("level4");
                break;
            }
            case 5: {
                levelStr = this.res.getString("level5");
                break;
            }
            case 6: {
                levelStr = this.res.getString("level6");
                break;
            }
            case 7: {
                levelStr = this.res.getString("level7");
                break;
            }
        }
        desc.append(levelStr);
    }

    private void appendDirectionToLog(StringBuffer desc, RowParams rowParams, int port) {
        desc.append(this.res.getString("direction")).append(":");
        int direction = Integer.parseInt(rowParams.getParam("direction").getValue());
        if (0 == direction) {
            desc.append(this.res.getString("doubledirection")).append(",");
        } else if (1 == direction) {
            if (port < 32768) {
                desc.append(this.res.getString("wdmdirection")).append(",");
            } else {
                desc.append(this.res.getString("ipdirection")).append(",");
            }
        } else if (2 == direction) {
            if (port < 32768) {
                desc.append(this.res.getString("ipdirection")).append(",");
            } else {
                desc.append(this.res.getString("wdmdirection")).append(",");
            }
        }
    }

    private int appendTypeToLog(StringBuffer desc, RowParams rowParams) {
        desc.append(this.res.getString("type")).append(":");
        int type = Integer.parseInt(rowParams.getParam("type").getValue());
        if (1 == type) {
            desc.append(this.res.getString("mep")).append(",");
        } else if (2 == type) {
            desc.append(this.res.getString("mip")).append(",");
        }
        return type;
    }

    private void appendMpidToLog(StringBuffer desc, RowParams rowParams) {
        String mpid = rowParams.getParam("mpid").getValue();
        StringBuffer sb = new StringBuffer(15);
        sb.append(mpid.substring(0, 2)).append("-");
        sb.append(mpid.substring(2, 4)).append("-").append(mpid.substring(4));
        desc.append(this.res.getString("mpid")).append(":").append(sb.toString()).append(",");
    }

    private int getUserID(String user) {
        int userID = 0;
        if (TESysManagerConstants.SYS_SINGLE_STATUS != TESysManagerBean.getInstance().getSysStauts()) {
            try {
                userID = Integer.parseInt(user);
            }
            catch (NumberFormatException e) {
                userID = 0;
            }
        }
        return userID;
    }

    private String getPortName(int slotId, int boardType, int portId) {
        String portName = "";
        int portType = this.mgr.getPortType(this.neid, boardType, portId);
        portName = portType == 1025 ? TEConfigurationDataMgr.getMACName((int)portId) : (portType == 61005 ? TEConfigurationDataMgr.getVCTrunkName((int)(portId - 32768)) : this.mgr.getPortName(this.neid, slotId, boardType, portId));
        return portName;
    }
}

