/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam;

import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Option;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethserviceoam.TEEthNodeResourceBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.io.IOStreamConvertor;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public abstract class TEGetEthNodeResourceBeanSuper
extends TENEExplorerBean {
    protected static final String NON_VLANID = "65535";
    protected TEConfigurationDataMgr mgr = null;
    protected Map resourceMap = new HashMap();

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        HashMap vbMap = new HashMap();
        boolean isAdBridgeCMD = true;
        if (null != operationList && operationList.size() > 0) {
            this.mgr = TEConfigurationDataMgr.getInstance();
            int m = operationList.size();
            for (int i = 0; i < m; ++i) {
                Operation operation = (Operation)operationList.get(i);
                if ("NSCMD_ETHN_GET_VLANSWITCHLINK".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getVlanswitchLinkOperRes(operation);
                    continue;
                }
                if ("NSCMD_ETHN_GET_QINQLINK".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getQingLinkOperRes(operation);
                    continue;
                }
                if ("NSCMD_ETHN_GET_LINK".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getETHLinkOperRes(vbMap, operation);
                    continue;
                }
                if ("NSCMD_ETHN_GET_VLAN_TABLE".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getEtheVlanTableOperRes(vbMap, operation);
                    continue;
                }
                if ("NSCMD_ETHN_GET_PORTSVLANVBLINK".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getEthPortSvlanVBLinkOperRes(vbMap, operation);
                    continue;
                }
                if ("NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK".equalsIgnoreCase(operation.getName())) {
                    isAdBridgeCMD = this.getPortCVlanVBLinkOperRes(vbMap, operation);
                    continue;
                }
                if (!"NSCMD_ETHN_GET_LINK_BY_VB_EX".equalsIgnoreCase(operation.getName())) continue;
                this.getEthLinkByVBOperRes(vbMap, isAdBridgeCMD, operation);
            }
        }
        this.processOutputData(neid);
    }

    private void processOutputData(int neid) {
        this.outputData = new Datainterface();
        this.outputData.setBussinessParams(new BussinessParams());
        int slotId = -1;
        Set entrySet = this.resourceMap.entrySet();
        for (Map.Entry entry2 : entrySet) {
            TEEthNodeResourceBean resource = (TEEthNodeResourceBean)entry2.getKey();
            slotId = resource.getSlotId();
            RowParams rowParams = new RowParams();
            Param param = new Param("subrackname", TEBoardUtil.getSubrackNameFromSlot((int)neid, (int)slotId));
            rowParams.addParam(param);
            param = new Param("slot", String.valueOf(slotId));
            rowParams.addParam(param);
            param = new Param("boardname", resource.getBoardName());
            rowParams.addParam(param);
            param = new Param("port", String.valueOf(resource.getPortId()));
            rowParams.addParam(param);
            param = new Param("portname", resource.getPortName());
            rowParams.addParam(param);
            param = new Param("vlanid", "");
            Map map = (Map)entry2.getValue();
            Set entrySet1 = map.entrySet();
            for (Map.Entry entry2 : entrySet1) {
                int key = (Integer)entry2.getKey();
                ArrayList list = (ArrayList)entry2.getValue();
                int m = list.size();
                for (int i = 0; i < m; ++i) {
                    String value = ((String)list.get(i)).trim();
                    if (m > 1 && value.equals(NON_VLANID) || "".equals(value)) continue;
                    if (param.getValue().equals("")) {
                        param.setValue(key + "-" + value);
                        continue;
                    }
                    Option option = new Option(key + "-" + value);
                    param.addOption(option);
                }
            }
            rowParams.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowParams);
        }
    }

    private void getEthLinkByVBOperRes(Map vbMap, boolean isAdBridgeCMD, Operation operation) {
        Output[] outputes = operation.getOutput();
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode()) || !isAdBridgeCMD) continue;
                Integer vbPort = Integer.valueOf(output.getPartValue("ingressport"));
                int slotId = Integer.parseInt(output.getPartValue("slotid"));
                int linkId = Integer.parseInt(output.getPartValue("linkid"));
                int portId = Integer.parseInt(output.getPartValue("egressport"));
                String vlanId = output.getPartValue("svlan");
                this.addResource(slotId, portId, linkId, vlanId);
                TEEthNodeResourceBean res = new TEEthNodeResourceBean();
                res.setSlotId(slotId);
                res.setPortId(portId);
                res.setLinkId(linkId);
                vbMap.put(vbPort, res);
            }
        }
    }

    private boolean getPortCVlanVBLinkOperRes(Map vbMap, Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                Integer vbPort = Integer.valueOf(output.getPartValue("vbport"));
                int slotId = Integer.parseInt(output.getPartValue("slotid"));
                int linkId = Integer.parseInt(output.getPartValue("linkid"));
                int portId = Integer.parseInt(output.getPartValue("portid"));
                String vlanId = output.getPartValue("cvlan");
                this.addResource(slotId, portId, linkId, vlanId);
                TEEthNodeResourceBean res = new TEEthNodeResourceBean();
                res.setSlotId(slotId);
                res.setPortId(portId);
                res.setLinkId(linkId);
                vbMap.put(vbPort, res);
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    private boolean getEthPortSvlanVBLinkOperRes(Map vbMap, Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                Integer vbPort = Integer.valueOf(output.getPartValue("vbport"));
                int slotId = Integer.parseInt(output.getPartValue("slotid"));
                int linkId = Integer.parseInt(output.getPartValue("linkid"));
                int portId = Integer.parseInt(output.getPartValue("portid"));
                String vlanId = output.getPartValue("svlan");
                this.addResource(slotId, portId, linkId, vlanId);
                TEEthNodeResourceBean res = new TEEthNodeResourceBean();
                res.setSlotId(slotId);
                res.setPortId(portId);
                res.setLinkId(linkId);
                vbMap.put(vbPort, res);
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    protected int handleNpos(int pos) {
        return pos;
    }

    private boolean getEtheVlanTableOperRes(Map vbMap, Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                String vlanId = output.getPartValue("vlanid");
                byte[] bValue = output.getPartValue("portNoList").getBytes();
                int nCount = 4;
                int nPos = 0;
                int nParaSize = bValue.length;
                while (nPos + nCount <= nParaSize) {
                    TEEthNodeResourceBean res;
                    byte[] bTmp = new byte[4];
                    nPos = this.handleNpos(nPos);
                    System.arraycopy(bValue, nPos + 0, bTmp, 0, 4);
                    Integer portId = new Integer(IOStreamConvertor.readPositiveInt((byte[])bTmp, (int)0));
                    if (vbMap.containsKey(portId) && this.resourceMap.containsKey(res = (TEEthNodeResourceBean)vbMap.get(portId))) {
                        Integer linkid = new Integer(res.getLinkId());
                        Map map = (Map)this.resourceMap.get(res);
                        if (map.containsKey(linkid)) {
                            ArrayList list = (ArrayList)map.get(linkid);
                            list.add(vlanId);
                        }
                    }
                    nPos += nCount;
                }
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    private boolean getETHLinkOperRes(Map vbMap, Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                Integer vbPort = Integer.valueOf(output.getPartValue("ingressport"));
                int slotId = Integer.parseInt(output.getPartValue("slotid"));
                int linkId = Integer.parseInt(output.getPartValue("linkid"));
                int portId = Integer.parseInt(output.getPartValue("egressport"));
                String vlanId = output.getPartValue("ingressvlanid");
                this.addResource(slotId, portId, linkId, vlanId);
                TEEthNodeResourceBean res = new TEEthNodeResourceBean();
                res.setSlotId(slotId);
                res.setPortId(portId);
                res.setLinkId(linkId);
                vbMap.put(vbPort, res);
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    private boolean getQingLinkOperRes(Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                int slotId = Integer.parseInt(output.getPartValue("slotID"));
                int linkId = Integer.parseInt(output.getPartValue("linkID"));
                int portId = Integer.parseInt(output.getPartValue("srcPort"));
                String cVlanId = output.getPartValue("srcVlan");
                String sVlanId = output.getPartValue("srcSVlan");
                if (!NON_VLANID.equals(sVlanId)) {
                    this.addResource(slotId, portId, linkId, sVlanId);
                } else {
                    this.addResource(slotId, portId, linkId, cVlanId);
                }
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    private boolean getVlanswitchLinkOperRes(Operation operation) {
        Output[] outputes = operation.getOutput();
        boolean isAdBridge = true;
        if (null != outputes && outputes.length > 0) {
            for (Output output : outputes) {
                if (!"0".equalsIgnoreCase(output.getFault(0).getCode())) continue;
                int slotId = Integer.parseInt(output.getPartValue("slotID"));
                int linkId = Integer.parseInt(output.getPartValue("linkID"));
                int portId = Integer.parseInt(output.getPartValue("srcPort"));
                String vlanId = output.getPartValue("srcVlan");
                this.addResource(slotId, portId, linkId, vlanId);
                isAdBridge = false;
            }
        }
        return isAdBridge;
    }

    private void addResource(int slotId, int portId, int linkId, String vlanId) {
        int boardType = this.mgr.getBoardType(this.neid, slotId);
        String boardName = this.mgr.getBoardTypeName(this.neid, boardType);
        TEEthNodeResourceBean resource = new TEEthNodeResourceBean();
        resource.setSlotId(slotId);
        resource.setBoardName(boardName);
        resource.setPortId(portId);
        resource.setPortName(this.getPortName(slotId, boardType, portId));
        Map<Integer, ArrayList> map = null;
        ArrayList list = null;
        Integer link = new Integer(linkId);
        if (this.resourceMap.containsKey(resource)) {
            map = (Map)this.resourceMap.get(resource);
            if (map.containsKey(link)) {
                list = (ArrayList)map.get(link);
                list.add(vlanId);
            } else {
                list = new ArrayList();
                list.add(vlanId);
                map.put(link, list);
            }
        } else {
            map = new HashMap();
            list = new ArrayList();
            list.add(vlanId);
            map.put(link, list);
            this.resourceMap.put(resource, map);
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }

    protected abstract String getPortName(int var1, int var2, int var3);
}

