/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01;

import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEVBInfoListIF;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEVBInfoListImplOnS
implements TEVBInfoListIF {
    private static final int VBPORT_FLG = 28672;
    private static final String NA_VALUESTR = "65535";
    private HashMap vbMemMap = new HashMap();
    private ArrayList otherLinkPortList = new ArrayList();
    private ArrayList linkIdList = new ArrayList();
    private static String Bidirection_VBLink = "4";
    private int neID;
    private int slotID;

    public TEVBInfoListImplOnS(int neID, int slotID) {
        this.neID = neID;
        this.slotID = slotID;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    @Override
    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    @Override
    public void clearMemData() {
        this.vbMemMap.clear();
        this.otherLinkPortList.clear();
        this.linkIdList.clear();
    }

    @Override
    public ArrayList getLinkPortList(String vbid) {
        return (ArrayList)this.vbMemMap.get(vbid);
    }

    @Override
    public void addItem(String vbid) {
        ArrayList linkPortList = new ArrayList();
        this.vbMemMap.put(vbid, linkPortList);
    }

    @Override
    public void initVBLink(String vbid, int lpCount) {
        ArrayList linkPortList = null;
        if (!this.hasVB(vbid)) {
            return;
        }
        linkPortList = this.getLinkPorts(vbid);
        TELinkPortInfo linkPortInfo = null;
        int lpNo = 0;
        for (int i = 0; i < lpCount; ++i) {
            linkPortInfo = new TELinkPortInfo();
            lpNo = 28672 + i + 1;
            linkPortInfo.setLpNo(String.valueOf(lpNo));
            linkPortList.add(linkPortInfo);
        }
    }

    @Override
    public void addPort(String vbid, String lpNo, TELinkPortInfo linkPort) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        linkPortList.add(linkPort);
    }

    @Override
    public void setPortAttribute(String linkid, String vbid, String lpNo, String portid, String direction) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        this.addLinkIdList(linkid);
        linkPort.setPortAttribute(linkid, lpNo, portid, "4", "2", NA_VALUESTR, NA_VALUESTR);
    }

    @Override
    public void setPortAttribute(String vbid, String linkid, String lpNo, String portid, String direction, String opertype, String porttype, String cvlan, String svlan) {
        TELinkPortInfo linkPort = new TELinkPortInfo();
        this.addLinkIdList(linkid);
        linkPort.setPortAttribute(linkid, lpNo, portid, opertype, porttype, cvlan, svlan);
        ArrayList linkPortList = this.getLinkPortList(vbid);
        linkPortList.add(linkPort);
    }

    @Override
    public void delPortAttribute(String vbid, String lpNo) {
        TELinkPortInfo linkPort = this.getLinkPortInfoByLpNo(vbid, lpNo);
        linkPort.clearAllAttribute();
        String linkid = linkPort.getLinkid();
        if (!linkid.equals("") && !linkid.equals("0") && this.linkIdList.contains(Integer.valueOf(linkid))) {
            this.linkIdList.remove(Integer.valueOf(linkid));
        }
    }

    @Override
    public void delPBLink(String vbid, String linkid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        int len = linkPortList.size();
        for (int i = 0; i < len; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (!tempLinkPort.getLinkid().equals(linkid)) continue;
            linkPortList.remove(i);
            this.linkIdList.remove(Integer.valueOf(linkid));
            break;
        }
    }

    @Override
    public void delVB(String vbid) {
        this.vbMemMap.remove(vbid);
    }

    @Override
    public boolean hasVB(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        return null != linkPortList;
    }

    @Override
    public boolean hasVBLink(String vbid) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPortList.get(i);
            if (null == tempLinkPort.getPortId() || !tempLinkPort.getPortId().equals("") || !tempLinkPort.getPortId().equals("0")) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getLinkPorts(String vbid) {
        ArrayList portList = this.getLinkPortList(vbid);
        Collections.sort(portList);
        return portList;
    }

    @Override
    public ArrayList getPortIdsByVB(String vbid) {
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList portList = this.getLinkPorts(vbid);
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getPortId().equals("0")) continue;
            portidList.add(tempLinkPort.getPortId());
        }
        return portidList;
    }

    @Override
    public void addOtherLinkPort(String linkPortId) {
        if (this.otherLinkPortList.contains(linkPortId)) {
            return;
        }
        this.otherLinkPortList.add(linkPortId);
    }

    @Override
    public void clearOtherLinkPort() {
        this.otherLinkPortList.clear();
    }

    @Override
    public ArrayList getOtherLinkPortList() {
        return this.otherLinkPortList;
    }

    @Override
    public void addLinkIdList(String linkid) {
        if (this.linkIdList.contains(linkid)) {
            return;
        }
        this.linkIdList.add(Integer.valueOf(linkid));
        Collections.sort(this.linkIdList);
    }

    @Override
    public void delLinkIdFromList(String linkid) {
        this.linkIdList.remove(Integer.valueOf(linkid));
    }

    @Override
    public ArrayList getAllLinkId() {
        return this.linkIdList;
    }

    @Override
    public ArrayList getAvailableLinkId(int linkCount) {
        int i;
        ArrayList<Integer> availLinkIdList = new ArrayList<Integer>();
        int count = 0;
        int dispersion = 0;
        int newlinkid = 0;
        int listlen = this.linkIdList.size();
        for (i = 0; i < listlen - 1; ++i) {
            newlinkid = (Integer)this.linkIdList.get(i);
            dispersion = (Integer)this.linkIdList.get(i + 1) - newlinkid;
            if (dispersion <= 1) continue;
            count += dispersion - 1;
            for (int j = 0; j < dispersion; ++j) {
                availLinkIdList.add(++newlinkid);
            }
        }
        if (count < linkCount) {
            newlinkid = this.linkIdList.isEmpty() ? 0 : (Integer)this.linkIdList.get(this.linkIdList.size() - 1);
            for (i = 0; i < linkCount - count; ++i) {
                availLinkIdList.add(++newlinkid);
            }
        }
        return availLinkIdList;
    }

    @Override
    public void deleteLinkportByLinkid(String vbid, ArrayList linkPortList) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        if (null == linkPorts) {
            return;
        }
        boolean pblinktypeflg = false;
        int listlen = linkPorts.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (tempLinkPort.getLinkType().equals(Bidirection_VBLink)) {
                if (!linkPortList.contains(tempLinkPort.getLinkid())) continue;
                this.linkIdList.remove(Integer.valueOf(tempLinkPort.getLinkid()));
                tempLinkPort.clearAllAttribute();
                continue;
            }
            if (tempLinkPort.getPortId().equals("0")) continue;
            pblinktypeflg = true;
            break;
        }
        if (pblinktypeflg) {
            this.deletePBPortByLinkid(vbid, linkPortList);
        }
    }

    @Override
    public void deletePBPortByLinkid(String vbid, ArrayList linkPortList) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        if (null == linkPorts) {
            return;
        }
        for (int i = linkPorts.size() - 1; i >= 0; --i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (!linkPortList.contains(tempLinkPort.getLinkid())) continue;
            this.linkIdList.remove(Integer.valueOf(tempLinkPort.getLinkid()));
            linkPorts.remove(i);
        }
    }

    @Override
    public String getLinkPortByLinkId(String vbid, String linkId) {
        ArrayList linkPorts = this.getLinkPortList(vbid);
        String aportid = "";
        if (null == linkPorts) {
            return aportid;
        }
        int listlen = linkPorts.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)linkPorts.get(i);
            if (!tempLinkPort.getLinkid().equals(linkId)) continue;
            aportid = tempLinkPort.getPortId();
            break;
        }
        return aportid;
    }

    @Override
    public ArrayList getAllUsedPort() {
        ArrayList<Integer> usedPortList = new ArrayList<Integer>();
        Iterator memMapIt = this.vbMemMap.values().iterator();
        ArrayList linkPorts = null;
        TELinkPortInfo linkPortInfo = null;
        while (memMapIt.hasNext()) {
            linkPorts = (ArrayList)memMapIt.next();
            int len = linkPorts.size();
            for (int i = 0; i < len; ++i) {
                linkPortInfo = (TELinkPortInfo)linkPorts.get(i);
                if (linkPortInfo.getPortId().equals("0") || usedPortList.contains(Integer.valueOf(linkPortInfo.getPortId()))) continue;
                usedPortList.add(Integer.valueOf(linkPortInfo.getPortId()));
            }
        }
        if (null != this.otherLinkPortList && 0 == this.otherLinkPortList.size()) {
            usedPortList.addAll(this.otherLinkPortList);
        }
        return usedPortList;
    }

    @Override
    public TELinkPortInfo getLinkPortInfoByLpNo(String vbid, String lpNo) {
        ArrayList linkPortList = this.getLinkPortList(vbid);
        if (null == linkPortList) {
            return null;
        }
        TELinkPortInfo aInfo = null;
        boolean nullflg = false;
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            aInfo = (TELinkPortInfo)linkPortList.get(i);
            if (aInfo.getLpNo().equals(lpNo)) {
                nullflg = false;
                break;
            }
            nullflg = true;
        }
        if (nullflg) {
            return null;
        }
        return aInfo;
    }

    @Override
    public ArrayList getLinkIds(String vbid) {
        ArrayList<String> linkIdList = new ArrayList<String>();
        ArrayList portList = null;
        portList = this.getLinkPorts(vbid);
        int listlen = portList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getLinkid().equals("0")) continue;
            linkIdList.add(tempLinkPort.getLinkid());
        }
        return linkIdList;
    }

    @Override
    public TEErrInfoReturn getTELinkPortInfoDB(int neID, int slotID, int vbID, Map<Integer, List<TELinkPortInfo>> linkPortInfoMap) {
        ArrayList linkPortList = this.getLinkPortList(String.valueOf(vbID));
        TELinkPortInfo aInfo = null;
        List<TELinkPortInfo> tempLinkPortList = null;
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            aInfo = (TELinkPortInfo)linkPortList.get(i);
            if (!TEStringUtils.isNumber((String)aInfo.getLpNo())) continue;
            tempLinkPortList = linkPortInfoMap.get(aInfo.getLpNo());
            if (null == tempLinkPortList) {
                tempLinkPortList = new ArrayList<TELinkPortInfo>();
                linkPortInfoMap.put(Integer.parseInt(aInfo.getLpNo()), tempLinkPortList);
            }
            tempLinkPortList.add(aInfo);
        }
        return new TEErrInfoReturn();
    }
}

