/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TEParseXMLFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TEParseEthLanConfFile {
    private static TEParseEthLanConfFile instance = null;
    private Map logFuncNodeMap = new HashMap();
    private static final String FILE_NAME = "ethlanconf.xml";

    private TEParseEthLanConfFile() {
    }

    public static synchronized TEParseEthLanConfFile getInstance() {
        if (instance == null) {
            instance = new TEParseEthLanConfFile();
        }
        return instance;
    }

    private void parseXMLFile(int neid) {
        Document doc = null;
        try {
            StringBuffer filepathname = new StringBuffer("nemgr").append(File.separator).append("ip").append(File.separator).append("ngwdm").append(File.separator).append("conf").append(File.separator).append("ethlanservice_v2r7c01").append(File.separator).append(FILE_NAME);
            Bundle bundle = FrameworkUtil.getBundle(this.getClass());
            doc = TEParseXMLFile.parseFile((Bundle)bundle, (String)filepathname.toString());
            if (null == doc) {
                TELogFactory.getNormalLogger().info("Parse log file fail!");
                return;
            }
            Element root = doc.getDocumentElement();
            NodeList children = root.getChildNodes();
            int size = children.getLength();
            for (int i = 0; i < size; ++i) {
                Node aNode = children.item(i);
                if (!(aNode instanceof Element)) continue;
                String nodeName = aNode.getAttributes().getNamedItem("cp_type").getNodeValue();
                this.logFuncNodeMap.put(nodeName, aNode);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("Get log info failed", (Throwable)e);
        }
    }

    public Node getNodeByFuncCode(int neid, String cptype) {
        Object returnNode;
        if (this.logFuncNodeMap.isEmpty()) {
            this.parseXMLFile(neid);
        }
        return (returnNode = this.logFuncNodeMap.get(cptype)) == null ? null : (Node)returnNode;
    }

    public String getChildNodeAttrValue(int neid, String cptype, String nodeName, String noAttrName) {
        String vbarrStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode || null == boardInfoNode.getChildNodes()) {
            return vbarrStr;
        }
        NodeList attrList = boardInfoNode.getChildNodes();
        Node attrNode = null;
        int nodelen = attrList.getLength();
        for (int i = 0; i < nodelen; ++i) {
            attrNode = attrList.item(i);
            if (!(attrNode instanceof Element) || !attrNode.getNodeName().equals(nodeName)) continue;
            vbarrStr = attrNode.getAttributes().getNamedItem(noAttrName).getNodeValue();
            break;
        }
        if (-1 == vbarrStr.indexOf(91)) {
            return vbarrStr;
        }
        vbarrStr = this.parseListString(vbarrStr);
        return vbarrStr;
    }

    public String getOpetionStr(int neid, String cptype, String nodeName, String noAttrName) {
        String optionStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode || null == boardInfoNode.getChildNodes()) {
            return optionStr;
        }
        NodeList attrList = boardInfoNode.getChildNodes();
        Node attrNode = null;
        NodeList optionNodeList = null;
        String[] vbtypeStrArr = this.getChildNodeAttrValue(neid, cptype, nodeName, noAttrName).split(",");
        int nodelen = attrList.getLength();
        for (int i = 0; i < nodelen; ++i) {
            attrNode = attrList.item(i);
            if (!(attrNode instanceof Element) || !attrNode.getNodeName().equals(nodeName)) continue;
            optionNodeList = attrNode.getChildNodes();
            break;
        }
        if (optionNodeList == null) {
            TELogFactory.getNormalLogger().error("optionNodeList failed!");
        } else {
            optionStr = this.handleOptionMap(optionNodeList, vbtypeStrArr);
        }
        return optionStr;
    }

    public String handleOptionMap(NodeList optionNodeList, String[] vbtypeStrArr) {
        StringBuffer optionStrBuf = new StringBuffer();
        Node attrNode = null;
        int arrIndex = 0;
        for (int i = 0; i < optionNodeList.getLength(); ++i) {
            String optionStr = "";
            attrNode = optionNodeList.item(i);
            if (attrNode instanceof Element && attrNode.getNodeName().equals("option")) {
                optionStr = attrNode.getAttributes().getNamedItem("mode").getNodeValue();
            }
            if (-1 != optionStr.indexOf(91)) {
                optionStr = this.parseListString(optionStr);
            }
            if ("".equals(optionStr) || arrIndex >= vbtypeStrArr.length) continue;
            optionStrBuf.append(vbtypeStrArr[arrIndex]).append(':').append(optionStr).append(';');
            ++arrIndex;
        }
        if (optionStrBuf.length() == 0) {
            return "";
        }
        return optionStrBuf.toString().substring(0, optionStrBuf.length() - 1);
    }

    public String getNodeAttrValue(int neid, String cptype, String attrName) {
        String vbStaticStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype);
        if (null == boardInfoNode) {
            return vbStaticStr;
        }
        vbStaticStr = boardInfoNode.getAttributes().getNamedItem(attrName).getNodeValue();
        return vbStaticStr;
    }

    public String getNodeAttrValue(int neid, String netype, String cptype, String attrName) {
        String vbStaticStr = "";
        Node boardInfoNode = this.getNodeByFuncCode(neid, cptype + "-" + netype);
        if (null == boardInfoNode) {
            return this.getNodeAttrValue(neid, cptype, attrName);
        }
        vbStaticStr = boardInfoNode.getAttributes().getNamedItem(attrName).getNodeValue();
        return vbStaticStr;
    }

    private String parseListString(String vbtypeSting) {
        String arrStr = "";
        StringBuffer arrStrBuf = new StringBuffer();
        if (null == vbtypeSting || "".equals(vbtypeSting.trim())) {
            return arrStr;
        }
        arrStr = vbtypeSting.substring(1, vbtypeSting.length() - 1);
        if (-1 == arrStr.indexOf(45)) {
            return arrStr;
        }
        String[] stringlistarr = arrStr.split(",");
        String listStr = null;
        int minno = -1;
        int maxno = -1;
        for (int i = stringlistarr.length - 1; i >= 0; --i) {
            listStr = stringlistarr[i];
            if (listStr.indexOf(45) > 0) {
                minno = Integer.parseInt(listStr.split("-")[0]);
                maxno = Integer.parseInt(listStr.split("-")[1]);
                for (int portno = minno; portno <= maxno; ++portno) {
                    if (0 != arrStrBuf.length()) {
                        arrStrBuf.append(',');
                    }
                    arrStrBuf.append((Object)portno);
                }
                continue;
            }
            if (0 != arrStrBuf.length()) {
                arrStrBuf.append(',');
            }
            arrStrBuf.append(Integer.valueOf(listStr));
        }
        return arrStrBuf.toString();
    }
}

