/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;

public class TEGetAvailablePortBean
extends TEVBMgrSuperBean {
    private static final int VB_AVAILPORT_NOT_ENOUGH = 140107;
    private static final int VBTRUNKFLG = 32768;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.TIME_OUT = 40;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            int slotid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
            TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
            ArrayList ethportList = configurDataMgr.getLogicPortList(neid, slotid);
            ArrayList vctrunkList = configurDataMgr.getETHVCTrunkPort(neid, slotid, configurDataMgr.getBoardType(neid, slotid));
            ethportList.addAll(vctrunkList);
            if (ethportList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)140107));
            } else {
                super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        int result;
        super.handleMessage(neid, operationList, subfunc);
        RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int neType = cfgMgr.getNE(neid).getNEType();
        int slotId = Integer.valueOf(this.inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardType = cfgMgr.getBoardType(neid, slotId);
        int subrackType = TEGetNEDomainVersion.getInstance().getDevType(TEBoardUtil.getSubrackType((int)neid, (int)neType, (int)slotId));
        RowParams rowParams = null;
        Param param = null;
        int portId = -1;
        String portName = "";
        ArrayList operList = new ArrayList();
        for (int i = rowParamses.length - 1; i >= 0; --i) {
            rowParams = rowParamses[i];
            if (rowParams.getParam("port") == null) continue;
            portId = Integer.parseInt(rowParams.getParam("port").getValue());
            if (portId - 32768 > 0) {
                TEPortParaRecord record = TECircuitPackDescription.getInstance().getCPPortPara(boardType, portId);
                if (null != record && null != record.boardModeList && !record.boardModeList.contains(subrackType)) {
                    this.outputData.getBussinessParams().removeRowParams(i);
                    continue;
                }
                portName = "VCTRUNK" + (portId - 32768);
            } else {
                portName = "PORT" + portId;
            }
            rowParams.getParam("portname").setValue(portName);
            rowParams.getParam("port").setName("portid");
            if (boardType == 2272 || boardType == 3005) {
                operList.addAll(this.createOperationList(neid, String.valueOf(slotId), String.valueOf(portId)));
                param = new Param("portModel", "-");
                rowParams.addParam(param);
                param = new Param("portSpeedLevel", "-");
                rowParams.addParam(param);
                continue;
            }
            if (!cfgMgr.isDynPort(neid, boardType, portId)) continue;
            param = new Param();
            param.setName("portSpeedLevel");
            param.setValue(String.valueOf(cfgMgr.getInstance().getCacheSpeed(neid, slotId, portId)));
            rowParams.addParam(param);
            param = new Param();
            param.setName("portModel");
            param.setValue(String.valueOf(cfgMgr.getInstance().getCachePortType(neid, slotId, portId)));
            rowParams.addParam(param);
        }
        if (!operList.isEmpty() && (result = this.sendMessage(neid, operList)) == 0) {
            this.handlePortMessage(operList, rowParamses);
        }
    }

    private ArrayList createOperationList(int neid, String slotId, String portId) {
        ArrayList<Object> operList = new ArrayList<Object>();
        if (Integer.parseInt(portId) > 4 && Integer.parseInt(portId) < 32768) {
            Operation operation = null;
            Input input = null;
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PORT");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("portID", portId);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PAYLOADTYPE");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("port", portId);
            input.setPartValue("path", "1");
            operList.add(operation.clone());
        }
        return operList;
    }

    private void handlePortMessage(ArrayList operList, RowParams[] rowParamses) {
        int NSCMD_CFG_GET_PORT = 28771;
        int NSCMD_CFG_GET_PAYLOADTYPE = 34827;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : rowParamses) {
            String portid = rowParams2.getParam("portid").getValue();
            int size = operList.size();
            for (int j = 0; j < size; ++j) {
                String temp;
                Operation operation = (Operation)operList.get(j);
                if (operation.getCmdid() == 28771) {
                    if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("portID"))) continue;
                    temp = operation.getOutput(0).getPartValue("portType");
                    rowParams2.getParam("portModel").setValue(temp);
                    continue;
                }
                if (operation.getCmdid() != 34827) continue;
                if (portid.equals("3") || portid.equals("4")) {
                    rowParams2.getParam("portSpeedLevel").setValue("258");
                    continue;
                }
                if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                temp = operation.getOutput(0).getPartValue("W32PORT_ATTR_ST_SERVICETYPE");
                rowParams2.getParam("portSpeedLevel").setValue(temp);
            }
        }
    }

    public boolean isNeedOperationlog() {
        return false;
    }
}

