/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.observer;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEGetEthInfAttr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBBeanOberverSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEInactiveVBMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEQueryVBDBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TERowParamAppender;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEVBInfoListUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEParseEthLanConfFile;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEQueryVBBean;
import com.huawei.nglct.nemgr.necommon.gencfg.TEGenObjectID;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TEQueryVBBeanObserver
extends TEVBBeanOberverSuper {
    public static final int NA_VALUE = 65535;
    public static final String NA_VALUESTR = "65535";
    public static final String ADD_SVLAN_BASE_PORT = "0";
    public static final String ADD_SVLAN_BASE_PORT_AND_CVLAN = "1";
    public static final String MOUNT_PORT_AND_BASE_PORT_AND_SVLAN = "3";
    public static final String LINK_COMMON = "1";
    public static final String ACTIVE_STATE = String.valueOf(1);
    public static final String INACTIVE_STATE = String.valueOf(0);
    private static final List<String> vctrunkAttrList = new ArrayList<String>();
    private static final List<String> portAttrList = new ArrayList<String>();
    private Map<Integer, TEEtherBridgeMOPO> vbMOMap = new HashMap<Integer, TEEtherBridgeMOPO>();

    @Override
    public void doBeforePerfomBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface outputData) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        this.addWnemgrBusClassMapping(subFunc);
    }

    @Override
    public void perfomWNEMgrBussinessProcess(int neID, Datainterface inputData, Datainterface outputData) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        int slotID = TEVBInfoListUtil.getSlotID(inputData);
        if (outputData.getBussinessParams() == null) {
            return;
        }
        this.appendIsActiveParamForActiveVB(outputData);
        boolean isExitInactiveVB = this.appendInactiveVBRow(neID, slotID, inputData, outputData);
        if (isExitInactiveVB) {
            String vbIDStr = TEQueryVBBeanObserver.getVBID(inputData);
            TEQueryVBBean.initLinkPortParam(neID, slotID, vbIDStr, outputData);
            this.appendPortParam(neID, slotID, vbIDStr, outputData);
            this.appendAffixParam(neID, outputData);
        }
    }

    private void appendIsActiveParamForActiveVB(Datainterface outputData) {
        Param param = null;
        RowParams[] rowparams = outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            param = rowparams[i].getParam("isVBData");
            if (0 != rowparams[i].getRowErrorsCount() || null != param && String.valueOf(0).equals(param.getValue())) continue;
            param = new Param("isactive", ACTIVE_STATE);
            rowparams[i].addParam(param);
        }
    }

    private boolean appendInactiveVBRow(int neID, int slotID, Datainterface inputData, Datainterface outputData) {
        List<RowParams> inactiveVBRowList = TEInactiveVBMgr.buildInactiveVBRow(neID, slotID);
        if (inactiveVBRowList.isEmpty()) {
            return false;
        }
        for (RowParams row : inactiveVBRowList) {
            outputData.getBussinessParams().addRowParams(row);
        }
        return true;
    }

    private void appendAffixParam(int neID, Datainterface outputData) {
        Param param = null;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, 2108741);
        RowParams[] rowparams = outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            param = rowparams[i].getParam("isactive");
            if (0 != rowparams[i].getRowErrorsCount() || null != param && ACTIVE_STATE.equals(param.getValue())) continue;
            TERowParamAppender.handleRowData(neID, subFunc, rowparams[i]);
        }
    }

    private void appendPortParam(int neID, int slotID, String vbid, Datainterface outputData) {
        Set<Integer> portSet = this.buildPortSet(neID, outputData);
        List<TEGnlValueElement> elementList = this.buildReqElement(neID, slotID, portSet);
        TEDaoOperationResult result = TEGetEthInfAttr.getElementFromDB(elementList);
        Map<Integer, Map<Integer, Integer>> portAttrMap = this.buildPortAttrMap(result);
        this.resetPortParam(outputData, portAttrMap);
    }

    private Set<Integer> buildPortSet(int neID, Datainterface outputData) {
        HashSet<Integer> portSet = new HashSet<Integer>();
        int portID = -1;
        Param param = null;
        RowParams[] rowparams = outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            param = rowparams[i].getParam("isVBData");
            if (0 != rowparams[i].getRowErrorsCount() || null != param && String.valueOf(1).equals(param.getValue()) || null != (param = rowparams[i].getParam("isactive")) && !INACTIVE_STATE.equals(param.getValue()) || 0 == (portID = Integer.parseInt((param = rowparams[i].getParam("portid")).getValue()))) continue;
            portSet.add(portID);
        }
        return portSet;
    }

    private List<TEGnlValueElement> buildReqElement(int neID, int slotID, Set<Integer> portSet) {
        int portID2 = -1;
        String attrName = null;
        TEGnlValueElement element = null;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>(portSet.size());
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEGenCfgFunCmd funCmd = TEGetEthInfAttr.getFunCmd(ne);
        for (int portID2 : portSet) {
            int i;
            int len;
            if (0 == portID2) continue;
            if (portID2 > 32768) {
                len = vctrunkAttrList.size();
                for (i = 0; i < len; ++i) {
                    attrName = vctrunkAttrList.get(i);
                    element = this.buildReqElement(neID, slotID, portID2, attrName, funCmd);
                    elementList.add(element);
                }
                continue;
            }
            len = portAttrList.size();
            for (i = 0; i < len; ++i) {
                attrName = portAttrList.get(i);
                element = this.buildReqElement(neID, slotID, portID2, attrName, funCmd);
                elementList.add(element);
            }
        }
        return elementList;
    }

    private TEGnlValueElement buildReqElement(int neID, int slotID, int portID, String attrName, TEGenCfgFunCmd funCmd) {
        Input input = new Input();
        Part part = new Part();
        part.setName("slotid");
        part.setValue(String.valueOf(slotID));
        input.addPart(part);
        part = new Part();
        part.setName("port");
        part.setValue(String.valueOf(portID));
        input.addPart(part);
        part = new Part();
        part.setName(attrName);
        part.setValue(String.valueOf(ADD_SVLAN_BASE_PORT));
        input.addPart(part);
        TEGnlValueElement element = TEEthInfUtil.constructElement(neID, funCmd, new TEPartSource(input), attrName, null);
        return element;
    }

    private Map<Integer, Map<Integer, Integer>> buildPortAttrMap(TEDaoOperationResult result) {
        int portID = -1;
        int attrID = -1;
        TEGeneralKeyValue key = null;
        TEGnlValueElement ele2 = null;
        HashMap<Integer, Integer> attrMap = null;
        HashMap<Integer, Map<Integer, Integer>> portAttrMap = new HashMap<Integer, Map<Integer, Integer>>();
        List data = result.getData();
        if (!data.isEmpty()) {
            for (TEGnlValueElement ele2 : data) {
                key = ele2.getGnlKeyValue();
                attrID = key.getAttrID();
                portID = this.getPortID(key);
                attrMap = (HashMap<Integer, Integer>)portAttrMap.get(portID);
                if (null == attrMap) {
                    attrMap = new HashMap<Integer, Integer>();
                    portAttrMap.put(portID, attrMap);
                }
                attrMap.put(attrID, ele2.getGnlValue().getiValue());
            }
        }
        return portAttrMap;
    }

    private void resetPortParam(Datainterface outputData, Map<Integer, Map<Integer, Integer>> portAttrMap) {
        int portID = -1;
        Map<Integer, Integer> attrMap = null;
        Param param = null;
        RowParams[] rowparams = outputData.getBussinessParams().getRowParams();
        int len = rowparams.length;
        for (int i = 0; i < len; ++i) {
            param = rowparams[i].getParam("isVBData");
            if (0 != rowparams[i].getRowErrorsCount() || null != param && String.valueOf(1).equals(param.getValue()) || null != (param = rowparams[i].getParam("isactive")) && ACTIVE_STATE.equals(param.getValue()) || 0 == (portID = Integer.parseInt((param = rowparams[i].getParam("portid")).getValue()))) continue;
            attrMap = portAttrMap.get(portID);
            if (null != attrMap && portID > 32768) {
                this.resetVctrunkPortParam(attrMap, rowparams[i]);
            }
            if (null == attrMap || portID >= 32768) continue;
            this.resetMacPortParam(attrMap, rowparams[i]);
        }
    }

    private void resetMacPortParam(Map<Integer, Integer> attrMap, RowParams rowparams) {
        this.setAttrValue(rowparams, "porttype", 401505, attrMap);
        this.setAttrValue(rowparams, "portenable", 401491, attrMap);
        this.setAttrValue(rowparams, "portTag", 401488, attrMap);
        this.setAttrValue(rowparams, "VLAN", 401489, attrMap);
        this.setAttrValue(rowparams, "ATTR_ETHOVERSDH_MAC_WORKMODE", 401492, attrMap);
    }

    private void resetVctrunkPortParam(Map<Integer, Integer> attrMap, RowParams rowparams) {
        this.setAttrValue(rowparams, "porttype", 401520, attrMap);
        this.setAttrValue(rowparams, "portTag", 401510, attrMap);
        this.setAttrValue(rowparams, "VLAN", 401511, attrMap);
    }

    private void setAttrValue(RowParams rowparams, String paramName, int attrID, Map<Integer, Integer> attrMap) {
        Integer value = attrMap.get(attrID);
        if (null != value) {
            Param param = rowparams.getParam(paramName);
            param.setValue(String.valueOf(value));
        }
    }

    private int getPortID(TEGeneralKeyValue key) {
        int portID = -1;
        TEGenObjectID genObjectID = new TEGenObjectID(key.getTEOBJECTID());
        int objID = key.getTEOBJECTID()[0];
        portID = objID == 61603 ? genObjectID.getPortIDInInt() : 32768 + genObjectID.getPortIDInInt();
        return portID;
    }

    @Override
    public void addWnemgrBusClassMapping(SubFunc subFunc) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        subFunc.setWnemgrBussinessMapping(this.getClass().getName());
    }

    @Override
    public void handleOutput(int neID, int cmdID, String operName, Input input, List<Output> succOutputList, List<Output> failOutputList) {
        if (this.isGetVBOper(operName)) {
            this.handleNSCMD_ETHN_GET_VB(succOutputList);
        } else if (this.isGetVBTypeOper(operName)) {
            this.handleNSCMD_ETHN_GET_VB_TYPE(succOutputList);
        } else if (this.isGetLinkOper(operName)) {
            this.handleGET_LINK(succOutputList);
        } else if (this.isNSCMD_ETHN_GET_BRIDGEMODE(operName)) {
            this.handleNSCMD_ETHN_GET_BRIDGEMODE(succOutputList);
        }
    }

    @Override
    public void doBeforeHandleMessage(int neID, List<Operation> operationList, SubFunc subFunc, List<Integer> filterErrorCodeList) {
        if (operationList.isEmpty()) {
            return;
        }
        int slotID = TEVBInfoListUtil.getSlotID(operationList.get(0).getInput());
        Collection<TEEtherBridgeMOPO> moVBList = this.vbMOMap.values();
        for (TEEtherBridgeMOPO moVB : moVBList) {
            this.addAttrToVBMO(neID, slotID, moVB);
            TEQueryVBDBHandler.saveVBToDB(neID, slotID, moVB);
        }
    }

    public static String getVBID(Datainterface inputData) {
        String vbIDStr = "1";
        return vbIDStr;
    }

    private void handleGET_LINK(List<Output> succOutputList) {
        for (Output output : succOutputList) {
            this.handleAddMemData(output);
        }
    }

    public void handleAddMemData(Output output) {
        String linkTypeStr = output.getPartValue("linktype");
        if (null != linkTypeStr && linkTypeStr.equals("1")) {
            return;
        }
        String vbid = "";
        String portid = "";
        String lpid = "";
        String linktype = "";
        String linkid = "";
        String porttype = "";
        String cvlan = NA_VALUESTR;
        String svlan = NA_VALUESTR;
        if (null == output.getPartValue("linktype")) {
            vbid = output.getPartValue("vbid");
            portid = output.getPartValue("portid");
            lpid = output.getPartValue("vbport");
            linkid = output.getPartValue("linkid");
            if (output.getPart("cvlan") == null) {
                linktype = MOUNT_PORT_AND_BASE_PORT_AND_SVLAN;
                porttype = "5";
            } else if (output.getPart("cvlan").getValue().equals(NA_VALUESTR)) {
                linktype = ADD_SVLAN_BASE_PORT;
                porttype = "5";
            } else {
                linktype = "1";
                porttype = "6";
                cvlan = output.getPartValue("cvlan");
            }
            svlan = output.getPartValue("svlan");
        }
        if (output.getPartValue("ingressvbid") != null && !output.getPartValue("ingressvbid").equals(String.valueOf(65535))) {
            vbid = output.getPartValue("ingressvbid");
            portid = output.getPartValue("egressport");
            lpid = output.getPartValue("ingressport");
        }
        if (output.getPartValue("ingressvbid") != null && !output.getPartValue("egressvbid").equals(String.valueOf(65535))) {
            vbid = output.getPartValue("egressvbid");
            portid = output.getPartValue("ingressport");
            lpid = output.getPartValue("egressport");
        }
        if (linktype.isEmpty()) {
            linktype = output.getPartValue("linktype");
        }
        if (linkid.isEmpty()) {
            linkid = output.getPartValue("linkid");
        }
        String slotid = output.getPartValue("slotid");
        this.addToDB(vbid, portid, lpid, linkid, slotid, linktype, porttype, cvlan, svlan);
    }

    private void addToDB(String vbid, String portid, String lpid, String linkid, String slotid, String linktype, String porttype, String cvlan, String svlan) {
        TEEtherBridgeMOPO moVB = this.vbMOMap.get(Integer.parseInt(vbid));
        if (null == moVB) {
            return;
        }
        Set vbLinkMOList = moVB.getLinkList();
        TEEtherVBLinkMOPO vbLinkMO = new TEEtherVBLinkMOPO();
        vbLinkMO.setIDOnNE(Integer.parseInt(linkid));
        vbLinkMO.setType(Short.parseShort(linktype));
        vbLinkMO.setDir((short)0);
        vbLinkMO.setVBPortID(Integer.parseInt(lpid));
        vbLinkMO.setTunnelLabel(-1L);
        vbLinkMO.setVCLabel(-1L);
        vbLinkMO.setPhyPortType((short)TEEthXCUtil.getE2EPortType(Integer.parseInt(portid)));
        vbLinkMO.setPhyPortID(Integer.parseInt(portid));
        vbLinkMO.setSVLanID(Integer.parseInt(svlan));
        vbLinkMO.setCVLanID(Integer.parseInt(cvlan));
        vbLinkMO.setActiveState((short)1);
        vbLinkMO.setPktPRI(-1);
        vbLinkMO.setSVlanPRI(-1);
        vbLinkMO.setForwardPRI(-1);
        vbLinkMO.setRPRFwdPRI(-1);
        vbLinkMO.setRPRRingDir(-1);
        vbLinkMO.setRPRdstNodeID(-1);
        vbLinkMOList.add(vbLinkMO);
        moVB.setPortNum(moVB.getPortNum() + 1);
    }

    private void addAttrToVBMO(int neid, int slotID, TEEtherBridgeMOPO vbMO) {
        boolean vbtypeModifyFlg = true;
        boolean vbmodeModifyFlg = true;
        boolean macenableModifyFlg = true;
        String vbtype = "";
        String vbmode = "";
        String macenable = "";
        TEConfigurationDataMgr cfgDataMgr = TEConfigurationDataMgr.getInstance();
        TEBoard board = cfgDataMgr.getBoard(neid, slotID);
        String bdCpType = String.valueOf(board.getBoardType());
        TEParseEthLanConfFile confFileObj = TEParseEthLanConfFile.getInstance();
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbtyperes", "IsSupportModify").equals("no")) {
            vbtypeModifyFlg = false;
            vbtype = confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbtyperes", "vbtype");
        }
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbswicthmode", "IsSupportModify").equals("no")) {
            vbmodeModifyFlg = false;
            vbmode = confFileObj.getChildNodeAttrValue(neid, bdCpType, "vbswicthmode", "mode");
        }
        if (confFileObj.getChildNodeAttrValue(neid, bdCpType, "macaddress", "IsSupportModify").equals("no")) {
            macenableModifyFlg = false;
            macenable = confFileObj.getChildNodeAttrValue(neid, bdCpType, "macaddress", "EnableStatus");
        }
        if (!vbtypeModifyFlg) {
            vbMO.setBridgeType(Integer.parseInt(vbtype));
        }
        if (!vbmodeModifyFlg) {
            String obj = TEQueryVBBean.getStudyMode(vbmode);
            if (!"".equals(obj)) {
                vbMO.setVBLearnMode(Integer.parseInt(obj));
            }
            if (!"".equals(obj = TEQueryVBBean.getIngressStatus(vbmode))) {
                vbMO.setVBFilterEnable(Integer.parseInt(obj));
            }
        }
        if (!macenableModifyFlg && !"".equals(macenable)) {
            vbMO.setVBMacLrnEnable(Integer.parseInt(macenable));
        }
    }

    private void handleNSCMD_ETHN_GET_VB(List<Output> succOutputList) {
        this.vbMOMap.clear();
        TEEtherBridgeMOPO moVB = null;
        for (Output output : succOutputList) {
            int vbID = this.getPartValueInt(output, "vbid");
            String vbName = this.getPartValueStr(output, "vbname").trim();
            moVB = new TEEtherBridgeMOPO();
            moVB.setVBID(vbID);
            moVB.setVBName(vbName);
            moVB.setVBLearnMode(0);
            moVB.setVBFilterEnable(0);
            moVB.setVBMacLrnEnable(0);
            moVB.setVBLabel("");
            moVB.setVBOwner("");
            moVB.setVBActiveState((short)1);
            this.vbMOMap.put(vbID, moVB);
        }
    }

    private void handleNSCMD_ETHN_GET_VB_TYPE(List<Output> succOutputList) {
        TEEtherBridgeMOPO moVB = null;
        for (Output output : succOutputList) {
            int vbID = this.getPartValueInt(output, "vbid");
            moVB = this.vbMOMap.get(vbID);
            if (null == moVB) continue;
            int vbType = this.getPartValueInt(output, "vbtype");
            moVB.setBridgeType(TEE2EVBUtil.ne2E2EVBType(vbType));
        }
    }

    private void handleNSCMD_ETHN_GET_BRIDGEMODE(List<Output> succOutputList) {
        TEEtherBridgeMOPO moVB = null;
        for (Output output : succOutputList) {
            int vbID = this.getPartValueInt(output, "vbid");
            moVB = this.vbMOMap.get(vbID);
            if (null == moVB) continue;
            int vbstudytype = this.getPartValueInt(output, "vbstudytype");
            moVB.setVBLearnMode(vbstudytype);
            int ingressfilter = this.getPartValueInt(output, "ingressfilter");
            moVB.setVBFilterEnable(ingressfilter);
        }
    }

    private boolean isGetLinkOper(String operName) {
        HashSet<String> operNameSet = new HashSet<String>();
        operNameSet.add("NSCMD_ETHN_GET_LINK");
        operNameSet.add("NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK");
        operNameSet.add("NSCMD_ETHN_GET_PORTSVLANVBLINK");
        operNameSet.add("NSCMD_ETHN_GET_LINK_EX");
        operNameSet.add("NSCMD_ETHN_GET_PORTCVLANSVLANVBLINK_EX");
        operNameSet.add("NSCMD_ETHN_GET_PORTSVLANVBLINK_EX");
        return operNameSet.contains(operName);
    }

    private boolean isGetVBTypeOper(String operName) {
        HashSet<String> operNameSet = new HashSet<String>();
        operNameSet.add("NSCMD_ETHN_GET_VB_TYPE");
        operNameSet.add("NSCMD_ETHN_GET_VB_TYPE_EX");
        return operNameSet.contains(operName);
    }

    private boolean isGetVBOper(String operName) {
        HashSet<String> operNameSet = new HashSet<String>();
        operNameSet.add("NSCMD_ETHN_GET_VB");
        operNameSet.add("NSCMD_ETHN_GET_VB_EX");
        return operNameSet.contains(operName);
    }

    private boolean isNSCMD_ETHN_GET_BRIDGEMODE(String operName) {
        HashSet<String> operNameSet = new HashSet<String>();
        operNameSet.add("NSCMD_ETHN_GET_BRIDGEMODE");
        operNameSet.add("NSCMD_ETHN_GET_BRIDGEMODE_EX");
        return operNameSet.contains(operName);
    }

    static {
        vctrunkAttrList.add("ATTR_ETHOVERSDH_VCG_PE_TYPE");
        vctrunkAttrList.add("ATTR_ETHOVERSDH_VCG_TAG");
        vctrunkAttrList.add("ATTR_ETHOVERSDH_VCG_VLAN");
        portAttrList.add("ATTR_ETHOVERSDH_MAC_PE_TYPE");
        portAttrList.add("ATTR_ETHOVERSDH_MAC_ENABLE");
        portAttrList.add("ATTR_ETHOVERSDH_MAC_TAG");
        portAttrList.add("ATTR_ETHOVERSDH_MAC_VLAN");
        portAttrList.add("ATTR_ETHOVERSDH_MAC_WORKMODE");
    }
}

