/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.observer;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBBeanOberverSuper;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEManageVLANDBHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEVBInfoListUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public class TEManageVLANBeanObserver
extends TEVBBeanOberverSuper {
    private static final String PARAM_VLANID = "vlanid";
    private static final int DEL_VLAN_FLAG = 0;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    @Override
    public void doBeforePerfomBussinessProcess(int neID, SubFunc subFunc, Datainterface inputData, Datainterface outputData) {
        int vbID;
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        int slotID = TEVBInfoListUtil.getSlotID(inputData);
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID = TEManageVLANBeanObserver.getVBID(inputData));
        if (null == vbMO) {
            TEManageVLANBeanObserver.logVBMONullError(neID, slotID, vbID);
            return;
        }
        ArrayList<TECFVlanEntryMOPO> setSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        ArrayList<TECFVlanEntryMOPO> delSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        this.getToDelUnactiveVLANMO(neID, inputData, vbMO, delSuccVlanList);
        TEManageVLANDBHandler.modifyVBMOInMem(vbMO, setSuccVlanList, delSuccVlanList);
        int retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEManageVLANBeanObserver.logUpdateDBError(neID, slotID, vbID);
            return;
        }
        if (!delSuccVlanList.isEmpty()) {
            TEE2EVlanNoticeMgr.sendDeleteNtf(TEManageVLANDBHandler.constructDelVLANMsg(neID, slotID, vbID, delSuccVlanList));
        }
    }

    private void getToDelUnactiveVLANMO(int neID, Datainterface inputData, TEEtherBridgeMOPO vbMO, List<TECFVlanEntryMOPO> delSuccVlanList) {
        TECFVlanEntryMOPO oldVlanMO = null;
        Map<Integer, TECFVlanEntryMOPO> vlanMOMap = TEManageVLANBeanObserver.getVlanMOMap(vbMO);
        RowParams rowparams2 = null;
        int isactive = -1;
        int isDelVlan = -1;
        int vlanid = -1;
        BussinessParams bussiness = inputData.getBussinessParams();
        ArrayList rowparamsList = bussiness.getRowParamList();
        for (RowParams rowparams2 : rowparamsList) {
            vlanid = TEManageVLANBeanObserver.getIntParam(rowparams2, PARAM_VLANID, -1);
            oldVlanMO = vlanMOMap.get(vlanid);
            if (null == oldVlanMO) continue;
            isactive = oldVlanMO.getActiveState();
            isDelVlan = TEManageVLANBeanObserver.getIntParam(rowparams2, "flag", -1);
            if (0 != isactive || 0 != isDelVlan) continue;
            Param param = new Param();
            param.setName("isactive");
            param.setValue(String.valueOf(0));
            rowparams2.addParam(param);
            delSuccVlanList.add(oldVlanMO);
        }
    }

    public static boolean isVlanExist(int vlanID, TEEtherBridgeMOPO vbMO) {
        if (null == vbMO) {
            return false;
        }
        TECFVlanEntryMOPO oldVlanMO = null;
        Map<Integer, TECFVlanEntryMOPO> vlanMOMap = TEManageVLANBeanObserver.getVlanMOMap(vbMO);
        oldVlanMO = vlanMOMap.get(vlanID);
        return null == oldVlanMO;
    }

    public static boolean isVlanUnActive(int vlanID, TEEtherBridgeMOPO vbMO) {
        if (null == vbMO) {
            return false;
        }
        TECFVlanEntryMOPO oldVlanMO = null;
        Map<Integer, TECFVlanEntryMOPO> vlanMOMap = TEManageVLANBeanObserver.getVlanMOMap(vbMO);
        oldVlanMO = vlanMOMap.get(vlanID);
        if (null == oldVlanMO) {
            return false;
        }
        return 0 == oldVlanMO.getActiveState();
    }

    private static Map<Integer, TECFVlanEntryMOPO> getVlanMOMap(TEEtherBridgeMOPO vbMO) {
        HashMap<Integer, TECFVlanEntryMOPO> vlanMOMap = new HashMap<Integer, TECFVlanEntryMOPO>();
        TECFVlanEntryMOPO vlanMO2 = null;
        Set vlanMOSet = vbMO.getVlanFibDB();
        for (TECFVlanEntryMOPO vlanMO2 : vlanMOSet) {
            vlanMOMap.put(vlanMO2.getVlanID(), vlanMO2);
        }
        return vlanMOMap;
    }

    public static int getVBID(Datainterface inputData) {
        String vbIDStr = "1";
        Param param = inputData.getBussinessParams().getRowParams(0).getParam("vbid");
        if (null != param) {
            vbIDStr = param.getValue();
        }
        return Integer.parseInt(vbIDStr);
    }

    private static void logUpdateDBError(int neID, int slotID, int vbID) {
        String tipStr = "update vb to db error!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID, int vbID) {
        String tipStr = "vb mo is null!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }
}

