/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TESetEthInfBean;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public final class TESaveEthInfAttr {
    private TESaveEthInfAttr() {
    }

    public static void doAfterSendCmd(int neID, int slotID, List<Operation> operationList) {
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return;
        }
        if (null == operationList || operationList.isEmpty()) {
            return;
        }
        String cmdName = null;
        Input input = null;
        boolean isMacPort = true;
        ArrayList<Operation> portAttrOperList = new ArrayList<Operation>();
        for (Operation oper : operationList) {
            cmdName = oper.getName();
            input = oper.getInput();
            if (cmdName.contains("NSCMD_ETHN_SET_PORT_TYPE")) {
                isMacPort = TESaveEthInfAttr.isMacPort(input);
                TESaveEthInfAttr.refactorInputForPortType(isMacPort, oper);
                portAttrOperList.add(oper);
                continue;
            }
            if (cmdName.contains("NSCMD_ETHN_SET_PORTENABLE")) {
                portAttrOperList.add(oper);
                continue;
            }
            if (cmdName.contains("NSCMD_ETHN_SET_ETHTAG")) {
                isMacPort = TESaveEthInfAttr.isMacPort(input);
                TESaveEthInfAttr.refactorInputForPortTag(isMacPort, oper);
                portAttrOperList.add(oper);
                continue;
            }
            if (cmdName.contains("NSCMD_ETHN_SET_VLANID")) {
                isMacPort = TESaveEthInfAttr.isMacPort(input);
                TESaveEthInfAttr.refactorInputForVlan(isMacPort, oper);
                portAttrOperList.add(oper);
                continue;
            }
            if (!cmdName.contains("NSCMD_ETHN_SET_ETHWORKMODE")) continue;
            isMacPort = TESaveEthInfAttr.isMacPort(input);
            portAttrOperList.add(oper);
        }
        if (portAttrOperList.isEmpty()) {
            return;
        }
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, 2260913);
        String gencfgFileName = subFunc.getGenCfgAttrDesPath().getContent();
        TESetEthInfBean.saveEthInfAttrToDB(neID, gencfgFileName, portAttrOperList);
    }

    private static void refactorInputForPortType(boolean isMacPort, Operation oper) {
        if (isMacPort) {
            TESaveEthInfAttr.copyPastePart(oper, "PE_TYPE", "ATTR_ETHOVERSDH_MAC_PE_TYPE");
        } else {
            TESaveEthInfAttr.copyPastePart(oper, "PE_TYPE", "ATTR_ETHOVERSDH_VCG_PE_TYPE");
        }
    }

    private static void refactorInputForPortTag(boolean isMacPort, Operation oper) {
        if (isMacPort) {
            TESaveEthInfAttr.copyPastePart(oper, "portTag", "ATTR_ETHOVERSDH_MAC_TAG");
        } else {
            TESaveEthInfAttr.copyPastePart(oper, "portTag", "ATTR_ETHOVERSDH_VCG_TAG");
        }
    }

    private static void refactorInputForVlan(boolean isMacPort, Operation oper) {
        if (isMacPort) {
            TESaveEthInfAttr.copyPastePart(oper, "VLAN", "ATTR_ETHOVERSDH_MAC_VLAN");
            TESaveEthInfAttr.copyPastePart(oper, "VLANPRIORITY", "ATTR_ETHOVERSDH_MAC_VLANPRIORITY");
        } else {
            TESaveEthInfAttr.copyPastePart(oper, "VLAN", "ATTR_ETHOVERSDH_VCG_VLAN");
            TESaveEthInfAttr.copyPastePart(oper, "VLANPRIORITY", "ATTR_ETHOVERSDH_VCG_VLANPRIORITY");
        }
    }

    private static boolean isMacPort(Input input) {
        int port = Integer.parseInt(input.getPartValue("port"));
        return port < 32768;
    }

    private static void copyPastePart(Operation oper, String copyFrom, String copyTo) {
        Input input = oper.getInput();
        if ("0".equals(oper.getOutput(0).getFault(0).getCode())) {
            Part copyFromPart = input.getPart(copyFrom);
            Part copyToPart = new Part();
            copyToPart.setName(copyTo);
            copyToPart.setValue(copyFromPart.getValue());
            input.addPart(copyToPart);
        }
    }
}

