/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEQueryVBDBHandler;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;

public class TEQueryVLANDBHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEQueryVLANDBHandler() {
    }

    public static void saveVLANToDB(int neID, Datainterface inputData, Datainterface outputData) {
        int vbid;
        int slotID = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbid = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("vbid").getValue()));
        if (null == etherBridgeMo) {
            String tipStr = "get vb mo from db fail!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbid:%d]", neID, slotID, vbid);
            e2eLogger.error(tipStr);
            return;
        }
        Set vlanMOSet = etherBridgeMo.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO vlanMO = null;
        while (iter.hasNext()) {
            vlanMO = (TECFVlanEntryMOPO)iter.next();
            if (vlanMO.getActiveState() != 1) continue;
            iter.remove();
        }
        etherBridgeMo.getVlanFibDB().addAll(TEQueryVLANDBHandler.getVlanMOFromOutputData(outputData));
        int result = TEE2EVBUtil.updateVBMOToDB(neID, slotID, etherBridgeMo);
        if (0 != result) {
            TEQueryVBDBHandler.constructErrCode(inputData, outputData, result);
        }
    }

    public static Set<TECFVlanEntryMOPO> getVlanMOFromOutputData(Datainterface outputData) {
        RowParams[] rowParams = outputData.getBussinessParams().getRowParams();
        HashSet<TECFVlanEntryMOPO> vlanSet = new HashSet<TECFVlanEntryMOPO>();
        TECFVlanEntryMOPO entry = null;
        String valnIDStr = null;
        String portNoList = null;
        int iLength = rowParams.length;
        for (int i = 0; i < iLength; ++i) {
            if (0 != rowParams[i].getRowErrorsCount()) {
                String tipStr = String.format("The rowParams[%d] contains error! ", i);
                e2eLogger.error(tipStr);
                continue;
            }
            valnIDStr = rowParams[i].getParam("vlanid").getValue();
            portNoList = rowParams[i].getParam("portNoList").getValue();
            entry = new TECFVlanEntryMOPO();
            entry.setVlanID(Integer.parseInt(valnIDStr));
            entry.setVlanFwPort(TEQueryVLANDBHandler.convertWebLCTPortToE2EPort(portNoList));
            entry.setActiveState((short)1);
            entry.setVlanFwPortEx("");
            entry.setVlanLabel("");
            entry.setVlanOwner("");
            entry.setVlanMaxMac(-1L);
            entry.setVlanRealMaxMac(-1L);
            vlanSet.add(entry);
        }
        return vlanSet;
    }

    private static String convertWebLCTPortToE2EPort(String portNoList) {
        return portNoList;
    }
}

