/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TENEVBContainer;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEQueryVBDBHandler {
    private static final int ALL_VB_FLAG = 0;
    private static final Logger e2elogger = TELogFactory.getE2ELogger();

    private TEQueryVBDBHandler() {
    }

    public static void saveVBToDB(int neID, int slotID, TEEtherBridgeMOPO newVBMO) {
        String tipStr;
        ArrayList<TEEtherBridgeMOPO> deletedVBMOList = new ArrayList<TEEtherBridgeMOPO>();
        int result = TEE2EVBUtil.delVBMOFromDB(neID, slotID, 0, deletedVBMOList);
        HashMap<Integer, TEEtherBridgeMOPO> deletedVBMOMap = new HashMap<Integer, TEEtherBridgeMOPO>();
        for (TEEtherBridgeMOPO vbMO : deletedVBMOList) {
            deletedVBMOMap.put(vbMO.getVBID(), vbMO);
        }
        if (0 != result) {
            tipStr = "del vb mo from ne fail!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, result:%d]", neID, slotID, result);
            e2elogger.error(tipStr);
        }
        if (0 != (result = TEQueryVBDBHandler.saveVBToDBImpl(neID, slotID, newVBMO, deletedVBMOMap))) {
            tipStr = "save vb mo to db fail!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, result:%d]", neID, slotID, result);
            e2elogger.error(tipStr);
        }
    }

    public static void constructErrCode(Datainterface inputData, Datainterface outputData, int result) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(result));
        RowErrors rowErrors = new RowErrors();
        rowErrors.setErrorMessage(errorMessage);
        rowErrors.setParam(inputData.getBussinessParams().getRowParams(0).getParam());
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 == retCode) {
            errorMessage = outputData.getErrorMessage();
            errorMessage.setErrorcode(String.valueOf(1));
            RowParams rowParam = new RowParams();
            rowParam.addRowErrors(rowErrors);
            outputData.getBussinessParams().addRowParams(0, rowParam);
        } else {
            outputData.getBussinessParams().getRowParams(0).addRowErrors(rowErrors);
        }
    }

    private static int saveVBToDBImpl(int neID, int slotID, TEEtherBridgeMOPO newVBMO, Map<Integer, TEEtherBridgeMOPO> delVBMap) {
        int retCode = 0;
        List<TEEtherBridgeMOPO> vbMOList = TEQueryVBDBHandler.constructVB(neID, slotID, newVBMO, delVBMap);
        if (vbMOList.isEmpty()) {
            String tipStr = "The vbMOList is empty! It will return success.";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2elogger.error(tipStr);
            return retCode;
        }
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            retCode = TEE2EVBUtil.createVBMOToDB(neID, slotID, vbMO);
            if (0 == retCode) continue;
            String tipStr = "Save db fail! The save loop will break. ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, retCode:%d]", neID, slotID, retCode);
            e2elogger.error(tipStr);
            break;
        }
        return retCode;
    }

    private static List<TEEtherBridgeMOPO> constructVB(int neID, int slotID, TEEtherBridgeMOPO newVBMO, Map<Integer, TEEtherBridgeMOPO> delVBMap) {
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        Set vbLinkList = newVBMO.getLinkList();
        TEEtherBridgeMOPO delVBMO = delVBMap.get(newVBMO.getVBID());
        if (null != delVBMO) {
            Set delLinkList = delVBMO.getLinkList();
            for (TEEtherVBLinkMOPO delVBLinkMO : delLinkList) {
                if (delVBLinkMO.getActiveState() != 0) continue;
                vbLinkList.add(delVBLinkMO);
            }
        }
        newVBMO.setPortNum(newVBMO.getLinkList().size());
        Set vlanMOSet = newVBMO.getVlanFibDB();
        if (null != delVBMO) {
            Set delVlanMOSet = delVBMO.getVlanFibDB();
            for (TECFVlanEntryMOPO delVlanMO : delVlanMOSet) {
                vlanMOSet.add(delVlanMO);
            }
        }
        vbMOList.add(newVBMO);
        return vbMOList;
    }

    protected static List<TEEtherVBLinkMOPO> getVBLinkMOListOrgin(int neID, int slotID, int vbid) {
        ArrayList<TEEtherVBLinkMOPO> vbLinkMOList = new ArrayList<TEEtherVBLinkMOPO>();
        ArrayList vbinfo = null;
        TENEVBContainer container = null;
        TELinkPortInfo linkport = null;
        String portIDStr = null;
        TEEtherVBLinkMOPO vbLinkMO = null;
        container = TENEVBContainer.getInstance(neID, slotID);
        vbinfo = container.getVBList(neID).getPortIdsByVB(String.valueOf(vbid));
        int infolen = vbinfo.size();
        for (int j = 0; j < infolen; ++j) {
            linkport = (TELinkPortInfo)vbinfo.get(j);
            portIDStr = linkport.getPortId();
            if ("0".equals(portIDStr)) continue;
            String lpPortNoStr = linkport.getLpNo();
            int lpPortNo = -1;
            if (null != lpPortNoStr && !lpPortNoStr.isEmpty()) {
                lpPortNo = Integer.parseInt(lpPortNoStr);
            }
            int phyPortID = Integer.parseInt(linkport.getPortId());
            vbLinkMO = new TEEtherVBLinkMOPO();
            vbLinkMO.setIDOnNE(Integer.parseInt(linkport.getLinkid()));
            vbLinkMO.setType((short)-1);
            vbLinkMO.setDir((short)0);
            vbLinkMO.setVBPortID(lpPortNo);
            vbLinkMO.setTunnelLabel(-1L);
            vbLinkMO.setVCLabel(-1L);
            vbLinkMO.setPhyPortType((short)TEEthXCUtil.getE2EPortType(phyPortID));
            vbLinkMO.setPhyPortID(phyPortID);
            vbLinkMO.setSVLanID(-1);
            vbLinkMO.setCVLanID(-1);
            vbLinkMO.setActiveState((short)1);
            vbLinkMO.setPktPRI(-1);
            vbLinkMO.setSVlanPRI(-1);
            vbLinkMO.setForwardPRI(-1);
            vbLinkMO.setRPRFwdPRI(-1);
            vbLinkMO.setRPRRingDir(-1);
            vbLinkMO.setRPRdstNodeID(-1);
            vbLinkMOList.add(vbLinkMO);
        }
        return vbLinkMOList;
    }

    protected static List<TEEtherVBLinkMOPO> getVBLinkMOListR7C01(int neID, int slotID, int vbid) {
        ArrayList<TEEtherVBLinkMOPO> vbLinkMOList = new ArrayList<TEEtherVBLinkMOPO>();
        ArrayList vbinfo = null;
        com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TENEVBContainer container = null;
        com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TELinkPortInfo linkport = null;
        String portIDStr = null;
        TEEtherVBLinkMOPO vbLinkMO = null;
        container = com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TENEVBContainer.getInstance(neID, slotID);
        vbinfo = container.getVBList(neID).getLinkPortList(String.valueOf(vbid));
        if (null == vbinfo) {
            return vbLinkMOList;
        }
        int infolen = vbinfo.size();
        for (int j = 0; j < infolen; ++j) {
            linkport = (com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TELinkPortInfo)vbinfo.get(j);
            portIDStr = linkport.getPortId();
            if ("0".equals(portIDStr)) continue;
            String lpPortNoStr = linkport.getLpNo();
            int lpPortNo = -1;
            if (null != lpPortNoStr && !lpPortNoStr.isEmpty()) {
                lpPortNo = Integer.parseInt(lpPortNoStr);
            }
            int phyPortID = Integer.parseInt(linkport.getPortId());
            vbLinkMO = new TEEtherVBLinkMOPO();
            vbLinkMO.setIDOnNE(Integer.parseInt(linkport.getLinkid()));
            vbLinkMO.setType((short)-1);
            vbLinkMO.setDir((short)0);
            vbLinkMO.setVBPortID(lpPortNo);
            vbLinkMO.setTunnelLabel(-1L);
            vbLinkMO.setVCLabel(-1L);
            vbLinkMO.setPhyPortType((short)TEEthXCUtil.getE2EPortType(phyPortID));
            vbLinkMO.setPhyPortID(phyPortID);
            vbLinkMO.setSVLanID(Integer.parseInt(linkport.getSVlan()));
            vbLinkMO.setCVLanID(Integer.parseInt(linkport.getCVlan()));
            vbLinkMO.setActiveState((short)1);
            vbLinkMO.setPktPRI(-1);
            vbLinkMO.setSVlanPRI(-1);
            vbLinkMO.setForwardPRI(-1);
            vbLinkMO.setRPRFwdPRI(-1);
            vbLinkMO.setRPRRingDir(-1);
            vbLinkMO.setRPRdstNodeID(-1);
            vbLinkMOList.add(vbLinkMO);
        }
        return vbLinkMOList;
    }
}

