/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.network.qasn.m_q_ipservice.QAsnVLanAddDelRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.util.TEEthE2ELogVB;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2ECreateVlanMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanMessage;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEManageVLANDBHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEManageVLANDBHandler() {
    }

    private static TEE2EVlanMessage constructAddVLANMsg(int neID, int slotID, int vbID, Collection<TECFVlanEntryMOPO> vlanMOSet) {
        QAsnVLanAddDelRpt addRpt = new QAsnVLanAddDelRpt();
        addRpt.isAdd = 1;
        addRpt.vlanInfoList.addAll((Collection)TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet));
        TEE2ECreateVlanMsg vlanMsg = new TEE2ECreateVlanMsg(addRpt);
        return vlanMsg;
    }

    public static TEE2EVlanMessage constructDelVLANMsg(int neID, int slotID, int vbID, Collection<TECFVlanEntryMOPO> vlanMOSet) {
        QAsnVLanAddDelRpt addRpt = new QAsnVLanAddDelRpt();
        addRpt.isAdd = 0;
        addRpt.vlanInfoList.addAll((Collection)TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet));
        return new TEE2ECreateVlanMsg(addRpt);
    }

    public static String getFwPortList(int neID, String portNoList) {
        int codeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 0x202022);
        int footLen = -1;
        footLen = codeVersion == 2 ? 6 : 4;
        String fwPortListStr = "";
        StringBuffer buffer = new StringBuffer();
        int jLength = portNoList.length();
        for (int j = 0; j < jLength; j += footLen) {
            String portNoStr = portNoList.substring(j, j + footLen);
            if (codeVersion == 2) {
                portNoStr = portNoStr.substring(2);
            }
            int portNo = Integer.parseInt(portNoStr, 16);
            if (0 != buffer.length()) {
                buffer.append(',');
            }
            buffer.append(portNo);
        }
        fwPortListStr = buffer.toString();
        if (null == fwPortListStr || fwPortListStr.isEmpty()) {
            fwPortListStr = "";
        }
        return fwPortListStr;
    }

    public static int handleManageVLANBean(int neID, ArrayList operList, SubFunc subfunc, boolean isSave, boolean idDel) {
        int vbID;
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return 0;
        }
        if (null == operList || operList.isEmpty()) {
            return 0;
        }
        if (!isSave && !idDel) {
            return 0;
        }
        int slotID = TEManageVLANDBHandler.getSlotIDFromOper(operList);
        TEEtherBridgeMOPO vbMOPO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID = TEManageVLANDBHandler.getVBIDFromOper(operList));
        if (null == vbMOPO) {
            TEManageVLANDBHandler.logVBMONullError(neID, slotID, vbID);
            return 1090646291;
        }
        Operation oper = null;
        String cmdName = null;
        TECFVlanEntryMOPO vlanMO = null;
        ArrayList<TECFVlanEntryMOPO> setSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        ArrayList<TECFVlanEntryMOPO> delSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        int len = operList.size();
        for (int i = 0; i < len; ++i) {
            oper = (Operation)operList.get(i);
            cmdName = oper.getName();
            if (!TEManageVLANDBHandler.isOperSuccess(oper)) continue;
            if (cmdName.contains("NSCMD_ETHN_SET_VLAN_TABLE") && isSave) {
                vlanMO = TEManageVLANDBHandler.constructNewVlan(neID, oper);
                setSuccVlanList.add(vlanMO);
                continue;
            }
            if (!cmdName.contains("NSCMD_ETHN_DEL_VLAN_TABLE") || !idDel) continue;
            vlanMO = TEManageVLANDBHandler.constructDelVlan(neID, oper);
            delSuccVlanList.add(vlanMO);
        }
        TEManageVLANDBHandler.modifyVBMOInMem(vbMOPO, setSuccVlanList, delSuccVlanList);
        int retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMOPO);
        if (0 != retCode) {
            TEManageVLANDBHandler.logUpdateDBError(neID, slotID, vbID);
            return retCode;
        }
        if (!setSuccVlanList.isEmpty() && isSave) {
            TEE2EVlanNoticeMgr.sendCreateNtf(TEManageVLANDBHandler.constructAddVLANMsg(neID, slotID, vbID, setSuccVlanList));
        }
        if (!delSuccVlanList.isEmpty() && idDel) {
            TEE2EVlanNoticeMgr.sendDeleteNtf(TEManageVLANDBHandler.constructDelVLANMsg(neID, slotID, vbID, delSuccVlanList));
        }
        return 0;
    }

    public static int handleManageVLANBean(int neID, ArrayList operationList, SubFunc subfunc, List<String> filterErrorCodeList, boolean isSaveDB, boolean isDelDB) {
        int vbID;
        if (!TESysManagerBean.getInstance().isIntegratedStatus()) {
            return 0;
        }
        if (null == operationList || operationList.isEmpty()) {
            return 0;
        }
        if (!isSaveDB && !isDelDB) {
            return 0;
        }
        int slotID = TEManageVLANDBHandler.getSlotIDFromOper(operationList);
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID = TEManageVLANDBHandler.getVBIDFromOper(operationList));
        if (null == vbMO) {
            TEManageVLANDBHandler.logVBMONullError(neID, slotID, vbID);
            return 1090646291;
        }
        Operation oper = null;
        String cmdName = null;
        TECFVlanEntryMOPO vlanMO = null;
        ArrayList<TECFVlanEntryMOPO> setSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        ArrayList<TECFVlanEntryMOPO> delSuccVlanList = new ArrayList<TECFVlanEntryMOPO>();
        int len = operationList.size();
        for (int i = 0; i < len; ++i) {
            oper = (Operation)operationList.get(i);
            cmdName = oper.getName();
            if (!TEManageVLANDBHandler.isOperSuccess(oper, filterErrorCodeList)) continue;
            if (cmdName.contains("NSCMD_ETHN_SET_VLAN_TABLE") && isSaveDB) {
                vlanMO = TEManageVLANDBHandler.constructNewVlan(neID, oper);
                setSuccVlanList.add(vlanMO);
                continue;
            }
            if (!cmdName.contains("NSCMD_ETHN_DEL_VLAN_TABLE") || !isDelDB) continue;
            vlanMO = TEManageVLANDBHandler.constructDelVlan(neID, oper);
            delSuccVlanList.add(vlanMO);
        }
        TEManageVLANDBHandler.modifyVBMOInMem(vbMO, setSuccVlanList, delSuccVlanList);
        int retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            TEManageVLANDBHandler.logUpdateDBError(neID, slotID, vbID);
            return retCode;
        }
        if (!setSuccVlanList.isEmpty() && isSaveDB) {
            TEE2EVlanNoticeMgr.sendCreateNtf(TEManageVLANDBHandler.constructAddVLANMsg(neID, slotID, vbID, setSuccVlanList));
        }
        if (!delSuccVlanList.isEmpty() && isDelDB) {
            TEE2EVlanNoticeMgr.sendDeleteNtf(TEManageVLANDBHandler.constructDelVLANMsg(neID, slotID, vbID, delSuccVlanList));
        }
        return 0;
    }

    public static void modifyVBMOInMem(TEEtherBridgeMOPO vbMO, List<TECFVlanEntryMOPO> setSuccVlanList, List<TECFVlanEntryMOPO> delSuccVlanList) {
        Map<Integer, TECFVlanEntryMOPO> vlanMOMap = TEManageVLANDBHandler.getVlanMOMap(vbMO);
        TEManageVLANDBHandler.modifyVBMOOnSet(vbMO, vlanMOMap, setSuccVlanList);
        TEManageVLANDBHandler.modifyVBMOOnDel(vbMO, vlanMOMap, delSuccVlanList);
    }

    private static void modifyVBMOOnSet(TEEtherBridgeMOPO vbMO, Map<Integer, TECFVlanEntryMOPO> oldVlanMOMap, List<TECFVlanEntryMOPO> setSuccVlanList) {
        int vlanID = -1;
        TECFVlanEntryMOPO oldVlanMO = null;
        for (TECFVlanEntryMOPO newVlanMO : setSuccVlanList) {
            vlanID = newVlanMO.getVlanID();
            oldVlanMO = oldVlanMOMap.get(vlanID);
            if (null == oldVlanMO) {
                vbMO.getVlanFibDB().add(newVlanMO);
                oldVlanMOMap.put(vlanID, newVlanMO);
                continue;
            }
            Set<Integer> oldFwdPortSet = TEE2EVlanUtil.getVblpPortSet(oldVlanMO.getVlanFwPort());
            oldFwdPortSet.addAll(TEE2EVlanUtil.getVblpPortSet(newVlanMO.getVlanFwPort()));
            oldVlanMO.setVlanFwPort(TEE2EVlanUtil.getVblpPortStr(oldFwdPortSet));
        }
    }

    private static void modifyVBMOOnDel(TEEtherBridgeMOPO vbMO, Map<Integer, TECFVlanEntryMOPO> oldVlanMOMap, List<TECFVlanEntryMOPO> delSuccVlanList) {
        int vlanID = -1;
        TECFVlanEntryMOPO oldVlanMO = null;
        for (TECFVlanEntryMOPO delVlanMO : delSuccVlanList) {
            vlanID = delVlanMO.getVlanID();
            oldVlanMO = oldVlanMOMap.get(vlanID);
            if (null == oldVlanMO) {
                return;
            }
            Set<Integer> oldFwdPortSet = TEE2EVlanUtil.getVblpPortSet(oldVlanMO.getVlanFwPort());
            oldFwdPortSet.removeAll(TEE2EVlanUtil.getVblpPortSet(delVlanMO.getVlanFwPort()));
            oldVlanMO.setVlanFwPort(TEE2EVlanUtil.getVblpPortStr(oldFwdPortSet));
            if (!"".equals(oldVlanMO.getVlanFwPort())) continue;
            oldVlanMOMap.remove(vlanID);
        }
        vbMO.getVlanFibDB().clear();
        vbMO.getVlanFibDB().addAll(oldVlanMOMap.values());
    }

    private static Map<Integer, TECFVlanEntryMOPO> getVlanMOMap(TEEtherBridgeMOPO vbMO) {
        HashMap<Integer, TECFVlanEntryMOPO> vlanMOMap = new HashMap<Integer, TECFVlanEntryMOPO>();
        TECFVlanEntryMOPO vlanMO2 = null;
        Set vlanMOSet = vbMO.getVlanFibDB();
        for (TECFVlanEntryMOPO vlanMO2 : vlanMOSet) {
            vlanMOMap.put(vlanMO2.getVlanID(), vlanMO2);
        }
        return vlanMOMap;
    }

    private static TECFVlanEntryMOPO constructNewVlan(int neID, Operation oper) {
        TECFVlanEntryMOPO entry = new TECFVlanEntryMOPO();
        int vlanID = Integer.parseInt(oper.getInput().getPartValue("vlanid"));
        String portNoList = oper.getInput().getPartValue("portNoList");
        String fwPortListStr = TEManageVLANDBHandler.getFwPortList(neID, portNoList);
        entry.setVlanID(vlanID);
        entry.setVlanFwPort(fwPortListStr);
        entry.setActiveState((short)1);
        entry.setVlanFwPortEx("");
        entry.setVlanLabel("");
        entry.setVlanOwner("");
        entry.setVlanMaxMac(-1L);
        entry.setVlanRealMaxMac(-1L);
        return entry;
    }

    private static TECFVlanEntryMOPO constructDelVlan(int neID, Operation oper) {
        TECFVlanEntryMOPO entry = new TECFVlanEntryMOPO();
        int vlanID = Integer.parseInt(oper.getInput().getPartValue("vlanid"));
        String portNoList = oper.getInput().getPartValue("portNoList");
        String fwPortListStr = TEManageVLANDBHandler.getFwPortList(neID, portNoList);
        entry.setVlanID(vlanID);
        entry.setVlanFwPort(fwPortListStr);
        entry.setActiveState((short)1);
        entry.setVlanFwPortEx("");
        entry.setVlanLabel("");
        entry.setVlanOwner("");
        entry.setVlanMaxMac(-1L);
        entry.setVlanRealMaxMac(-1L);
        return entry;
    }

    private static boolean isOperSuccess(Operation oper) {
        return "0".equals(oper.getOutput(0).getFault(0).getCode());
    }

    private static boolean isOperSuccess(Operation oper, List<String> filterErrorCodeList) {
        if ("0".equals(oper.getOutput(0).getFault(0).getCode())) {
            return true;
        }
        if ("".equals(oper.getOutput(0).getFault(0).getCode())) {
            return false;
        }
        return filterErrorCodeList.contains(Integer.parseInt(oper.getOutput(0).getFault(0).getCode()));
    }

    private static int getSlotIDFromOper(List<Operation> operationList) {
        return Integer.parseInt(operationList.get(0).getInput().getPartValue("slotid"));
    }

    private static int getVBIDFromOper(List<Operation> operationList) {
        return Integer.parseInt(operationList.get(0).getInput().getPartValue("vbid"));
    }

    private static void logUpdateDBError(int neID, int slotID, int vbID) {
        String tipStr = "update vb to db error!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }

    private static void logVBMONullError(int neID, int slotID, int vbID) {
        String tipStr = "vb mo is null!";
        tipStr = TEEthE2ELogVB.appendKeyWord(neID, slotID, vbID, tipStr);
        e2eLogger.error(tipStr);
    }
}

