/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEQueryVBBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TEInactiveVBMgr {
    public static final int IS_VB_DATA_TRUE = 1;
    public static final int IS_VB_DATA_FALSE = 0;

    private TEInactiveVBMgr() {
    }

    public static List<RowParams> buildInactiveVBRow(int neID, int slotID) {
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        List<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        int retCode = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbMOList);
        if (0 != retCode) {
            return rowList;
        }
        vbMOList = TEInactiveVBMgr.getInactiveVBMO(vbMOList);
        RowParams rowparams = null;
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            rowparams = TEInactiveVBMgr.mo2Row(neID, slotID, vbMO);
            rowList.add(rowparams);
        }
        return rowList;
    }

    public static List<RowParams> buildInactiveVlanRow(int neID, int slotID, int vbID) {
        ArrayList<RowParams> rowList = new ArrayList<RowParams>();
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            return rowList;
        }
        ArrayList<TECFVlanEntryMOPO> unactiveVlanMOList = new ArrayList<TECFVlanEntryMOPO>();
        Set vlanMOSet = vbMO.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO tmpVlanMO = null;
        while (iter.hasNext()) {
            tmpVlanMO = (TECFVlanEntryMOPO)iter.next();
            if (0 != tmpVlanMO.getActiveState()) continue;
            unactiveVlanMOList.add(tmpVlanMO);
        }
        RowParams rowparams = null;
        for (TECFVlanEntryMOPO vlanMO : unactiveVlanMOList) {
            rowparams = TEInactiveVBMgr.mo2Row(neID, slotID, vbID, vlanMO);
            rowList.add(rowparams);
        }
        return rowList;
    }

    private static List<TEEtherBridgeMOPO> getInactiveVBMO(List<TEEtherBridgeMOPO> vbMOList) {
        ArrayList<TEEtherBridgeMOPO> unActiveList = new ArrayList<TEEtherBridgeMOPO>();
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            if (0 != vbMO.getVBActiveState()) continue;
            unActiveList.add(vbMO);
        }
        return unActiveList;
    }

    private static void appendParam(RowParams rowParams, String paramName, String paramValue) {
        Param param = null;
        param = new Param();
        param.setName(paramName);
        param.setValue(paramValue);
        rowParams.addParam(param);
    }

    private static RowParams mo2Row(int neID, int slotID, TEEtherBridgeMOPO mo) {
        RowParams rowParams = new RowParams();
        if (null == mo) {
            return rowParams;
        }
        String vbstudytype = String.valueOf(mo.getVBLearnMode());
        String ingressfilter = String.valueOf(mo.getVBFilterEnable());
        String vbswitchtype = TEQueryVBBean.getVBMode(vbstudytype, ingressfilter);
        TEInactiveVBMgr.appendParam(rowParams, "neid", String.valueOf(neID));
        TEInactiveVBMgr.appendParam(rowParams, "slotid", String.valueOf(slotID));
        TEInactiveVBMgr.appendParam(rowParams, "boardname", TEConfigurationDataMgr.getInstance().getBoard(neID, slotID).getBoardName());
        TEInactiveVBMgr.appendParam(rowParams, "vbid", String.valueOf(mo.getVBID()));
        TEInactiveVBMgr.appendParam(rowParams, "vbname", mo.getVBName());
        TEInactiveVBMgr.appendParam(rowParams, "vbtype", String.valueOf(TEE2EVBUtil.e2e2NEVBType(mo.getBridgeType())));
        TEInactiveVBMgr.appendParam(rowParams, "vbswitchtype", vbswitchtype);
        TEInactiveVBMgr.appendParam(rowParams, "vbstudytype", vbstudytype);
        TEInactiveVBMgr.appendParam(rowParams, "ingressfilter", ingressfilter);
        TEInactiveVBMgr.appendParam(rowParams, "macaddrenable", TEQueryVBBean.getMacenable(String.valueOf(mo.getVBMacLrnEnable())));
        TEInactiveVBMgr.appendParam(rowParams, "isVBData", String.valueOf(1));
        TEInactiveVBMgr.appendParam(rowParams, "isactive", String.valueOf(mo.getVBActiveState()));
        return rowParams;
    }

    private static RowParams mo2Row(int neID, int slotID, int vbID, TECFVlanEntryMOPO vlanMO) {
        RowParams rowParams = new RowParams();
        if (null == vlanMO) {
            return rowParams;
        }
        TEInactiveVBMgr.appendParam(rowParams, "neid", String.valueOf(neID));
        TEInactiveVBMgr.appendParam(rowParams, "slotid", String.valueOf(slotID));
        TEInactiveVBMgr.appendParam(rowParams, "vlanid", String.valueOf(vbID));
        TEInactiveVBMgr.appendParam(rowParams, "boardname", TEConfigurationDataMgr.getInstance().getBoard(neID, slotID).getBoardName());
        TEInactiveVBMgr.appendParam(rowParams, "vlanid", String.valueOf(vlanMO.getVlanID()));
        String vlanFwPort = vlanMO.getVlanFwPort();
        TEInactiveVBMgr.appendParam(rowParams, "portNoList", vlanFwPort);
        String ethportList = TEInactiveVBMgr.getEthPortList(neID, slotID, vbID, vlanMO);
        TEInactiveVBMgr.appendParam(rowParams, "ethportList", ethportList);
        TEInactiveVBMgr.appendParam(rowParams, "isactive", String.valueOf(vlanMO.getActiveState()));
        return rowParams;
    }

    private static String getEthPortList(int neID, int slotID, int vbID, TECFVlanEntryMOPO vlanMO) {
        String ethportList = null;
        Set vblpPortSet = TEE2EVlanUtil.getVBlpPortSet(vlanMO);
        Map<Integer, Integer> vblpEthPortMap = TEE2EVlanUtil.getVBLPEthPortMap(neID, slotID, vbID);
        if (vblpPortSet.isEmpty()) {
            ethportList = "0";
            return ethportList;
        }
        StringBuffer buffer = new StringBuffer();
        String vlanFwPort = vlanMO.getVlanFwPort();
        String[] vblpPortArr = vlanFwPort.split(",");
        Integer ethPort = null;
        for (String str : vblpPortArr) {
            ethPort = vblpEthPortMap.get(Integer.parseInt(str));
            if (null == ethPort) continue;
            if (0 != buffer.length()) {
                buffer.append(',');
            }
            buffer.append(ethPort);
        }
        ethportList = buffer.toString();
        return ethportList;
    }
}

