/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import com.huawei.nglct.util.errinfo.TEErrInfo;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEGetVBLinkDBHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEGetVBLinkDBHandler() {
    }

    public static TEErrInfoReturn getVBLinkFromDB(int neID, int slotID, int vbID, Map<Integer, List<TEEtherVBLinkMOPO>> moLinkMap) {
        int retCode = 0;
        if (null == moLinkMap) {
            return new TEErrInfoReturn();
        }
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            TEGetVBLinkDBHandler.logVBMONullError(neID, slotID, vbID);
            retCode = 1090598181;
            return TEGetVBLinkDBHandler.constructErrInfoReturn(new int[]{neID, slotID, vbID}, retCode);
        }
        return TEGetVBLinkDBHandler.getVBLinkFromMO(neID, slotID, vbID, moLinkMap, vbMO);
    }

    public static TEErrInfoReturn getVBLinkFromMO(int neID, int slotID, int vbID, Map<Integer, List<TEEtherVBLinkMOPO>> moLinkMap, TEEtherBridgeMOPO vbMO) {
        TEEtherVBLinkMOPO vbLinkMO = null;
        Set vbLinkMOSet = vbMO.getLinkList();
        Iterator iter = vbLinkMOSet.iterator();
        int vblpPort = -1;
        List<TEEtherVBLinkMOPO> moLinkList = null;
        while (iter.hasNext()) {
            vbLinkMO = (TEEtherVBLinkMOPO)iter.next();
            vblpPort = vbLinkMO.getVBPortID();
            moLinkList = moLinkMap.get(vblpPort);
            if (null == moLinkList) {
                moLinkList = new ArrayList<TEEtherVBLinkMOPO>();
                moLinkMap.put(vblpPort, moLinkList);
            }
            moLinkList.add(vbLinkMO);
        }
        return new TEErrInfoReturn();
    }

    public static TEErrInfoReturn constructErrInfoReturn(int[] objID, int retCode) {
        TEErrInfoReturn errRet = new TEErrInfoReturn();
        errRet.setResult(2);
        TEErrInfo errInfo = new TEErrInfo();
        errInfo.setObjID(objID);
        errInfo.setErrorCode(retCode);
        errRet.addErrInfo(errInfo);
        return errRet;
    }

    private static void logVBMONullError(int neID, int slotID, int vbID) {
        String tipStr = "The vbMO is not exist! ";
        tipStr = tipStr + String.format("[neID:%d,slotID:%d,vbID:%d]", neID, slotID, vbID);
        e2eLogger.error(tipStr);
    }
}

