/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.network.qasn.m_q_ipservice.QAsnVBDeleteRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.ErrorMessage;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.oam.TEEthServiceOAMUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2EDelVBMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2EVBNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;

public final class TEDeleteVBDBHander {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEDeleteVBDBHander() {
    }

    public static List<TEEtherBridgeMOPO> delVBFromDB(int neID, int slotID, Datainterface inputData, Datainterface outputData) {
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        Param param = null;
        int vbID = -1;
        RowParams[] rowParamArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamArr.length;
        for (int i = 0; i < len; ++i) {
            param = rowParamArr[i].getParam("vbid");
            if (null == param) continue;
            vbID = Integer.parseInt(param.getValue());
            int result = TEE2EVBUtil.delVBMOFromDB(neID, slotID, vbID, vbMOList);
            if (0 != result) {
                TEDeleteVBDBHander.constructErrCode(inputData, outputData, result);
                continue;
            }
            TEEthServiceOAMUtil.deleteElanOAM(neID, slotID, vbID);
        }
        return vbMOList;
    }

    public static List<TEEtherBridgeMOPO> delVBFromDB(int neID, int slotID, Set<Integer> vbIdList, Datainterface inputData, Datainterface outputData) {
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        Param param = null;
        int vbID = -1;
        RowParams[] rowParamArr = inputData.getBussinessParams().getRowParams();
        int len = rowParamArr.length;
        for (int i = 0; i < len; ++i) {
            param = rowParamArr[i].getParam("vbid");
            if (null == param || !vbIdList.contains(vbID = Integer.parseInt(param.getValue()))) continue;
            int result = TEE2EVBUtil.delVBMOFromDB(neID, slotID, vbID, vbMOList);
            if (0 != result) {
                TEDeleteVBDBHander.constructErrCode(inputData, outputData, result);
                continue;
            }
            TEEthServiceOAMUtil.deleteElanOAM(neID, slotID, vbID);
        }
        return vbMOList;
    }

    private static void constructErrCode(Datainterface inputData, Datainterface outputData, int result) {
        ErrorMessage errorMessage = new ErrorMessage();
        errorMessage.setErrorcode(String.valueOf(result));
        RowErrors rowErrors = new RowErrors();
        rowErrors.setErrorMessage(errorMessage);
        rowErrors.setParam(inputData.getBussinessParams().getRowParams(0).getParam());
        int retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 == retCode) {
            errorMessage = outputData.getErrorMessage();
            errorMessage.setErrorcode(String.valueOf(1));
            RowParams rowParam = new RowParams();
            rowParam.addRowErrors(rowErrors);
            outputData.getBussinessParams().addRowParams(0, rowParam);
        } else {
            outputData.getBussinessParams().getRowParams(0).addRowErrors(rowErrors);
        }
    }

    public static void sendDelVBMessage(int neid, int slotID, List<TEEtherBridgeMOPO> delVBMOList) {
        if (!delVBMOList.isEmpty() && TEDeleteVBDBHander.isNeedSendDelNtf()) {
            QAsnVBDeleteRpt content = new QAsnVBDeleteRpt();
            content.vbInfoList = TEE2EVBUtil.convertPOVBToAsnVB(neid, slotID, delVBMOList);
            TEE2EDelVBMsg e2eVBMsg = new TEE2EDelVBMsg(content);
            e2eLogger.info("sendDelVBMessage: send message.");
            TEE2EVBNoticeMgr.sendDelNtf(e2eVBMsg);
        }
    }

    public static boolean isNeedSendDelNtf() {
        boolean isNeed = false;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            isNeed = true;
        }
        return isNeed;
    }
}

