/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db;

import com.huawei.network.qasn.m_q_ipservice.QAsnVBCreateRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2ECreateVBMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.event.TEE2EVBNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;

public final class TECreateVBDBHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TECreateVBDBHandler() {
    }

    public static List<Integer> getVBIDList(int neID, int slotID) {
        e2eLogger.info("getVBIDList: begin");
        ArrayList<Integer> vbIDList = new ArrayList<Integer>();
        List<TEEtherBridgeMOPO> vbMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        if (vbMOList.isEmpty()) {
            e2eLogger.info("getVBIDList: vbMOList is empty!");
            e2eLogger.info("getVBIDList: end");
            return vbIDList;
        }
        for (TEEtherBridgeMOPO vbMO : vbMOList) {
            vbIDList.add(vbMO.getVBID());
        }
        e2eLogger.info("getVBIDList: end");
        return vbIDList;
    }

    public static List<TEEtherBridgeMOPO> getCreatedVB(int neID, int slotID, List<Integer> oldVBIDList) {
        e2eLogger.info("getCreatedVB: begin");
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        int vbid = -1;
        int retCode = TEE2EVBUtil.getVBFromNE(neID, slotID);
        if (0 != retCode) {
            String tipStr = "getCreatedVB: Get vb from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
        }
        List<TEEtherBridgeMOPO> newVBMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
        for (TEEtherBridgeMOPO vbMO : newVBMOList) {
            vbid = vbMO.getVBID();
            if (null == oldVBIDList || oldVBIDList.contains(vbid)) continue;
            vbMOList.add(vbMO);
        }
        e2eLogger.info("getCreatedVB: end");
        return vbMOList;
    }

    public static void sendCreateVBMessage(int neid, int slotID, TEEtherBridgeMOPO vbMO) {
        ArrayList<TEEtherBridgeMOPO> vbMOList = new ArrayList<TEEtherBridgeMOPO>();
        vbMOList.add(vbMO);
        TECreateVBDBHandler.sendCreateVBMessage(neid, slotID, vbMOList);
    }

    public static void sendCreateVBMessage(int neid, int slotID, List<TEEtherBridgeMOPO> vbMOList) {
        e2eLogger.info("sendCreateVBMessage: begin.");
        if (vbMOList.isEmpty()) {
            e2eLogger.info("sendCreateVBMessage: end. the vbMOList is empty!");
            return;
        }
        QAsnVBCreateRpt content = new QAsnVBCreateRpt();
        content.vbInfoList = TEE2EVBUtil.convertPOVBToAsnVB(neid, slotID, vbMOList);
        content.procID = 0;
        TEE2ECreateVBMsg e2eVBMsg = new TEE2ECreateVBMsg(content);
        TEE2EVBNoticeMgr.sendCreateNtf(e2eVBMsg);
        e2eLogger.info("sendCreateVBMessage: end.");
    }
}

