/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice;

import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBInfoListIF;
import com.huawei.nglct.util.errinfo.TEErrInfoReturn;
import com.huawei.nglct.util.string.TEStringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class TEVBInfoListImplOnS
implements TEVBInfoListIF {
    private static final int VBPORT_FLG = 28672;
    private HashMap vbMemMap = new HashMap();
    private ArrayList otherLinkPortList = new ArrayList();
    private ArrayList linkIdList = new ArrayList();
    private int neID;
    private int slotID;

    public TEVBInfoListImplOnS(int neID, int slotID) {
        this.neID = neID;
        this.slotID = slotID;
    }

    public int getNeID() {
        return this.neID;
    }

    public void setNeID(int neID) {
        this.neID = neID;
    }

    public int getSlotID() {
        return this.slotID;
    }

    @Override
    public void setSlotID(int slotID) {
        this.slotID = slotID;
    }

    @Override
    public void clearMemData() {
        this.vbMemMap.clear();
        this.otherLinkPortList.clear();
        this.linkIdList.clear();
    }

    @Override
    public HashMap getPortMap(String vbid) {
        return (HashMap)this.vbMemMap.get(vbid);
    }

    @Override
    public void addItem(String vbid, int lpCount) {
        HashMap<String, TELinkPortInfo> linkPortMap = new HashMap<String, TELinkPortInfo>();
        TELinkPortInfo linkPortInfo = null;
        int lpNo = 0;
        for (int i = 0; i < lpCount; ++i) {
            linkPortInfo = new TELinkPortInfo();
            lpNo = 28672 + i + 1;
            linkPortInfo.setLpNo(String.valueOf(lpNo));
            linkPortMap.put(String.valueOf(lpNo), linkPortInfo);
        }
        this.vbMemMap.put(vbid, linkPortMap);
    }

    @Override
    public void addPort(String vbid, String lpNo, TELinkPortInfo linkPort) {
        HashMap linkPortMap = this.getPortMap(vbid);
        linkPortMap.put(lpNo, linkPort);
    }

    @Override
    public void setPortAttribute(String linkid, String vbid, String lpNo, String portid, String direction) {
        TELinkPortInfo linkPort = (TELinkPortInfo)this.getPortMap(vbid).get(lpNo);
        this.addLinkIdList(linkid);
        linkPort.setPortAttribute(linkid, lpNo, portid, direction);
    }

    @Override
    public void delPortAttribute(String vbid, String lpNo) {
        TELinkPortInfo linkPort = (TELinkPortInfo)this.getPortMap(vbid).get(lpNo);
        linkPort.clearAllAttribute();
    }

    @Override
    public void delVB(String vbid) {
        this.vbMemMap.remove(vbid);
    }

    @Override
    public boolean hasVB(String vbid) {
        HashMap vbMap = this.getPortMap(vbid);
        return null != vbMap;
    }

    @Override
    public boolean hasVBLink(String vbid) {
        HashMap linkPortMap = this.getPortMap(vbid);
        for (TELinkPortInfo tempLinkPort : linkPortMap.values()) {
            if (null == tempLinkPort.getPortId()) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArrayList getLinkPorts(String vbid) {
        ArrayList<TELinkPortInfo> portList = new ArrayList<TELinkPortInfo>();
        HashMap linkPortMap = this.getPortMap(vbid);
        if (linkPortMap == null) {
            return portList;
        }
        for (TELinkPortInfo tempLinkPort : linkPortMap.values()) {
            portList.add(tempLinkPort);
        }
        Collections.sort(portList);
        return portList;
    }

    @Override
    public ArrayList getPortIdsByVB(String vbid) {
        ArrayList<String> portidList = new ArrayList<String>();
        ArrayList portList = this.getLinkPorts(vbid);
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getPortId().equals("0")) continue;
            portidList.add(tempLinkPort.getPortId());
        }
        return portidList;
    }

    @Override
    public void addOtherLinkPort(String linkPortId) {
        this.otherLinkPortList.add(linkPortId);
    }

    @Override
    public ArrayList getOtherLinkPortList() {
        return this.otherLinkPortList;
    }

    @Override
    public void addLinkIdList(String linkid) {
        this.linkIdList.add(new Integer(linkid));
        Collections.sort(this.linkIdList);
    }

    @Override
    public ArrayList getAllLinkId() {
        return this.linkIdList;
    }

    @Override
    public ArrayList getAvailableLinkId(int linkCount) {
        int i;
        ArrayList<Integer> availLinkIdList = new ArrayList<Integer>();
        int count = 0;
        int dispersion = 0;
        int newlinkid = 0;
        int listlen = this.linkIdList.size();
        for (i = 0; i < listlen - 1; ++i) {
            newlinkid = Integer.parseInt((String)this.linkIdList.get(i));
            dispersion = Integer.parseInt((String)this.linkIdList.get(i + 1)) - newlinkid;
            if (dispersion <= 1) continue;
            count += dispersion - 1;
            for (int j = 0; j < dispersion; ++j) {
                availLinkIdList.add(++newlinkid);
            }
        }
        if (count < linkCount) {
            newlinkid = this.linkIdList.isEmpty() ? 0 : Integer.parseInt((String)this.linkIdList.get(this.linkIdList.size() - 1));
            for (i = 0; i < linkCount - count; ++i) {
                availLinkIdList.add(++newlinkid);
            }
        }
        return availLinkIdList;
    }

    @Override
    public void deleteLinkportByLinkid(String vbid, ArrayList linkPortList) {
        HashMap linkPortMap = this.getPortMap(vbid);
        if (null == linkPortMap) {
            return;
        }
        for (TELinkPortInfo tempLinkPort : linkPortMap.values()) {
            if (!linkPortList.contains(tempLinkPort.getLinkid())) continue;
            tempLinkPort.clearAllAttribute();
        }
    }

    @Override
    public ArrayList getAllUsedPort() {
        ArrayList<Integer> usedPortList = new ArrayList<Integer>();
        Iterator memMapIt = this.vbMemMap.values().iterator();
        HashMap linkPortMap = null;
        Iterator linkPortIt = null;
        TELinkPortInfo linkPortInfo2 = null;
        while (memMapIt.hasNext()) {
            linkPortMap = (HashMap)memMapIt.next();
            for (TELinkPortInfo linkPortInfo2 : linkPortMap.values()) {
                if (linkPortInfo2.getPortId().equals("0")) continue;
                usedPortList.add(new Integer(linkPortInfo2.getPortId()));
            }
        }
        if (null != this.otherLinkPortList && 0 == this.otherLinkPortList.size()) {
            usedPortList.addAll(this.otherLinkPortList);
        }
        return usedPortList;
    }

    @Override
    public TELinkPortInfo getLinkPortInfoByLpNo(String vbid, String lpNo) {
        TELinkPortInfo linkPort = (TELinkPortInfo)this.getPortMap(vbid).get(lpNo);
        return linkPort;
    }

    @Override
    public ArrayList getLinkIds(String vbid) {
        ArrayList<String> linkIdList = new ArrayList<String>();
        ArrayList portList = this.getLinkPorts(vbid);
        int listlen = portList.size();
        for (int i = 0; i < listlen; ++i) {
            TELinkPortInfo tempLinkPort = (TELinkPortInfo)portList.get(i);
            if (tempLinkPort.getLinkid().equals("0")) continue;
            linkIdList.add(tempLinkPort.getLinkid());
        }
        return linkIdList;
    }

    @Override
    public TEErrInfoReturn getTELinkPortInfoDB(int neID, int slotID, int vbID, Map<Integer, List<TELinkPortInfo>> linkPortInfoMap) {
        ArrayList linkPortList = this.getLinkPorts(String.valueOf(vbID));
        TELinkPortInfo aInfo = null;
        List<TELinkPortInfo> tempLinkPortList = null;
        int listlen = linkPortList.size();
        for (int i = 0; i < listlen; ++i) {
            aInfo = (TELinkPortInfo)linkPortList.get(i);
            if (!TEStringUtils.isNumber((String)aInfo.getLpNo())) continue;
            tempLinkPortList = linkPortInfoMap.get(aInfo.getLpNo());
            if (null == tempLinkPortList) {
                tempLinkPortList = new ArrayList<TELinkPortInfo>();
                linkPortInfoMap.put(Integer.parseInt(aInfo.getLpNo()), tempLinkPortList);
            }
            tempLinkPortList.add(aInfo);
        }
        return new TEErrInfoReturn();
    }
}

