/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowErrors;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TELinkPortInfo;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TENEVBContainer;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEParseEthLanConfFile;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBInfoList;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBNEOperWrapperIF;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.db.TEVBInfoListUtil;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.io.File;
import java.util.ArrayList;

public class TEQueryVBBean
extends TEVBMgrSuperBean {
    private static final int NA_VALUE = 65535;
    private static final String QUERYRESULT_EMPTY = "38662";
    private static final int GET_VB_CMDID = 30807;
    private static final String FILE_NAME = "nemgr" + File.separator + "ip" + File.separator + "ngwdm" + File.separator + "res" + File.separator + "ethlanservice" + File.separator + "vbdesres_";
    private static final int VCTRUNC_FLG = 32768;
    private static final int GET_PORTTYPE_CMDID = 30793;
    private static final int GET_PORTENABLE_CMDID = 29090;
    private static final int GET_HUBSPOKE_CMDID = 31593;
    private static final String LINK_COMMON = "1";
    private ArrayList tempOperList = new ArrayList();
    private String firstVBId;
    private String slotid;
    private String vbtype = "";
    private String vbmode = "";
    private String macenable = "";
    private boolean hasHubSpokeOper = false;

    @Override
    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            TEVBNEOperWrapperIF observer = TEVBMgrSuperBean.getNEOperWrapper(neid, subFunc);
            if (null != observer) {
                observer.doBeforePerfomBussinessProcess(neid, subFunc, inputData, inputData);
            }
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowErrors secondSendErrRow = null;
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            if (null == this.operationList || this.operationList.isEmpty()) {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                return this.outputData;
            }
            int result = this.sendMessage(neid);
            if (0 == result) {
                this.tempOperList = (ArrayList)this.operationList.clone();
                this.operationList.clear();
                int listlen = this.tempOperList.size();
                for (int i = 0; i < listlen; ++i) {
                    Operation tempOper = (Operation)this.tempOperList.get(i);
                    if (tempOper.getCmdid() == 30807) {
                        if (1 == tempOper.getOutputCount() && !tempOper.getOutput(0).getFault(0).getCode().equals("0")) {
                            if (tempOper.getOutput(0).getFault(0).getCode().equals(QUERYRESULT_EMPTY)) {
                                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
                            } else {
                                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(tempOper.getOutput(0).getFault(0).getCode())));
                            }
                            if (this.isNeedOperationlog()) {
                                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
                            }
                            return this.outputData;
                        }
                        this.handleVBData(tempOper);
                        continue;
                    }
                    this.handleLinkData(tempOper);
                }
                if (!this.operationList.isEmpty() && 0 != (result = this.sendMessage(neid))) {
                    secondSendErrRow = new RowErrors();
                    secondSendErrRow.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
                }
                this.handleMessage(neid, this.operationList, subFunc, secondSendErrRow);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    protected boolean isSaveVBToDB() {
        boolean isSave = false;
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            isSave = true;
        }
        return isSave;
    }

    public void handleVBData(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        int slotID = TEVBInfoListUtil.getSlotID(this.inputData);
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid, slotID).getVBList(this.neid);
        vbInfoList.clearMemData();
        TEBoard board = TEConfigurationDataMgr.getInstance().getBoard(this.neid, Integer.parseInt(operation.getInput().getPartValue("slotid")));
        String bdCpType = String.valueOf(board.getBoardType());
        TEParseEthLanConfFile confFileObj = TEParseEthLanConfFile.getInstance();
        int listlen = operation.getOutputCount();
        for (int i = 0; i < listlen; ++i) {
            if (!outputs[i].getFault(0).getCode().equals("0")) continue;
            output = outputs[i];
            if (0 == i) {
                this.firstVBId = output.getPartValue("vbid").trim();
                this.slotid = output.getPartValue("slotid");
            }
            vbInfoList.addItem(output.getPartValue("vbid").trim(), Integer.parseInt(output.getPartValue("lpcount")));
            if (confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "vbtyperes", "IsSupportModify").equals("no")) {
                this.vbtype = this.getVBType(confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "vbtyperes", "vbtype"));
            }
            if (confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "vbswicthmode", "IsSupportModify").equals("no")) {
                this.vbmode = confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "vbswicthmode", "mode");
            }
            if (!confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "macaddress", "IsSupportModify").equals("no")) continue;
            this.macenable = this.getMacenable(confFileObj.getChildNodeAttrValue(this.neid, bdCpType, "macaddress", "EnableStatus"));
        }
    }

    private String getVBType(String vbtypeNo) {
        switch (Integer.parseInt(vbtypeNo)) {
            case 1: {
                return "802.1q";
            }
            case 2: {
                return "802.1d";
            }
            case 3: {
                return "802.1ad";
            }
        }
        return "";
    }

    private String getVBMode(String vbmodeNo) {
        TEResourceUtil res = null;
        StringBuffer filePath = new StringBuffer(FILE_NAME).append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEResourceUtil.getInstance((String)filePath.toString());
        switch (Integer.parseInt(vbmodeNo)) {
            case 1: {
                return res.getString("vbmode1");
            }
            case 2: {
                return res.getString("vbmode2");
            }
            case 3: {
                return res.getString("vbmode3");
            }
            case 4: {
                return res.getString("vbmode4");
            }
        }
        return "";
    }

    private String getMacenable(String macenableNo) {
        TEResourceUtil res = null;
        StringBuffer filePath = new StringBuffer(FILE_NAME).append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEResourceUtil.getInstance((String)filePath.toString());
        switch (Integer.parseInt(macenableNo)) {
            case 0: {
                return res.getString("disable");
            }
            case 1: {
                return res.getString("enable");
            }
        }
        return "";
    }

    public void handleLinkData(Operation operation) {
        Output[] outputs = operation.getOutput();
        Output output = null;
        int slotID = TEVBInfoListUtil.getSlotID(this.inputData);
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid, slotID).getVBList(this.neid);
        for (int i = operation.getOutputCount() - 1; i >= 0; --i) {
            output = outputs[i];
            if (!output.getFault(0).getCode().equals("0")) continue;
            if (output.getPartValue("linktype").equals(LINK_COMMON)) {
                vbInfoList.addOtherLinkPort(output.getPartValue("ingressport"));
                vbInfoList.addOtherLinkPort(output.getPartValue("egressport"));
                vbInfoList.addLinkIdList(output.getPartValue("linkid"));
                operation.removeOutput(output);
                continue;
            }
            String vbid = "";
            String portid = "";
            String lpid = "";
            String linktype = "";
            String linkid = "";
            if (!output.getPartValue("ingressvbid").equals(String.valueOf(65535))) {
                vbid = output.getPartValue("ingressvbid");
                portid = output.getPartValue("egressport");
                lpid = output.getPartValue("ingressport");
            }
            if (!output.getPartValue("egressvbid").equals(String.valueOf(65535))) {
                vbid = output.getPartValue("egressvbid");
                portid = output.getPartValue("ingressport");
                lpid = output.getPartValue("egressport");
            }
            linktype = output.getPartValue("linktype");
            linkid = output.getPartValue("linkid");
            this.slotid = output.getPartValue("slotid");
            this.addNewOperation(vbid, portid, lpid, linktype, linkid, this.slotid);
            operation.removeOutput(output);
        }
        Input input = null;
        if (!this.hasHubSpokeOper) {
            operation = TECreateObjectFactory.getOperation((int)this.neid, (int)31593);
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("vbid", this.firstVBId);
            input.setPartValue("vbport", "0");
            this.operationList.add(operation.clone());
        }
    }

    public void addNewOperation(String vbid, String portid, String lpid, String linktype, String linkid, String slotid) {
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(this.neid, Integer.parseInt(slotid)).getVBList(this.neid);
        if ("".equals(vbid) || "".equals(portid) || "".equals(lpid) || "".equals(linktype) || "".equals(linkid)) {
            return;
        }
        if (vbInfoList.hasVB(vbid)) {
            vbInfoList.setPortAttribute(linkid, vbid, lpid, portid, linktype);
        }
        Operation operation = null;
        Input input = null;
        if (vbid.equals(this.firstVBId)) {
            operation = TECreateObjectFactory.getOperation((int)this.neid, (int)30793);
            input = operation.getInput();
            input.setPartValue("slotid", slotid);
            input.setPartValue("port", portid);
            this.operationList.add(operation.clone());
            if (Integer.parseInt(portid) < 32768) {
                operation = TECreateObjectFactory.getOperation((int)this.neid, (int)29090);
                input = operation.getInput();
                input.setPartValue("slotid", slotid);
                input.setPartValue("port", portid);
                this.operationList.add(operation.clone());
            }
        }
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, RowErrors secondSendErrRow) {
        int i;
        RowParams rowparam;
        this.doBeforeHandleMessage(neid, operationList, subfunc, subfunc.getFilterErrCodeList());
        ArrayList<Integer> errcodeList = new ArrayList<Integer>();
        errcodeList.add(38662);
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)this.tempOperList, errcodeList);
        int rowlen = this.outputData.getBussinessParams().getRowParamsCount();
        RowErrors[] rowerrors = null;
        if (this.outputData.getBussinessParams().getRowParams(rowlen - 1).getRowErrorsCount() > 0) {
            rowerrors = this.outputData.getBussinessParams().getRowParams(--rowlen).getRowErrors();
        }
        for (int i2 = 0; i2 < rowlen; ++i2) {
            this.outputData.getBussinessParams().getRowParams(i2).getParam("vbtype").setValue(this.vbtype);
            this.outputData.getBussinessParams().getRowParams(i2).getParam("vbswitchtype").setValue(this.getVBMode(this.vbmode));
            this.outputData.getBussinessParams().getRowParams(i2).getParam("vbstudytype").setValue(TEQueryVBBean.getStudyMode(this.vbmode));
            this.outputData.getBussinessParams().getRowParams(i2).getParam("ingressfilter").setValue(TEQueryVBBean.getIngressStatus(this.vbmode));
            this.outputData.getBussinessParams().getRowParams(i2).getParam("macaddrenable").setValue(this.macenable);
            this.outputData.getBussinessParams().getRowParams(i2).getParam("isVBData").setValue(LINK_COMMON);
        }
        Param param = null;
        if (null != rowerrors && rowerrors.length > 0) {
            for (int i3 = 0; i3 < rowerrors.length; ++i3) {
                param = new Param();
                if (null != rowerrors[i3].getParam("vbid")) {
                    param.setName("attrid");
                    param.setValue("queryvb");
                } else {
                    param.setName("attrid");
                    param.setValue("queryvblink");
                }
                rowerrors[i3].addParam(param);
            }
        }
        int slotID = TEVBInfoListUtil.getSlotID(this.inputData);
        TEVBInfoList vbInfoList = TENEVBContainer.getInstance(neid, slotID).getVBList(neid);
        ArrayList vbLinkList = vbInfoList.getLinkPorts(this.firstVBId);
        String portid = "0";
        String vbport = "0";
        param = null;
        TELinkPortInfo linkport = null;
        for (int i4 = 0; i4 < vbLinkList.size(); ++i4) {
            linkport = (TELinkPortInfo)vbLinkList.get(i4);
            rowparam = new RowParams();
            param = new Param("linkid", linkport.getLinkid());
            rowparam.addParam(param);
            vbport = linkport.getLpNo();
            param = new Param("vbport", vbport);
            rowparam.addParam(param);
            portid = linkport.getPortId();
            param = new Param("portid", portid);
            rowparam.addParam(param);
            param = new Param("portname", linkport.getPortName());
            rowparam.addParam(param);
            param = new Param("direction", linkport.getDirection());
            rowparam.addParam(param);
            param = new Param("porttype", "-");
            rowparam.addParam(param);
            param = new Param("portenable", "-");
            rowparam.addParam(param);
            param = new Param("hubspoke", "-");
            rowparam.addParam(param);
            param = new Param("isVBData", "0");
            rowparam.addParam(param);
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
        if (null == operationList || operationList.isEmpty()) {
            return;
        }
        Operation operation = null;
        RowErrors rowerr = null;
        ArrayList<RowErrors> errrowList = new ArrayList<RowErrors>();
        TENE ne = TEConfigurationDataMgr.getInstance().getNE(neid);
        String nename = ne.getNEName();
        String boardname = "";
        String slotid = "";
        if (null == secondSendErrRow) {
            for (int i5 = operationList.size() - 1; i5 >= 0; --i5) {
                operation = (Operation)operationList.get(i5);
                if (operation.getOutput(0).getFault(0).getCode().equals("0")) continue;
                rowerr = new RowErrors();
                param = new Param("nename", nename);
                rowerr.addParam(param);
                slotid = operation.getInput().getPartValue("slotid");
                param = new Param("slotid", slotid);
                rowerr.addParam(param);
                boardname = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid)).getBoardName();
                param = new Param("boardname", boardname);
                rowerr.addParam(param);
                if (operation.getInput().getPart("vbid") != null) {
                    param = new Param("lpNo", operation.getInput().getPartValue("vbport"));
                    rowerr.addParam(param);
                    param = new Param("attrid", "queryhub");
                    rowerr.addParam(param);
                }
                if (operation.getInput().getPart("port") != null) {
                    param = new Param("portid", operation.getInput().getPartValue("port"));
                    rowerr.addParam(param);
                    param = new Param("attrid", "queryportattr");
                    rowerr.addParam(param);
                }
                rowerr.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)Integer.parseInt(operation.getOutput(0).getFault(0).getCode())));
                errrowList.add(rowerr);
                operationList.remove(i5);
            }
        } else {
            operation = (Operation)operationList.get(0);
            param = new Param("nename", nename);
            secondSendErrRow.addParam(param);
            slotid = operation.getInput().getPartValue("slotid");
            param = new Param("slotid", slotid);
            secondSendErrRow.addParam(param);
            boardname = TEConfigurationDataMgr.getInstance().getBoard(neid, Integer.parseInt(slotid)).getBoardName();
            param = new Param("boardname", boardname);
            secondSendErrRow.addParam(param);
            param = new Param("attrid", "queryportattr");
            secondSendErrRow.addParam(param);
            errrowList.add(secondSendErrRow);
            operationList.clear();
        }
        param = null;
        String porttype = "-";
        String portenable = "-";
        String hubspoke = "-";
        if (!operationList.isEmpty()) {
            int paramlen = this.outputData.getBussinessParams().getRowParamsCount();
            for (i = 0; i < paramlen; ++i) {
                rowparam = this.outputData.getBussinessParams().getRowParams(i);
                if (rowparam.getParam("isVBData").getValue().equals(LINK_COMMON)) continue;
                portid = rowparam.getParam("portid").getValue();
                vbport = rowparam.getParam("vbport").getValue();
                block5: for (int j = 0; j < operationList.size(); ++j) {
                    operation = (Operation)operationList.get(j);
                    if (operation.getCmdid() == 30793) {
                        if ("0".equals(portid) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                        porttype = operation.getOutput(0).getPartValue("PE_TYPE");
                        rowparam.getParam("porttype").setValue(porttype);
                        continue;
                    }
                    if (operation.getCmdid() == 29090) {
                        if ("0".equals(portid) || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                        portenable = operation.getOutput(0).getPartValue("ATTR_ETHOVERSDH_MAC_ENABLE");
                        rowparam.getParam("portenable").setValue(portenable);
                        continue;
                    }
                    if (operation.getCmdid() != 31593) continue;
                    int outputlen = operation.getOutputCount();
                    for (int k = 0; k < outputlen; ++k) {
                        if (!vbport.equals(operation.getOutput(k).getPartValue("vbport"))) continue;
                        hubspoke = operation.getOutput(k).getPartValue("hubspoke");
                        rowparam.getParam("hubspoke").setValue(hubspoke);
                        continue block5;
                    }
                }
            }
        }
        rowparam = new RowParams();
        if (rowerrors != null) {
            rowparam.setRowErrors(rowerrors);
        }
        int errlen = errrowList.size();
        for (i = 0; i < errlen; ++i) {
            rowparam.addRowErrors((RowErrors)errrowList.get(i));
        }
        if (0 != rowparam.getRowErrorsCount()) {
            this.outputData.getBussinessParams().addRowParams(rowparam);
        }
        if (errrowList.isEmpty() && this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)0));
        } else if (!errrowList.isEmpty() || !this.outputData.getErrorMessage().getErrorcode().equals("0")) {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1));
        } else {
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)2));
        }
    }

    public static String getStudyMode(String vbmode) {
        switch (Integer.parseInt(vbmode)) {
            case 1: 
            case 2: {
                return "IVL";
            }
            case 3: 
            case 4: {
                return "SVL";
            }
        }
        return "";
    }

    public static String getIngressStatus(String vbmode) {
        TEResourceUtil res = null;
        StringBuffer filePath = new StringBuffer(FILE_NAME).append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        res = TEResourceUtil.getInstance((String)filePath.toString());
        switch (Integer.parseInt(vbmode)) {
            case 1: 
            case 3: {
                return res.getString("enable");
            }
            case 2: 
            case 4: {
                return res.getString("disable");
            }
        }
        return "";
    }
}

