/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEMACAddressCache;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import java.util.ArrayList;

public class TEQueryMACByConditionBean
extends TENEExplorerBean {
    private static final int FILTER_BY_PORT = 1;
    private static final int FILTER_BY_PORTVLAN = 2;
    private int queryType = -1;
    private int filterCondition = -1;
    private String vbid = "-1";
    private String slotid = "-1";
    private String pageNum = "1";
    private int QUERY_TYPE_BEGIN = 1;
    private int QUERY_TYPE_NEXT = 2;
    private int PORT_TYPE_PRE = 0;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            this.outputData = new Datainterface();
            RowParams rowParams = inputData.getBussinessParams().getRowParams()[0];
            this.filterCondition = Integer.parseInt(rowParams.getParam("filterCondition").getValue());
            this.queryType = Integer.parseInt(rowParams.getParam("queryType").getValue());
            this.vbid = rowParams.getParam("vbid").getValue();
            this.slotid = rowParams.getParam("slotid").getValue();
            this.pageNum = rowParams.getParam("pageNum").getValue();
            String key = neid + "_" + this.slotid + "_" + this.vbid + "_" + this.filterCondition;
            String keyPageNum = key + "_" + this.pageNum;
            if (this.QUERY_TYPE_BEGIN == this.queryType) {
                TEMACAddressCache.getInstance().clearCache(key);
            } else {
                if (this.PORT_TYPE_PRE == this.queryType || 3 == this.queryType) {
                    return TEMACAddressCache.getInstance().getCahce(key, keyPageNum);
                }
                if (this.QUERY_TYPE_NEXT == this.queryType && null != TEMACAddressCache.getInstance().getCahce(key, keyPageNum)) {
                    return TEMACAddressCache.getInstance().getCahce(key, keyPageNum);
                }
            }
            this.operationList = this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                this.handleMessage(neid, this.operationList, subFunc);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("TEQueryMACByConditionBean performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc) {
        TEMACAddressCache instance = TEMACAddressCache.getInstance();
        String keyPart = this.neid + "_" + this.slotid + "_" + this.vbid + "_" + this.filterCondition;
        String keyPageNum = keyPart + "_" + this.pageNum;
        this.outputData = this.getOutputData((Operation)operationList.get(0));
        if (this.outputData.getBussinessParams().getRowParamsCount() > 0 && this.outputData.getBussinessParams().getRowParams(0).getRowErrorsCount() == 0) {
            instance.addCahce(keyPart, keyPageNum, this.outputData);
        }
    }

    private Datainterface getOutputData(Operation operation) {
        Datainterface outputTemp = new Datainterface();
        outputTemp.setBussinessParams(new BussinessParams());
        RowParams errRowParams = new RowParams();
        Output[] outputArr = operation.getOutput();
        boolean successFlag = false;
        int len = outputArr.length;
        for (int i = 0; i < len; ++i) {
            Output output = outputArr[i];
            Fault[] faultArr = output.getFault();
            int errCode = -1;
            for (Fault fault : faultArr) {
                errCode = Integer.parseInt(fault.getCode());
                if (errCode != 0) {
                    RowParams rowParams = new RowParams();
                    rowParams.addParam("endflag", "true");
                    outputTemp.getBussinessParams().addRowParams(rowParams);
                    return outputTemp;
                }
                successFlag = true;
                String portno = output.getPartValue("portno");
                String vlanid = output.getPartValue("vlanid");
                String macaddress = this.getMacAddress(output.getPartValue("macaddress"));
                String macaddressflag = output.getPartValue("macaddressflag");
                RowParams rowParams = new RowParams();
                if (i == 0 && outputArr.length < 20) {
                    rowParams.addParam("endflag", "true");
                } else {
                    rowParams.addParam("endflag", "false");
                }
                rowParams.addParam("portno", portno);
                rowParams.addParam("vlanid", vlanid);
                rowParams.addParam("macaddress", macaddress);
                rowParams.addParam("macaddressflag", macaddressflag);
                outputTemp.getBussinessParams().addRowParams(rowParams);
            }
        }
        if (successFlag) {
            outputTemp.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)0));
        } else {
            outputTemp.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)this.neid, (int)2));
        }
        outputTemp.getBussinessParams().addRowParams(errRowParams);
        return outputTemp;
    }

    private String getMacAddress(String partValue) {
        StringBuffer macStr = new StringBuffer("");
        for (int k = 0; k <= 5; ++k) {
            if (k < 6) {
                macStr.append(partValue.substring(k * 2, k * 2 + 2));
            } else {
                macStr.append(partValue.substring(k * 2));
            }
            if (k >= 5) continue;
            macStr.append('-');
        }
        return macStr.toString();
    }

    public ArrayList getOperation(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Operation operation = null;
        Input input = null;
        RowParams rowParams = inputData.getBussinessParams().getRowParams()[0];
        if (1 == this.filterCondition || 2 == this.filterCondition) {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_MAC_BY_PORTVLAN");
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("vbid", this.vbid);
            input.setPartValue("portno", rowParams.getParam("portno").getValue());
            input.setPartValue("vlanid", rowParams.getParam("vlanid").getValue());
            input.setPartValue("queryType", String.valueOf(this.queryType));
            operationList.add(operation);
        } else {
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_ETHN_GET_PORTVLAN_BY_MAC");
            input = operation.getInput();
            input.setPartValue("slotid", this.slotid);
            input.setPartValue("vbid", this.vbid);
            input.setPartValue("macaddress", rowParams.getParam("macaddress").getValue());
            input.setPartValue("queryType", String.valueOf(this.queryType));
            operationList.add(operation);
        }
        return operationList;
    }
}

