/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfStaticData;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEMACObjTypeIDCreator;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEVCGObjTypeIDCreator;
import gnu.trove.TIntObjectHashMap;
import org.slf4j.Logger;

public class TEObjTypeIDCreator {
    private static Logger logger = TELogFactory.getNormalLogger();
    private static TIntObjectHashMap<TEObjTypeIDCreator> creatorMap = new TIntObjectHashMap();
    private static TEObjTypeIDCreator instance = null;

    protected TEObjTypeIDCreator() {
    }

    private void initCreator() {
        if (creatorMap.isEmpty()) {
            creatorMap.put(61603, (Object)new TEMACObjTypeIDCreator());
            creatorMap.put(61602, (Object)new TEVCGObjTypeIDCreator());
        }
    }

    public static synchronized TEObjTypeIDCreator getInstance() {
        if (null == instance) {
            instance = new TEObjTypeIDCreator();
            instance.initCreator();
        }
        return instance;
    }

    public int[] createObjectID(int neID, int objectTypeID, TEPartSource partSource) {
        TEObjTypeIDCreator creator = this.getCreator(objectTypeID);
        return creator.createObjTypeIDImpl(neID, partSource);
    }

    public static int getObjTypeID(String attrName, String objTypeStr, TEPartSource partSource) {
        Integer objType = null;
        objType = TEEthInfStaticData.getObjTypeNameIDMap().get(objTypeStr);
        if (null != objType) {
            return objType;
        }
        TELogFactory.getNormalLogger().error("get objtype error->" + objTypeStr);
        return -1;
    }

    private TEObjTypeIDCreator getCreator(int objectTypeID) {
        TEObjTypeIDCreator creator = (TEObjTypeIDCreator)creatorMap.get(objectTypeID);
        if (null == creator) {
            logger.error("Get objectTypeID Creator fail! objectTypeID" + objectTypeID);
        }
        return creator;
    }

    protected int[] createObjTypeIDImpl(int neID, TEPartSource partSource) {
        return null;
    }
}

