/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.event;

import com.huawei.network.qasn.m_q_ipbase.QAsnAttrValue;
import com.huawei.network.qasn.m_q_ipbase.QAsnMstpPortChgRpt;
import com.huawei.network.qasn.m_q_ipbase.QAsnMstpPortIndex;
import com.huawei.network.qasn.m_q_ipbase.QAsnMstpPortInfo;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.event.TEEthInfAttrChgMsg;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEEthInfCreateMsg {
    private static final Logger e2elogger = TELogFactory.getE2ELogger();

    private TEEthInfCreateMsg() {
    }

    public static TEEthInfAttrChgMsg createAttrChangeMessage(Map<TEGnlValueElement, Operation> elementOperMap) {
        Set<TEGnlValueElement> elementSet = elementOperMap.keySet();
        QAsnMstpPortChgRpt asnRpt = new QAsnMstpPortChgRpt();
        asnRpt.portInfoList.addAll(TEEthInfCreateMsg.createQAsnMstpPortInfo(elementSet));
        if (asnRpt.portInfoList.isEmpty()) {
            return null;
        }
        return new TEEthInfAttrChgMsg(asnRpt);
    }

    private static Collection<QAsnMstpPortInfo> createQAsnMstpPortInfo(Collection<TEGnlValueElement> elementSet) {
        ArrayList<QAsnMstpPortInfo> asnPortInfoList = new ArrayList<QAsnMstpPortInfo>();
        if (null == elementSet || elementSet.isEmpty()) {
            return asnPortInfoList;
        }
        for (TEGnlValueElement ele : elementSet) {
            QAsnMstpPortInfo asnInfo = TEEthInfCreateMsg.createQAsnMstpPortInfo(ele);
            if (null == asnInfo) continue;
            asnPortInfoList.add(asnInfo);
        }
        return asnPortInfoList;
    }

    private static QAsnMstpPortInfo createQAsnMstpPortInfo(TEGnlValueElement ele) {
        if (!TEEthInfCreateMsg.getStnE2EAttrIDMap().containsKey(ele.getGnlKeyValue().getAttrID())) {
            return null;
        }
        QAsnMstpPortInfo asnInfo = new QAsnMstpPortInfo();
        asnInfo.portIndex = TEEthInfCreateMsg.createQAsnMstpPortIndex(ele.getGnlKeyValue());
        asnInfo.attrList.addAll(TEEthInfCreateMsg.createQAsnAttrValue(ele.getGnlKeyValue().getAttrID(), ele.getGnlValue()));
        asnInfo.phyParams = "".getBytes();
        asnInfo.portLabel = "".getBytes();
        asnInfo.portName = "".getBytes();
        asnInfo.portOwner = "".getBytes();
        return asnInfo;
    }

    protected static Object getEthPortName(int e2ePortID, int e2ePortType) {
        if (0 == e2ePortType) {
            return "PORT" + e2ePortID;
        }
        return "VCTRUNK" + e2ePortID;
    }

    private static QAsnMstpPortIndex createQAsnMstpPortIndex(TEGeneralKeyValue gnlKeyValue) {
        QAsnMstpPortIndex asnPortIndex = new QAsnMstpPortIndex();
        int[] objIDArr = gnlKeyValue.getTEOBJECTID();
        int neID = objIDArr[0];
        int slotID = objIDArr[1];
        int webPortID = objIDArr[2];
        asnPortIndex.neID = neID;
        asnPortIndex.slotID = slotID;
        asnPortIndex.portID = TEEthXCUtil.getE2EPortID(webPortID);
        asnPortIndex.portType = TEEthXCUtil.getE2EPortType(webPortID);
        asnPortIndex.subSlotID = 255;
        asnPortIndex.vbID = -1;
        return asnPortIndex;
    }

    private static List<QAsnAttrValue> createQAsnAttrValue(int attrID, TEGeneralValue gnlValue) {
        ArrayList<QAsnAttrValue> asnValueList = new ArrayList<QAsnAttrValue>();
        QAsnAttrValue asnValue = new QAsnAttrValue();
        asnValue.attrID = TEEthInfCreateMsg.convertToE2EAttrID(attrID);
        asnValue.attrValue = gnlValue.getiValue();
        asnValue.accessState = 0;
        asnValueList.add(asnValue);
        TEEthInfCreateMsg.specialHandle(asnValueList, asnValue);
        return asnValueList;
    }

    private static void specialHandle(List<QAsnAttrValue> asnValueList, QAsnAttrValue orginValue) {
        if (1 == orginValue.attrID) {
            boolean TAG_AWARE = true;
            if (1 == orginValue.attrValue) {
                QAsnAttrValue asnValue = new QAsnAttrValue();
                asnValue.attrID = 2;
                asnValue.attrValue = -1;
                asnValue.accessState = 2;
                asnValueList.add(asnValue);
                asnValue = new QAsnAttrValue();
                asnValue.attrID = 4;
                asnValue.attrValue = -1;
                asnValue.accessState = 2;
                asnValueList.add(asnValue);
            }
        }
    }

    private static int convertToE2EAttrID(int attrID) {
        int e2eID = attrID;
        Integer e2eIDObj = TEEthInfCreateMsg.getStnE2EAttrIDMap().get(attrID);
        if (null != e2eIDObj) {
            e2eID = e2eIDObj;
        } else {
            e2elogger.error("not found e2e id. stnID->" + attrID);
        }
        return e2eID;
    }

    private static Map<Integer, Integer> getStnE2EAttrIDMap() {
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        map.put(401488, 1);
        map.put(401489, 2);
        map.put(401509, 4);
        map.put(401491, 6);
        map.put(401492, 7);
        map.put(401493, 10);
        map.put(401494, 11);
        map.put(401495, 12);
        map.put(401496, 13);
        map.put(401500, 23);
        map.put(401502, 25);
        map.put(401503, 26);
        map.put(401504, 32);
        map.put(401505, 34);
        map.put(401507, 37);
        map.put(401510, 1);
        map.put(401511, 2);
        map.put(401512, 4);
        map.put(401514, 17);
        map.put(401520, 34);
        map.put(401523, 37);
        return map;
    }
}

