/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface;

import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgSetBean;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfStaticData;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.event.TEEthInfAttrChgMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.event.TEEthInfCreateMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.event.TEEthInfNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEPartSource;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TESetEthInfBean
extends TEGenCfgSetBean {
    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        if (TESysManagerBean.getInstance().isIntegratedStatus()) {
            this.doAfterSendCmd(operationList);
        }
        super.handleMessage(neid, subfunc, operationList, filterErrorCodeList);
    }

    protected void doAfterSendCmd(List<Operation> operationList) {
        int boardType;
        Input input = operationList.get(0).getInput();
        int slotID = Integer.parseInt(input.getPartValue("slotid"));
        List<Operation> nmOperList = TESetEthInfBean.filterSetSaveDBOper(operationList, slotID, boardType = TEConfigurationDataMgr.getInstance().getBoardType(this.neid, slotID));
        if (!nmOperList.isEmpty()) {
            String fileName = this.subFunc.getGenCfgAttrDesPath().getContent();
            TESetEthInfBean.saveEthInfAttrToDB(this.neid, fileName, nmOperList);
        }
    }

    public static void saveEthInfAttrToDB(int neID, String gencfgFileName, List<Operation> nmOperList) {
        if (nmOperList.isEmpty()) {
            return;
        }
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(gencfgFileName);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        TEGenCfgFunCmd funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(path);
        TESetEthInfBean.saveAttrInfoToDBOnSet(neID, funCmd, nmOperList);
    }

    private static List<Operation> filterSetSaveDBOper(List operationList, int slotId, int boardType) {
        ArrayList<Operation> nmOperList = new ArrayList<Operation>();
        Operation oper = null;
        for (int i = operationList.size() - 1; i >= 0; --i) {
            oper = (Operation)operationList.get(i);
            if (!TEEthInfUtil.isInputContainNMQueryAttr(oper)) continue;
            nmOperList.add(oper);
        }
        return nmOperList;
    }

    public static void saveAttrInfoToDBOnSet(int neid, TEGenCfgFunCmd funCmd, List<Operation> nmOperList) {
        TEEthInfAttrChgMsg msg;
        Input input = null;
        Part part = null;
        String attrName = null;
        String valueStr = null;
        HashMap<TEGnlValueElement, Operation> elementOperMap = new HashMap<TEGnlValueElement, Operation>();
        TEGnlValueElement element = null;
        Fault fault = null;
        int errorCode = -1;
        for (Operation oper : nmOperList) {
            input = oper.getInput();
            fault = oper.getOutput(0).getFault(0);
            if (null != fault && 0 != (errorCode = Integer.parseInt(fault.getCode()))) continue;
            int jLen = input.getPartCount();
            for (int j = 0; j < jLen; ++j) {
                part = input.getPart(j);
                attrName = part.getName();
                valueStr = part.getValue();
                if (null == valueStr) {
                    valueStr = part.getDefault();
                }
                if (!TEEthInfStaticData.getKeySets().contains(attrName)) continue;
                element = TEEthInfUtil.constructElement(neid, funCmd, new TEPartSource(input), attrName, valueStr);
                elementOperMap.put(element, oper);
            }
        }
        int retCode = TEEthInfUtil.saveAttrInfoToDB(elementOperMap);
        if (0 == retCode && null != (msg = TEEthInfCreateMsg.createAttrChangeMessage(elementOperMap))) {
            TEEthInfNoticeMgr.sendAttrChangeNtf(msg);
        }
    }
}

