/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface;

import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.gencfg.TEGenCfgCmdFactory;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.TEGenCfgQueryBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TECircuitPackDescription;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.TEGetBoardMode;
import com.huawei.nglct.nelist.model.circuitpack.TEPortParaRecord;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.device.ne.TEGetNEDomainVersion;
import com.huawei.nglct.util.io.TEFileUtil;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.nglct.util.string.TEResourceUtil;
import com.huawei.nglct.util.xml.TEResourceManager;
import com.huawei.uflight.qxprotocol.OperationResult;
import com.huawei.uflight.qxprotocol.TENECommMgr;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class TEQueryEthInfBean
extends TEGenCfgQueryBean {
    private static final int SLOTOVER = 39169;
    private static final int FLOWCTRLMODE = 39678;
    private static final String ALMTHR_UP = "1";
    private static final String ALMTHR_DOWN = "2";
    private static final String MAC_LOOPBACK_TYPE = "1";
    private static final String PHY_LOOPBACK_TYPE = "2";
    private static final int PORT_TYRE_ERROR = 39691;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        this.subFunc = subFunc;
        this.inputData = inputData;
        TENE neObj = TENEListMgr.getInstance().getNE(neid);
        this.outputData = new Datainterface();
        if (null == neObj) {
            log.info("Get ne object fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596385));
            return this.outputData;
        }
        this.slotId = Integer.parseInt(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotId);
        String fileName = subFunc.getGenCfgAttrDesPath().getContent();
        StringBuffer funCmdFilePath = new StringBuffer("nemgr").append(File.separator).append(fileName);
        String path = TEResourceManager.getPath() + funCmdFilePath.toString();
        TEGenCfgFunCmd funCmd = TEGenCfgCmdFactory.getInstance().getFunCmd(path);
        if (null == funCmd) {
            log.info("Parse atrribute To qx mapping file fail!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090646019));
            return this.outputData;
        }
        String parentPath = TEFileUtil.getParentPath((String)TEFileUtil.getParentPath((String)TEFileUtil.getParentPath((String)fileName)));
        StringBuffer filePath = new StringBuffer("nemgr").append(File.separator).append(parentPath).append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("gencfg").append(File.separator).append("attribres_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        this.res = TEResourceUtil.getInstance((String)filePath.toString());
        this.operationList = this.getQueryOperationList(funCmd, inputData);
        if (null == this.operationList || this.operationList.isEmpty()) {
            log.info("The operationlist is null!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090596479));
            return this.outputData;
        }
        this.filterOperationList(this.operationList, this.slotId, boardType);
        if (this.operationList.isEmpty()) {
            log.info("Filter result:The operationlist is null!");
            this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)1090593051));
            return this.outputData;
        }
        this.doBeforeQuery(funCmd, boardType);
        if (!this.operationList.isEmpty()) {
            OperationResult result = this.sendBatCommand(this.neid, this.operationList);
            if (0 != result.retCode) {
                log.debug("send command fail!The errorCode is :" + result.retCode);
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result.retCode));
                return this.outputData;
            }
            log.debug("send command success!");
        }
        this.doAfterQuery(funCmd, boardType);
        ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
        this.handleMessage(neid, subFunc, this.operationList, filterErrorCodeList);
        if (this.isNeedOperationlog() && null != user) {
            this.writeLog(neid, subFunc, inputData, user, ipAddress, this.outputData);
        }
        return this.outputData;
    }

    protected OperationResult sendBatCommand(int neID, List<Operation> allOperList) {
        OperationResult result = null;
        ArrayList<Operation> operList = null;
        int m = 200;
        int n = allOperList.size();
        for (int i = 0; i < n; i += m) {
            operList = new ArrayList<Operation>();
            if (i + m > n) {
                operList.addAll(allOperList.subList(i, n));
            } else {
                operList.addAll(allOperList.subList(i, i + m));
            }
            result = TENECommMgr.getInstance().sendCommand(neID, operList, this.getTimeOut());
            if (0 != result.retCode) break;
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                log.error("TEGenCfgQueryBean thread sleep error! ", (Throwable)e);
            }
        }
        return result;
    }

    protected abstract void doBeforeQuery(TEGenCfgFunCmd var1, int var2);

    protected abstract void doAfterQuery(TEGenCfgFunCmd var1, int var2);

    public boolean isNeedExpandOperObj(String attrId) {
        return true;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> temp = new ArrayList<Integer>();
        temp.add(39169);
        temp.add(39678);
        temp.add(39170);
        temp.add(40004);
        temp.add(39691);
        return temp;
    }

    public void handleMessage(int neid, SubFunc subfunc, ArrayList operationList, ArrayList filterErrorCodeList) {
        Operation operation = null;
        int m = operationList.size();
        block0: for (int k = 0; k < m; ++k) {
            operation = (Operation)operationList.get(k);
            if (operation.getName().equals("NSCMD_ETHN_GET_LCAS_ALMTHR_UP")) {
                this.removeSpilthALMTHR(operation, "1");
                continue;
            }
            if (operation.getName().equals("NSCMD_ETHN_GET_LCAS_ALMTHR_DOWN")) {
                this.removeSpilthALMTHR(operation, "2");
                continue;
            }
            if (!operation.getName().equals("NSCMD_ETHN_GET_ETHLOOP") || operation.getOutputCount() <= 0) continue;
            int len = operation.getOutputCount();
            for (int j = 0; j < len; ++j) {
                Output tmpOut = operation.getOutput(j);
                if (tmpOut.getPart("loopBackType") != null && tmpOut.getPart("loopBackType").getValue() != null && tmpOut.getPart("loopBackType").getValue().equals("1") && tmpOut.getPart("ATTR_ETHOVERSDH_MAC_PHY_LOOPBACK") != null) {
                    operation.removeOutput(j);
                    continue block0;
                }
                if (tmpOut.getPart("loopBackType") == null || tmpOut.getPart("loopBackType").getValue() == null || !tmpOut.getPart("loopBackType").getValue().equals("2") || tmpOut.getPart("ATTR_ETHOVERSDH_MAC_MAC_LOOPBACK") == null) continue;
                operation.removeOutput(j);
                continue block0;
            }
        }
        super.handleMessage(neid, subfunc, operationList, filterErrorCodeList);
        int boardType = TEConfigurationDataMgr.getInstance().getBoardType(neid, this.slotId);
        int boardMode = -1;
        if (boardType == 2272) {
            boardMode = TEGetBoardMode.queryBoardMode((int)neid, (int)this.slotId);
        }
        if (boardType == 2272 || boardType == 2109 || boardType == 2292 || boardType == 3005) {
            RowParams[] rowParamses = this.outputData.getBussinessParams().getRowParams();
            RowParams rowParams = null;
            Param param = null;
            int portId = -1;
            ArrayList operList = new ArrayList();
            for (int i = rowParamses.length - 1; i >= 0; --i) {
                rowParams = rowParamses[i];
                if (rowParams.getParam("port") == null) continue;
                portId = Integer.parseInt(rowParams.getParam("port").getValue());
                ArrayList tmpList = new ArrayList();
                if (boardType == 2272 || boardType == 3005) {
                    tmpList = this.createLEM18OperationList(neid, String.valueOf(this.slotId), String.valueOf(portId));
                }
                if (boardType == 2109) {
                    tmpList = this.createLEM24OperationList(neid, String.valueOf(this.slotId), String.valueOf(portId));
                }
                if (boardType == 2292) {
                    tmpList = this.createTEM28OperationList(neid, String.valueOf(this.slotId), String.valueOf(portId));
                }
                operList.addAll(tmpList);
                param = new Param("portModel", "-");
                rowParams.addParam(param);
                param = new Param("portSpeedLevel", "-");
                rowParams.addParam(param);
                param = new Param("boardMode", String.valueOf(boardMode));
                rowParams.addParam(param);
            }
            if (!operList.isEmpty()) {
                OperationResult result = TENECommMgr.getInstance().sendCommand(neid, operList, 20);
                if (result.retCode == 0) {
                    if (boardType == 2272 || boardType == 3005) {
                        this.handlePortMessageForLEM18(operList, rowParamses);
                    }
                    if (boardType == 2109) {
                        this.handlePortMessageForLEM24(operList, rowParamses);
                    }
                    if (boardType == 2292) {
                        this.handlePortMessageForTEM28(operList, rowParamses);
                    }
                }
            }
        }
    }

    private ArrayList createLEM18OperationList(int neid, String slotId, String portId) {
        ArrayList<Object> operList = new ArrayList<Object>();
        if (Integer.parseInt(portId) > 4 && Integer.parseInt(portId) < 32768) {
            Operation operation = null;
            Input input = null;
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PORT");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("portID", portId);
            operList.add(operation.clone());
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PAYLOADTYPE");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("port", portId);
            input.setPartValue("path", "1");
            operList.add(operation.clone());
        }
        return operList;
    }

    private ArrayList createTEM28OperationList(int neid, String slotId, String portId) {
        ArrayList<Object> operList = new ArrayList<Object>();
        if (Integer.parseInt(portId) >= 7 && Integer.parseInt(portId) <= 30) {
            Operation operation = null;
            Input input = null;
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PORT");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("portID", portId);
            operList.add(operation.clone());
        }
        return operList;
    }

    private ArrayList createLEM24OperationList(int neid, String slotId, String portId) {
        ArrayList<Object> operList = new ArrayList<Object>();
        if (Integer.parseInt(portId) >= 7 && Integer.parseInt(portId) <= 28) {
            Operation operation = null;
            Input input = null;
            operation = TECreateObjectFactory.getOperation((int)neid, (String)"NSCMD_CFG_GET_PORT");
            input = operation.getInput();
            input.setPartValue("slotid", slotId);
            input.setPartValue("portID", portId);
            operList.add(operation.clone());
        }
        return operList;
    }

    private void handlePortMessageForLEM18(ArrayList operList, RowParams[] rowParamses) {
        int NSCMD_CFG_GET_PORT = 28771;
        int NSCMD_CFG_GET_PAYLOADTYPE = 34827;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : rowParamses) {
            if (rowParams2.getParam("port") == null) continue;
            String portid = rowParams2.getParam("port").getValue();
            int size = operList.size();
            for (int j = 0; j < size; ++j) {
                String temp;
                Operation operation = (Operation)operList.get(j);
                if (operation.getCmdid() == 28771) {
                    if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("portID"))) continue;
                    temp = operation.getOutput(0).getPartValue("portType");
                    rowParams2.getParam("portModel").setValue(temp);
                    continue;
                }
                if (operation.getCmdid() != 34827) continue;
                if (portid.equals("3") || portid.equals("4")) {
                    rowParams2.getParam("portSpeedLevel").setValue("258");
                    continue;
                }
                if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("port"))) continue;
                temp = operation.getOutput(0).getPartValue("W32PORT_ATTR_ST_SERVICETYPE");
                rowParams2.getParam("portSpeedLevel").setValue(temp);
            }
        }
    }

    private void handlePortMessageForLEM24(ArrayList operList, RowParams[] rowParamses) {
        int NSCMD_CFG_GET_PORT = 28771;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : rowParamses) {
            if (rowParams2.getParam("port") == null) continue;
            String portid = rowParams2.getParam("port").getValue();
            int size = operList.size();
            for (int j = 0; j < size; ++j) {
                Operation operation = (Operation)operList.get(j);
                if (operation.getCmdid() != 28771) continue;
                if (portid.equals("5") || portid.equals("6")) {
                    rowParams2.getParam("portSpeedLevel").setValue("258");
                }
                if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("portID"))) continue;
                String temp = operation.getOutput(0).getPartValue("portType");
                rowParams2.getParam("portModel").setValue(temp);
                temp = operation.getOutput(0).getPartValue("speedLevel");
                rowParams2.getParam("portSpeedLevel").setValue(temp);
            }
        }
    }

    private void handlePortMessageForTEM28(ArrayList operList, RowParams[] rowParamses) {
        int NSCMD_CFG_GET_PORT = 28771;
        RowParams rowParams2 = null;
        for (RowParams rowParams2 : rowParamses) {
            if (rowParams2.getParam("port") == null) continue;
            String portid = rowParams2.getParam("port").getValue();
            int size = operList.size();
            for (int j = 0; j < size; ++j) {
                Operation operation = (Operation)operList.get(j);
                if (operation.getCmdid() != 28771) continue;
                if (portid.equals("3") || portid.equals("4") || portid.equals("5") || portid.equals("6")) {
                    rowParams2.getParam("portSpeedLevel").setValue("258");
                }
                if (portid.equals("0") || !portid.equals(operation.getOutput(0).getPartValue("portID"))) continue;
                String temp = operation.getOutput(0).getPartValue("portType");
                rowParams2.getParam("portModel").setValue(temp);
                temp = operation.getOutput(0).getPartValue("speedLevel");
                rowParams2.getParam("portSpeedLevel").setValue(temp);
            }
        }
    }

    private void removeSpilthALMTHR(Operation operation, String direction) {
        Output output = null;
        for (int i = 0; i < operation.getOutputCount(); ++i) {
            output = operation.getOutput(i);
            if (!output.getFault(0).getCode().equals("0") || output.getPartValue("direct").equals(direction)) continue;
            operation.removeOutput(i);
            --i;
        }
    }

    public ArrayList getQueryOperationList(TEGenCfgFunCmd funCmd, Datainterface inputData) {
        ArrayList operList = super.getQueryOperationList(funCmd, inputData);
        TEConfigurationDataMgr cfgMgr = TEConfigurationDataMgr.getInstance();
        int neType = cfgMgr.getNE(this.neid).getNEType();
        int slotId = Integer.valueOf(inputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue());
        int boardType = cfgMgr.getBoardType(this.neid, slotId);
        int subrackType = TEGetNEDomainVersion.getInstance().getDevType(TEBoardUtil.getSubrackType((int)this.neid, (int)neType, (int)slotId));
        Part part = null;
        Operation oper = null;
        for (int i = operList.size() - 1; i >= 0; --i) {
            TEPortParaRecord record;
            oper = (Operation)operList.get(i);
            part = oper.getInput().getPart("port");
            if (null == part || null == (record = TECircuitPackDescription.getInstance().getCPPortPara(boardType, Integer.valueOf(part.getValue()).intValue())) || null == record.boardModeList || record.boardModeList.contains(subrackType)) continue;
            operList.remove(i);
        }
        return operList;
    }
}

