/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgAttribute;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgDataMgr;
import com.huawei.nglct.nelist.model.gencfg.TEGenCfgModel;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInterfaceQueryBean;
import java.util.ArrayList;
import org.slf4j.Logger;

public final class TEQueryAllEthInfAttr {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEQueryAllEthInfAttr() {
    }

    public static int queryEthInfFromNE(int neID, int slotID) {
        e2eLogger.info("get eth inf from ne begin.");
        int errCode = -1;
        TEEthInterfaceQueryBean queryEthInfBean = new TEEthInterfaceQueryBean();
        int cmdID = 0x202020;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            String tipStr = "queryEthInfFromNE: Get SubFunc fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            e2eLogger.info("get eth inf from ne end.");
            return 1090646019;
        }
        Datainterface inputData = TEQueryAllEthInfAttr.createQueryEthInfInput(neID, slotID);
        Datainterface outputData = null;
        try {
            outputData = queryEthInfBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            String tipStr = "queryEthInfBean run fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr, (Throwable)e);
            e2eLogger.info("get eth inf from ne end.");
            return 1090646019;
        }
        if (null == outputData) {
            String tipStr = "queryEthInfBean run fail! outputData is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            e2eLogger.info("get eth inf from ne end.");
            return 1090646019;
        }
        errCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errCode) {
            String tipStr = "get eth inf from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            return errCode;
        }
        e2eLogger.info("get eth inf from ne end.");
        return errCode;
    }

    private static Datainterface createQueryEthInfInput(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        TEBoard board = ne.getBoard(slotID);
        int boardType = board.getBoardType();
        int neType = ne.getNEType();
        String neVersion = ne.getHostVersion();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("srcObjType", "ID_OBJECT_TYPE_NE_BOARD");
        rowparams.addParam(param);
        TEGenCfgModel genCfgModel = TEGenCfgDataMgr.getGenCfgMode((int)boardType);
        if (null != genCfgModel) {
            ArrayList attrList = null;
            attrList = genCfgModel.getSupportAttrList(neType, neVersion);
            for (TEGenCfgAttribute attr : attrList) {
                param = new Param("attrId", String.valueOf(attr.getAttrId()));
                rowparams.addParam(param);
            }
        }
        return inputData;
    }
}

