/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethinterface;

import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.db.TECommonDaoService;
import com.huawei.nglct.db.TEDaoOperationResult;
import com.huawei.nglct.db.jni.dbservice.TEGeneralKeyValue;
import com.huawei.nglct.db.jni.dbservice.TEGeneralValue;
import com.huawei.nglct.db.jni.dbservice.TEGnlValueElement;
import com.huawei.nglct.gencfg.TEGenCfgFunAttr;
import com.huawei.nglct.gencfg.TEGenCfgFunCmd;
import com.huawei.nglct.gencfg.frame.TEGnlAttrMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.TEEthInfStaticData;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEObjTypeIDCreator;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.objtypeid.TEPartSource;
import com.huawei.nglct.nemgr.ip.ngwdm.ethinterface.specialprocess.TEAttrHandler;
import com.huawei.uflight.qxprotocol.definitions.Fault;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Output;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class TEEthInfUtil {
    public static final int TE_ERR_WNEMGR_GET_FROM_DB_FAIL = 1090615127;
    public static final String DEFAULT_SUB_CARD_ID = "255";
    public static final String DEFAULT_PATH_ID = "1";
    public static final String VALUE_INVALID_STR = "/";
    public static final int NE_INVALID_WAVELEN = 255;
    public static final int NE_INVALID_WAVETYPE = 255;
    public static final int CNEMGR_INVALID_WAVELEN = 65536;

    private TEEthInfUtil() {
    }

    public static void getOperFromDB(Map<TEGeneralKeyValue, Operation> keyOperMap) {
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = null;
        TEGeneralKeyValue key2 = null;
        Set<TEGeneralKeyValue> keySet = keyOperMap.keySet();
        for (TEGeneralKeyValue key2 : keySet) {
            element = new TEGnlValueElement();
            element.setGnlKeyValue(key2);
            elementList.add(element);
        }
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->\n");
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        int retCode = result.getResult();
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        Fault fault = null;
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            Operation oper = null;
            int errCode = -1;
            int attrID = -1;
            for (TEGnlValueElement ele2 : data) {
                key2 = ele2.getGnlKeyValue();
                oper = keyOperMap.get(key2);
                Output output = oper.getOutput(0);
                TEEthInfUtil.fillObjIDPartValue(ele2, output);
                TEEthInfUtil.fillAttrPartValue(ele2, attrID, output);
                errCode = ele2.getGnlValue().getErrCode();
                fault = oper.getOutput(0).getFault(0);
                fault.setCode(String.valueOf(errCode));
                keyOperMap.remove(key2);
            }
            TEEthInfUtil.handleFailedOper(keyOperMap, 1090615127);
        } else {
            TEEthInfUtil.handleFailedOper(keyOperMap, retCode);
        }
    }

    public static String getAttrValueFromDB_NoLock(TEGeneralKeyValue key) {
        String attrValue = null;
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>();
        TEGnlValueElement element = new TEGnlValueElement();
        element.setGnlKeyValue(key);
        elementList.add(element);
        StringBuffer buffer = new StringBuffer(0);
        buffer.append("find gnl value. req->\n");
        for (TEGnlValueElement ele : elementList) {
            buffer.append(ele.toString()).append('\n');
        }
        TELogFactory.getNormalLogger().info("find gnl value. req->" + buffer.toString());
        TEDaoOperationResult result = TECommonDaoService.findGnlValue_NoLock(elementList);
        TELogFactory.getNormalLogger().info("find gnl value. rsp->" + result.getResult());
        List data = result.getData();
        TELogFactory.getNormalLogger().info("find gnl value. data.size->" + data.size());
        TELogFactory.getNormalLogger().info("find gnl value. result->" + result.toString());
        if (!data.isEmpty()) {
            TEGnlValueElement ele2 = null;
            for (TEGnlValueElement ele2 : data) {
                int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(key.getAttrID());
                if (0 == valueType) {
                    attrValue = String.valueOf(ele2.getGnlValue().getiValue());
                    continue;
                }
                attrValue = ele2.getGnlValue().getsValue();
            }
        }
        return attrValue;
    }

    private static void handleFailedOper(Map<TEGeneralKeyValue, Operation> keyOperMap, int errorCode) {
        Collection<Operation> operList = keyOperMap.values();
        for (Operation oper : operList) {
            Fault fault = oper.getOutput(0).getFault(0);
            fault.setCode(String.valueOf(errorCode));
        }
    }

    private static String getAttrValue(TEGnlValueElement ele, int attrID) {
        int valueType = TEGnlAttrMgr.getInstance().getAttrValueType(attrID);
        String attrValue = null;
        int iValue = -1;
        String sValue = null;
        if (0 == valueType) {
            iValue = ele.getGnlValue().getiValue();
            attrValue = String.valueOf(iValue);
        } else {
            attrValue = sValue = ele.getGnlValue().getsValue();
        }
        return attrValue;
    }

    private static void fillAttrPartValue(TEGnlValueElement ele, int attrID, Output output) {
        int attrID2 = ele.getGnlKeyValue().getAttrID();
        String attrValue = TEEthInfUtil.getAttrValue(ele, attrID2);
        Set attrNameSet = (Set)TEEthInfStaticData.getAttrIDNameMap().get(attrID2);
        if (null != attrNameSet) {
            String attrName2 = null;
            Part part = null;
            for (String attrName2 : attrNameSet) {
                part = output.getPart(attrName2);
                if (null == part) continue;
                TEAttrHandler.getInstance().setAttrPartValue(ele, attrValue, attrName2, output, part);
            }
        }
    }

    private static void fillObjIDPartValue(TEGnlValueElement ele, Output output) {
        int[] objID = ele.getGnlKeyValue().getTEOBJECTID();
        Part part = output.getPart("neid");
        if (null != part && objID.length >= 2) {
            part.setValue(String.valueOf(objID[1]));
        }
        if (null != (part = output.getPart("subCardId"))) {
            part.setValue(DEFAULT_SUB_CARD_ID);
        }
        if (null != (part = output.getPart("slotid")) && objID.length >= 3) {
            int slotID = objID[2];
            part.setValue(String.valueOf(slotID));
        }
        if (null != (part = output.getPart("port")) && objID.length >= 4) {
            int portID = objID[3];
            portID = TEConfigurationDataMgr.getPortRelativeID((int)portID);
            part.setValue(String.valueOf(portID));
        }
        if (null != (part = output.getPart("path"))) {
            if (objID.length >= 5) {
                part.setValue(String.valueOf(objID[4]));
            } else {
                part.setValue(DEFAULT_PATH_ID);
            }
        }
    }

    public static Map<TEGeneralKeyValue, Operation> getKeyOperMap(int neid, TEGenCfgFunCmd funCmd, String attrName, Operation oper) {
        HashMap<TEGeneralKeyValue, Operation> keyOperMap = new HashMap<TEGeneralKeyValue, Operation>();
        String objTypeStr = TEEthInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEEthInfUtil.constructGnlKey(neid, attrName, objTypeStr, new TEPartSource(oper.getInput()));
        keyOperMap.put(key, oper);
        return keyOperMap;
    }

    public static String getObjTypeByAttr(TEGenCfgFunCmd funCmd, String attrName) {
        String objTypeStr = TEEthInfStaticData.getAttrNameObjTypeNameMap().get(attrName);
        if (null == objTypeStr) {
            TEGenCfgFunAttr funAttr = funCmd.getGenCfgFunAttr(attrName, "query");
            objTypeStr = funAttr.getObjectType();
        }
        return objTypeStr;
    }

    public static int getAttrID(String attrName) {
        Integer attrID = TEEthInfStaticData.getAttrNameIDMap().get(attrName);
        if (null != attrID) {
            return attrID;
        }
        TELogFactory.getNormalLogger().error("get objtype error->" + attrName);
        return -1;
    }

    public static boolean isOutputContainNMQueryAttr(Operation oper) {
        Output output = null;
        Part nmAttrPart = null;
        Iterator<String> iter = null;
        String attrName2 = null;
        int len = oper.getOutputCount();
        for (int i = 0; i < len; ++i) {
            output = oper.getOutput(i);
            for (String attrName2 : TEEthInfStaticData.getKeySets()) {
                nmAttrPart = output.getPart(attrName2);
                if (null == nmAttrPart) continue;
                return true;
            }
        }
        return false;
    }

    protected static boolean isInputContainNMQueryAttr(Operation oper) {
        Input input = null;
        Part nmAttrPart = null;
        Iterator<String> iter = null;
        String attrName2 = null;
        input = oper.getInput();
        for (String attrName2 : TEEthInfStaticData.getKeySets()) {
            nmAttrPart = input.getPart(attrName2);
            if (null == nmAttrPart) continue;
            return true;
        }
        return false;
    }

    public static int saveAttrInfoToDB(Map<TEGnlValueElement, Operation> keyOperMap) {
        Set<TEGnlValueElement> elementSet = keyOperMap.keySet();
        ArrayList<TEGnlValueElement> elementList = new ArrayList<TEGnlValueElement>(elementSet);
        TEDaoOperationResult result = TEEthInfUtil.saveAttrInfoToDB(elementList);
        int retCode = result.getResult();
        if (0 != retCode) {
            Operation oper2 = null;
            Fault fault = null;
            Collection<Operation> operList = keyOperMap.values();
            for (Operation oper2 : operList) {
                fault = new Fault();
                fault.setCode(String.valueOf(retCode));
                oper2.getOutput(0).addFault(fault);
            }
        }
        return retCode;
    }

    public static TEDaoOperationResult saveAttrInfoToDB(List<TEGnlValueElement> elementList) {
        TEDaoOperationResult result = null;
        if (null != elementList && 0 != elementList.size()) {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append("save attr to database.\n");
            for (TEGnlValueElement element : elementList) {
                buffer.append(element.toString()).append('\n');
            }
            TELogFactory.getNormalLogger().info(buffer.toString());
            result = TECommonDaoService.saveGnlValueToDB(elementList);
        } else {
            result = new TEDaoOperationResult();
            result.setResult(0);
        }
        TELogFactory.getNormalLogger().info("save gnl value. result->" + result.getResult());
        return result;
    }

    public static TEGnlValueElement constructElement(int neid, TEGenCfgFunCmd funCmd, TEPartSource partSource, String attrName, String valueStr) {
        TEGnlValueElement element = new TEGnlValueElement();
        String objTypeStr = TEEthInfUtil.getObjTypeByAttr(funCmd, attrName);
        TEGeneralKeyValue key = TEEthInfUtil.constructGnlKey(neid, attrName, objTypeStr, partSource);
        element.setGnlKeyValue(key);
        TEGeneralValue value = TEEthInfUtil.constructGnlValue(partSource, attrName);
        element.setGnlValue(value);
        return element;
    }

    public static TEGeneralKeyValue constructGnlKey(int neid, String attrName, String objTypeStr, TEPartSource partSource) {
        TEGeneralKeyValue key = new TEGeneralKeyValue();
        key.setAttrID(TEEthInfUtil.getAttrID(attrName));
        int objTpID = TEObjTypeIDCreator.getObjTypeID(attrName, objTypeStr, partSource);
        int[] objTypeID = TEObjTypeIDCreator.getInstance().createObjectID(neid, objTpID, partSource);
        key.setTEOBJECTID(objTypeID);
        return key;
    }

    private static TEGeneralValue constructGnlValue(TEPartSource partSource, String attrName) {
        TEGeneralValue value = new TEGeneralValue();
        TEAttrHandler.getInstance().setElementValue(partSource, attrName, value);
        return value;
    }
}

