/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethertest_v2r6c01;

import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.QxMapping;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.sysmanager.TESysManagerBean;
import com.huawei.nglct.util.io.TEGetFilePath;
import com.huawei.nglct.util.io.TEPathManager;
import com.huawei.nglct.util.string.TEResourceUtil;
import java.io.File;

public class TESetEtherTest
extends TENEExplorerBean {
    private static final String BOARD_L4G = "927";
    private static final String BOARD_N3EAS2 = "2217";

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        this.neid = neid;
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        QxMapping qxMapping = new QxMapping();
        subFunc.clearQxMapping();
        if (this.isIPBoard(boardTypeParam.getValue())) {
            qxMapping.setContent("NSCMD_ETHN_SET_TESTEN");
            subFunc.addQxMapping(qxMapping);
        } else {
            qxMapping.setContent("NSCMD_CFG_SET_GFPATTRIBUTE");
            subFunc.addQxMapping(qxMapping);
            qxMapping = new QxMapping();
            qxMapping.setContent("NSCMD_CFG_SET_GFPRESPONSE");
            subFunc.addQxMapping(qxMapping);
        }
        return super.performBussinessProcess(neid, subFunc, inputData, memeryData, user, ipAddress);
    }

    private boolean isIPBoard(String value) {
        if (BOARD_L4G.equals(value) || value.equals("1557")) {
            return true;
        }
        if (BOARD_N3EAS2.equals(value)) {
            return true;
        }
        return TESpecialAttrMgr.getInstance().isCPSupportByType(Integer.valueOf(value).intValue(), "TE_FUNC_CFG_ETHTEST", "ETHTEST_ETHBOARD_SUPPORT_SPECIAL");
    }

    public String getDetailStr(RowParams rowparams) {
        StringBuffer filePath = new StringBuffer(17);
        filePath.append("ip").append(File.separator).append("ngwdm").append(File.separator).append(TEPathManager.RESOURCE_PROFILE_PATH).append("ethtest").append(File.separator).append("ethernettest_").append(TESysManagerBean.getInstance().getlanguage()).append(".ini");
        TEResourceUtil res = TEGetFilePath.getResource((int)this.neid, (StringBuffer)filePath);
        TENE neObj = TENEListMgr.getInstance().getNE(this.neid);
        String operObj = this.getOperObjStr(neObj, rowparams);
        String detailDes = "";
        String paramName = "";
        String paramValue = "";
        int size = rowparams.getParamCount();
        for (int j = 0; j < size; ++j) {
            paramName = rowparams.getParam(j).getName();
            paramValue = rowparams.getParam(j).getValue();
            if ("sendMode".equals(paramName) || "sendDirection".equals(paramName)) {
                detailDes = detailDes + res.getString(paramName) + ":" + res.getString(paramName + "_" + paramValue) + ",";
                continue;
            }
            if (!"testFrameNum".equals(paramName)) continue;
            detailDes = detailDes + res.getString(paramName) + ":" + paramValue;
        }
        operObj = operObj + ":" + detailDes;
        return operObj;
    }

    private String getOperObjStr(TENE neObj, RowParams rowparams) {
        String operationObj = "";
        TEConfigurationDataMgr configurDataMgr = TEConfigurationDataMgr.getInstance();
        String slotid = rowparams.getParam("slotid").getValue();
        String port = rowparams.getParam("portid").getValue();
        int boardType = configurDataMgr.getBoard(this.neid, Integer.parseInt(slotid)).getBoardType();
        String boardName = configurDataMgr.getBoardTypeName(this.neid, boardType);
        if (this.isIPBoard("" + boardType)) {
            operationObj = operationObj + slotid + "-" + boardName + "-" + this.getVctrunk(port);
        } else {
            String portName = TEConfigurationDataMgr.getInstance().getPortName(this.neid, Integer.parseInt(slotid), boardType, Integer.parseInt(port));
            String pathid = rowparams.getParam("pathid").getValue();
            operationObj = operationObj + slotid + "-" + boardName + "-" + portName + "-" + pathid;
        }
        return operationObj;
    }

    private String getVctrunk(String port) {
        int portNO = Integer.parseInt(port);
        return "VCTRUNK" + (portNO - 32768);
    }
}

