/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethertest_v2r6c01;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nelist.model.configmodel.TESpecialAttrMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethertest_v2r6c01.TEEtherTestReport;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryEtherTest
extends TECommonWriteLogBean {
    private static final String NSCMD_ETHN_GET_TESTEN = "NSCMD_ETHN_GET_TESTEN";
    private static final String NSCMD_ETHN_GET_TESTCOUNT = "NSCMD_ETHN_GET_TESTCOUNT";
    private static final int VCTRUNK = 32768;
    private static final String INVAILEDNUM = "65535";
    private static final String CFGGETISNULL = "38662";
    private static final String PALOADOVER = "39555";
    private static final String BOARD_L4G = "927";
    private String boardType = "";
    int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            Param reportParam;
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
            Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
            this.boardType = boardTypeParam.getValue();
            this.slotID = Integer.parseInt(slotidParam.getValue());
            TEEtherTestReport ethTestReport = TEEtherTestReport.getInstance();
            if (!ethTestReport.hasRegisterd()) {
                ethTestReport.register(neid);
            }
            if (null != (reportParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"report")) && "true".equals(reportParam.getValue())) {
                List<RowParams> list = TEEtherTestReport.getInstance().getReportData(neid, this.slotID);
                return this.reportData(list);
            }
            this.outputData = new Datainterface();
            this.operationList = this.isIPBoard(boardTypeParam.getValue()) ? this.convertToOperation(subFunc, inputData) : this.getOperation(neid, subFunc, inputData, memeryData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private boolean isIPBoard(String value) {
        return value.equals(BOARD_L4G) || value.equals("1557") || value.equals("2217") || TESpecialAttrMgr.getInstance().isCPSupportByType(Integer.valueOf(value).intValue(), "TE_FUNC_CFG_ETHTEST", "ETHTEST_ETHBOARD_SUPPORT_SPECIAL");
    }

    private Datainterface reportData(List<RowParams> reportList) {
        Param needReport = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"needReport");
        String[] needReportArray = needReport.getValue().split(",");
        String report = "";
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        RowParams rowParams = null;
        if (reportList != null) {
            for (int len = reportList.size() - 1; len >= 0; --len) {
                rowParams = reportList.get(len);
                report = BOARD_L4G.equals(this.boardType) || "1557".equals(this.boardType) || "2217".equals(this.boardType) ? rowParams.getParam("portid").getValue() : rowParams.getParam("portid").getValue() + "-" + rowParams.getParam("pathid").getValue();
                RowParams rowparams = (RowParams)reportList.get(len).clone();
                int portlen = needReportArray.length;
                for (int i = 0; i < portlen; ++i) {
                    if (!report.equals(needReportArray[i])) continue;
                    bussinessParams.addRowParams(rowparams);
                }
            }
        }
        return returnReportData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        ArrayList supportVCTRUNKPort;
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        Param needReport = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"needReport");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        if (needReport.getValue().isEmpty()) {
            supportVCTRUNKPort = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neid, Integer.valueOf(slotidParam.getValue()).intValue(), boardType);
        } else {
            String[] needReportArray;
            supportVCTRUNKPort = new ArrayList();
            for (String temp : needReportArray = needReport.getValue().split(",")) {
                supportVCTRUNKPort.add(temp);
            }
        }
        Operation oper1 = null;
        Input input = null;
        Part part = null;
        int len = supportVCTRUNKPort.size();
        for (int i = 0; i < len; ++i) {
            oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_TESTEN);
            input = oper1.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper1);
            oper1 = TECreateObjectFactory.getOperation((int)this.neid, (String)NSCMD_ETHN_GET_TESTCOUNT);
            input = oper1.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper1);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        String portid = null;
        String slotid = "";
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowParams.getParamCount()) continue;
            portid = rowParams.getParam("portid").getValue();
            if (!this.isIPBoard(this.boardType)) {
                slotid = this.outputData.getBussinessParams().getRowParams(0).getParam("slotid").getValue();
                portid = TEConfigurationDataMgr.getInstance().getPortName(neid, Integer.parseInt(slotid), Integer.parseInt(this.boardType), Integer.parseInt(portid));
            } else {
                portid = portid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(portid) > 32768 ? "VCTRUNK" + (Integer.parseInt(portid) - 32768) : "PORT" + portid);
            }
            rowParams.getParam("portid").setValue(portid);
        }
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        String detailDes = "";
        if (rParamsArr.length > 0 && null != rParamsArr[0].getParam("slotid")) {
            int slotid = Integer.parseInt(rParamsArr[0].getParam("slotid").getValue());
            detailDes = TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotid);
        }
        return detailDes;
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(CFGGETISNULL));
        codeList.add(Integer.valueOf(PALOADOVER));
        return codeList;
    }

    protected boolean isSingletonLog() {
        return true;
    }
}

