/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethertest;

import com.huawei.nglct.cbb.log.TECommonWriteLogBean;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TECreateObjectFactory;
import com.huawei.nglct.common.TEDataConverter;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.nelist.model.TEConfigurationDataMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethertest.TEEtherTestReport;
import com.huawei.nglct.util.device.board.TEBoardUtil;
import com.huawei.nglct.util.string.TEErrorResourceUtil;
import com.huawei.uflight.qxprotocol.definitions.Input;
import com.huawei.uflight.qxprotocol.definitions.Operation;
import com.huawei.uflight.qxprotocol.definitions.Part;
import java.util.ArrayList;
import java.util.List;

public class TEQueryEtherTest
extends TECommonWriteLogBean {
    private static final int NSCMD_ETHN_GET_TESTEN = 29104;
    private static final int NSCMD_ETHN_GET_TESTCOUNT = 29105;
    private static final int VCTRUNK = 32768;
    private static final String INVAILEDNUM = "65535";
    private static final String CFGGETISNULL = "38662";
    int slotID = -1;

    public Datainterface performBussinessProcess(int neid, SubFunc subFunc, Datainterface inputData, Datainterface memeryData, String user, String ipAddress) {
        try {
            this.neid = neid;
            this.subfunc = subFunc;
            this.inputData = inputData;
            Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
            this.slotID = Integer.parseInt(slotidParam.getValue());
            TEEtherTestReport ethTestReport = TEEtherTestReport.getInstance();
            Param reportParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"report");
            if (null != reportParam && "true".equals(reportParam.getValue())) {
                List<RowParams> list = TEEtherTestReport.getInstance().getReportData(neid, this.slotID);
                return this.reportData(list);
            }
            this.outputData = new Datainterface();
            this.operationList = this.convertToOperation(subFunc, inputData);
            int result = this.sendMessage(neid);
            if (result == 0) {
                if (!ethTestReport.hasRegisterd()) {
                    ethTestReport.register(neid);
                }
                ArrayList filterErrorCodeList = this.getFilterErrorCodeList();
                this.handleMessage(neid, this.operationList, subFunc, filterErrorCodeList);
            } else {
                this.outputData.setErrorMessage(TEErrorResourceUtil.getErrorMessage((int)result));
            }
            if (this.isNeedOperationlog()) {
                this.writeLog(neid, this.subfunc, inputData, user, ipAddress, this.outputData);
            }
        }
        catch (Exception e) {
            TELogFactory.getNormalLogger().error("performBussinessProcess fail!", (Throwable)e);
            return null;
        }
        return this.outputData;
    }

    private Datainterface reportData(List<RowParams> reportList) {
        Param portParam = Datainterface.getParam((Param[])this.inputData.getBussinessParams().getRowParams(0).getParam(), (String)"needReport");
        String ports = portParam.getValue();
        String[] portArray = ports.split(",");
        String tempPort = "";
        Datainterface returnReportData = new Datainterface();
        BussinessParams bussinessParams = new BussinessParams();
        returnReportData.setBussinessParams(bussinessParams);
        if (reportList != null) {
            for (int len = reportList.size() - 1; len >= 0; --len) {
                tempPort = reportList.get(len).getParam("portid").getValue();
                RowParams rowparams = (RowParams)reportList.get(len).clone();
                int portlen = portArray.length;
                for (int i = 0; i < portlen; ++i) {
                    if (!tempPort.equals(portArray[i])) continue;
                    bussinessParams.addRowParams(rowparams);
                }
            }
        }
        return returnReportData;
    }

    private ArrayList convertToOperation(SubFunc subFunc, Datainterface inputData) {
        ArrayList<Operation> operationList = new ArrayList<Operation>();
        Param boardTypeParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"boardType");
        Param slotidParam = Datainterface.getParam((Param[])inputData.getBussinessParams().getRowParams(0).getParam(), (String)"slotid");
        int boardType = Integer.parseInt(boardTypeParam.getValue());
        ArrayList supportVCTRUNKPort = TEConfigurationDataMgr.getInstance().getETHVCTrunkPort(this.neid, Integer.valueOf(slotidParam.getValue()).intValue(), boardType);
        Operation oper = null;
        Input input = null;
        Part part = null;
        int len = supportVCTRUNKPort.size();
        for (int i = 0; i < len; ++i) {
            oper = TECreateObjectFactory.getOperation((int)this.neid, (int)29104);
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
            oper = TECreateObjectFactory.getOperation((int)this.neid, (int)29105);
            input = oper.getInput();
            part = input.getPart("slotid");
            part.setValue(slotidParam.getValue());
            part = input.getPart("portid");
            part.setValue("" + supportVCTRUNKPort.get(i));
            operationList.add(oper);
        }
        return operationList;
    }

    public void handleMessage(int neid, ArrayList operationList, SubFunc subfunc, ArrayList filterErrorCodeList) {
        this.outputData = TEDataConverter.convertToDatainterface((int)neid, (SubFunc)subfunc, (ArrayList)operationList, (ArrayList)filterErrorCodeList);
        if (null == this.outputData) {
            return;
        }
        RowParams rowParams = null;
        String portid = null;
        for (int i = this.outputData.getBussinessParams().getRowParamsCount() - 1; i >= 0; --i) {
            rowParams = this.outputData.getBussinessParams().getRowParams(i);
            if (0 == rowParams.getParamCount()) continue;
            portid = rowParams.getParam("portid").getValue();
            portid = portid.equals(INVAILEDNUM) ? "" : (Integer.parseInt(portid) > 32768 ? "VCTRUNK" + (Integer.parseInt(portid) - 32768) : "PORT" + portid);
            rowParams.getParam("portid").setValue(portid);
        }
    }

    public ArrayList getFilterErrorCodeList() {
        ArrayList<Integer> codeList = new ArrayList<Integer>();
        codeList.add(Integer.valueOf(CFGGETISNULL));
        return codeList;
    }

    protected boolean isSingletonLog() {
        return true;
    }

    public String getDetailInfo(RowParams[] rParamsArr) {
        String detailDes = "";
        if (rParamsArr.length > 0 && null != rParamsArr[0].getParam("slotid")) {
            int slotid = Integer.parseInt(rParamsArr[0].getParam("slotid").getValue());
            detailDes = TEBoardUtil.getShelfBoardName((int)this.neid, (int)slotid);
        }
        return detailDes;
    }
}

