/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipbase.QAsnAttrValueList;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateVLanRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanAttr;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanCreateInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPort;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPortList;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndexList;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.explorer.TENEExplorerBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c02.TEQueryVLANBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherVBLinkMOPO;
import com.huawei.nglct.util.string.TEConvertUtil;
import gnu.trove.TIntArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;

public final class TEE2EVlanUtil {
    public static final int INVALID_SUB_SLOT_ID = 255;
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    private TEE2EVlanUtil() {
    }

    public static Set<TECFVlanEntryMOPO> getVlanFibDB(int neID, int slotID, int vbid) {
        e2eLogger.info("getVlanFibDB without vlanid begin.");
        HashSet<TECFVlanEntryMOPO> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbid);
        if (null == etherBridgeMo) {
            String tipStr = "getVlanFibDB: get vb mo from db fail!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbid:%d]", neID, slotID, vbid);
            e2eLogger.error(tipStr);
            e2eLogger.info("getVlanFibDB without vlanid end. not found.");
            return vlanMOSet;
        }
        vlanMOSet.addAll(etherBridgeMo.getVlanFibDB());
        e2eLogger.info("getVlanFibDB without vlanid end. found.");
        return vlanMOSet;
    }

    public static TECFVlanEntryMOPO getVlanFibDB(int neID, int slotID, int vbid, int vlanid) {
        e2eLogger.info("getVlanFibDB with vlanid begin.");
        TECFVlanEntryMOPO objVlanMO = null;
        Set<TECFVlanEntryMOPO> vlanMOSet = TEE2EVlanUtil.getVlanFibDB(neID, slotID, vbid);
        for (TECFVlanEntryMOPO vlanMO : vlanMOSet) {
            if (vlanMO.getVlanID() != vlanid) continue;
            objVlanMO = vlanMO;
            e2eLogger.info("getVlanFibDB with vlanid end. found.");
            return objVlanMO;
        }
        String tipStr = "getVlanFibDB: get vlan mo from db fail!";
        tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbid:%d, vlanid:%d]", neID, slotID, vbid, vlanid);
        e2eLogger.error(tipStr);
        e2eLogger.info("getVlanFibDB with vlanid end. not found.");
        return objVlanMO;
    }

    public static Set<TECFVlanEntryMOPO> getVlanFibDB(int neID, int slotID, int vbid, List<Integer> vlanIDList) {
        e2eLogger.info("getVlanFibDB with vlanid begin.");
        HashSet<TECFVlanEntryMOPO> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        if (vlanIDList.isEmpty()) {
            e2eLogger.info("getVlanFibDB with vlanid end. the vlanIdList is empty.");
            return vlanMOSet;
        }
        Set<TECFVlanEntryMOPO> dbVlanMOSet = TEE2EVlanUtil.getVlanFibDB(neID, slotID, vbid);
        for (TECFVlanEntryMOPO vlanMO : dbVlanMOSet) {
            if (!vlanIDList.contains(vlanMO.getVlanID())) continue;
            vlanMOSet.add(vlanMO);
        }
        if (vlanMOSet.isEmpty()) {
            e2eLogger.info("getVlanFibDB. the result vlanMOList is empty.");
        }
        e2eLogger.info("getVlanFibDB with vlanid end.");
        return vlanMOSet;
    }

    public static QAsnVLanInfoList mo2Asn(int neID, int slotID, int vbID, Collection<TECFVlanEntryMOPO> vlanMOSet) {
        QAsnVLanInfoList vlanInfoList = new QAsnVLanInfoList();
        HashMap<Integer, Integer> vblpEthPortMap = new HashMap<Integer, Integer>();
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        Set vbLinkMOSet = etherBridgeMo.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO : vbLinkMOSet) {
            vblpEthPortMap.put(vbLinkMO.getVBPortID(), vbLinkMO.getPhyPortID());
        }
        for (TECFVlanEntryMOPO vlanMOPO : vlanMOSet) {
            QAsnVLanInfo vlanInfo = new QAsnVLanInfo();
            QAsnVLanIndex rspIndex = new QAsnVLanIndex();
            QAsnVLanAttr vlanAttr = new QAsnVLanAttr();
            rspIndex.neID = neID;
            rspIndex.slotID = slotID;
            rspIndex.subSlotID = 255;
            rspIndex.vbID = vbID;
            rspIndex.vlanID = vlanMOPO.getVlanID();
            vlanAttr.vlanLabel = vlanMOPO.getVlanLabel().getBytes();
            vlanAttr.vlanName = "".getBytes();
            vlanAttr.vlanOwner = vlanMOPO.getVlanOwner().getBytes();
            vlanAttr.portList = TEE2EVlanUtil.getAsnForwardPortList(vlanMOPO, vblpEthPortMap);
            vlanAttr.isActive = vlanMOPO.getActiveState();
            vlanInfo.vlanIndex = rspIndex;
            vlanInfo.vlanAttr = vlanAttr;
            vlanInfoList.add((Object)vlanInfo);
        }
        return vlanInfoList;
    }

    public static QAsnVLanInfoList mo2Asn(int neID, int slotID, int vbID, TEEtherBridgeMOPO etherBridgeMo) {
        QAsnVLanInfoList tvlanInfoList = new QAsnVLanInfoList();
        HashMap<Integer, Integer> vblpEthPortMap = new HashMap<Integer, Integer>();
        Set vlanMOSet = etherBridgeMo.getVlanFibDB();
        Set vbLinkMOSet = etherBridgeMo.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO : vbLinkMOSet) {
            vblpEthPortMap.put(vbLinkMO.getVBPortID(), vbLinkMO.getPhyPortID());
        }
        for (TECFVlanEntryMOPO vlanMOPO : vlanMOSet) {
            QAsnVLanInfo tvlanInfo = new QAsnVLanInfo();
            QAsnVLanIndex trspIndex = new QAsnVLanIndex();
            QAsnVLanAttr vlanAttr = new QAsnVLanAttr();
            trspIndex.neID = neID;
            trspIndex.slotID = slotID;
            trspIndex.subSlotID = 255;
            trspIndex.vbID = vbID;
            trspIndex.vlanID = vlanMOPO.getVlanID();
            vlanAttr.vlanLabel = vlanMOPO.getVlanLabel().getBytes();
            vlanAttr.vlanName = "".getBytes();
            vlanAttr.vlanOwner = vlanMOPO.getVlanOwner().getBytes();
            vlanAttr.portList = TEE2EVlanUtil.getAsnForwardPortList(vlanMOPO, vblpEthPortMap);
            vlanAttr.isActive = vlanMOPO.getActiveState();
            tvlanInfo.vlanIndex = trspIndex;
            tvlanInfo.vlanAttr = vlanAttr;
            tvlanInfoList.add((Object)tvlanInfo);
        }
        return tvlanInfoList;
    }

    public static int getVLANFromNE(int neID, int slotID) {
        e2eLogger.info("getVLANFromNE: get vlan from ne begin.");
        int errCode = -1;
        TENEExplorerBean queryVLANBean = TEE2EVlanUtil.getQueryVLANBean(neID);
        int cmdID = 0x202023;
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdID);
        if (null == subFunc) {
            String tipStr = "getVLANFromNE: Get SubFunc fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            e2eLogger.info("getVLANFromNE: get vlan from ne end.");
            return 1090646019;
        }
        Datainterface inputData = TEE2EVlanUtil.createQueryVLANInput(neID, slotID);
        Datainterface outputData = null;
        try {
            outputData = queryVLANBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        }
        catch (Exception e) {
            String tipStr = "getVLANFromNE: queryVLANBean run fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr, (Throwable)e);
            e2eLogger.info("getVLANFromNE: get vlan from ne end.");
            return 1090646019;
        }
        if (null == outputData) {
            String tipStr = "queryVLANBean run fail! outputData is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, cmdID:%d]", neID, slotID, cmdID);
            e2eLogger.error(tipStr);
            e2eLogger.info("getVLANFromNE: get vlan from ne end.");
            return 1090646019;
        }
        errCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != errCode) {
            String tipStr = "getVLANFromNE: Query vlan from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, errCode:%d]", neID, slotID, errCode);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
        }
        e2eLogger.info("getVLANFromNE: get vlan from ne end.");
        return errCode;
    }

    private static TENEExplorerBean getQueryVLANBean(int neID) {
        TEVBMgrSuperBean queryVLANBean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, 0x202023);
        if (1 == vbCodeVersion) {
            queryVLANBean = new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEQueryVLANBean(){

                public boolean isNeedOperationlog() {
                    return false;
                }

                @Override
                public boolean isTriggerByE2E() {
                    return true;
                }
            };
        } else if (2 == vbCodeVersion) {
            queryVLANBean = new TEQueryVLANBean(){

                public boolean isNeedOperationlog() {
                    return false;
                }

                @Override
                public boolean isTriggerByE2E() {
                    return true;
                }
            };
        } else if (0 == vbCodeVersion) {
            queryVLANBean = new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEQueryVLANBean(){

                public boolean isNeedOperationlog() {
                    return false;
                }

                @Override
                public boolean isTriggerByE2E() {
                    return true;
                }
            };
        }
        return queryVLANBean;
    }

    private static Datainterface createQueryVLANInput(int neID, int slotID) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        Param param = new Param("neid", String.valueOf(neID));
        rowparams.addParam(param);
        param = new Param("slotid", String.valueOf(slotID));
        rowparams.addParam(param);
        param = new Param("vbid", String.valueOf(1));
        rowparams.addParam(param);
        param = new Param("vlanid", String.valueOf(-1));
        rowparams.addParam(param);
        return inputData;
    }

    public static QAsnVLanForwardPortList getAsnForwardPortList(TECFVlanEntryMOPO vlanMOPO, Map<Integer, Integer> vblpEthPortMap) {
        QAsnVLanForwardPortList forwardPortList = new QAsnVLanForwardPortList();
        Set portList = TEE2EVlanUtil.getVBlpPortSet(vlanMOPO);
        int vbLPPortID = -1;
        int ethPortID = -1;
        Integer ethPort = null;
        QAsnVLanForwardPort forwardPort = null;
        Iterator iter = portList.iterator();
        while (iter.hasNext()) {
            vbLPPortID = (Integer)iter.next();
            ethPort = vblpEthPortMap.get(vbLPPortID);
            if (null == ethPort) continue;
            ethPortID = ethPort;
            forwardPort = new QAsnVLanForwardPort();
            forwardPort.portID = TEEthXCUtil.getE2EPortID(ethPortID);
            forwardPort.portType = TEEthXCUtil.getE2EPortType(ethPortID);
            forwardPortList.add((Object)forwardPort);
        }
        return forwardPortList;
    }

    public static Set getVBlpPortSet(TECFVlanEntryMOPO vlanMOPO) {
        Set<Integer> vblpPortSet = null;
        String vlanFwPort = vlanMOPO.getVlanFwPort();
        if (null != vlanMOPO.getVlanFwPortEx()) {
            vlanFwPort = vlanFwPort + vlanMOPO.getVlanFwPortEx();
        }
        vblpPortSet = TEE2EVlanUtil.getVblpPortSet(vlanFwPort);
        return vblpPortSet;
    }

    public static Set<Integer> getVblpPortSet(String vlanFwPortStr) {
        HashSet<Integer> vblpPortSet = new HashSet<Integer>();
        TIntArrayList portList = new TIntArrayList();
        TEConvertUtil.strToNumList((String)vlanFwPortStr, (TIntArrayList)portList);
        int len = portList.size();
        for (int i = 0; i < len; ++i) {
            vblpPortSet.add(portList.get(i));
        }
        return vblpPortSet;
    }

    public static String getVblpPortStr(Set<Integer> oldFwdPortSet) {
        if (null == oldFwdPortSet || oldFwdPortSet.isEmpty()) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        Iterator<Integer> iter = oldFwdPortSet.iterator();
        while (iter.hasNext()) {
            if (0 != buffer.length()) {
                buffer.append(',');
            }
            buffer.append(iter.next());
        }
        return buffer.toString();
    }

    public static int saveVlanToDB(int neID, int slotID, int vbID, QAsnVLanCreateInfo createInfo, QAsnCreateVLanRsp rsp) {
        Set<TECFVlanEntryMOPO> vlanMOSet = TEE2EVlanUtil.convertVlanAsnToMO(neID, slotID, vbID, createInfo);
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        etherBridgeMo.getVlanFibDB().addAll(vlanMOSet);
        int result = TEE2EVBUtil.updateVBMOToDB(neID, slotID, etherBridgeMo);
        if (0 != result) {
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = result;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)createInfo.vlanID);
            rsp.result.errList.add((Object)errInfo);
        }
        return result;
    }

    public static Set<TECFVlanEntryMOPO> convertVlanAsnToMO(int neID, int slotID, int vbID, QAsnVLanCreateInfo createInfo) {
        int vlanID = createInfo.vlanID;
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(neID, slotID, vbID);
        QAsnVLanForwardPortList forwardPortList = createInfo.vlanattr.portList;
        HashSet<TECFVlanEntryMOPO> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        StringBuilder sb = new StringBuilder();
        TECFVlanEntryMOPO vlanEntry = new TECFVlanEntryMOPO();
        vlanEntry.setActiveState((short)createInfo.vlanattr.isActive);
        vlanEntry.setVlanID(vlanID);
        vlanEntry.setVlanLabel(new String(createInfo.vlanattr.vlanLabel));
        vlanEntry.setVlanOwner(new String(createInfo.vlanattr.vlanOwner));
        vlanEntry.setVlanMaxMac(-1L);
        int vblpPortID = -1;
        for (QAsnVLanForwardPort forwardPort : forwardPortList) {
            vblpPortID = TEE2EVlanUtil.getVblpPortFromEthPort(neID, slotID, forwardPort, ethPortVBLPMap);
            if (-1 == vblpPortID) continue;
            if (sb.length() != 0) {
                sb.append(',');
            }
            sb.append(vblpPortID);
        }
        vlanEntry.setVlanFwPort(sb.toString());
        vlanMOSet.add(vlanEntry);
        return vlanMOSet;
    }

    public static int getVblpPortFromEthPort(int neID, int slotID, QAsnVLanForwardPort port, Map<Integer, Integer> ethPortVBLPMap) {
        int vblpPortID = -1;
        int ethPortID = -1;
        Integer vblpPortObj = null;
        String tipStr = null;
        ethPortID = TEEthXCUtil.getWebLCTPortID(port.portID, port.portType);
        vblpPortObj = ethPortVBLPMap.get(ethPortID);
        if (null == vblpPortObj) {
            e2eLogger.error("getVblpPortFromEthPort: The vblpPort is not found for ethPortID! ");
            tipStr = String.format("[neID:%d, slotID:%d, ethPortID:%d]", neID, slotID, ethPortID);
            e2eLogger.error(tipStr);
            return vblpPortID;
        }
        vblpPortID = vblpPortObj;
        return vblpPortID;
    }

    public static Map<Integer, Integer> getEthPortVBLPMap(int neID, int slotID, int vbID) {
        HashMap<Integer, Integer> ethPortVBLPMap = new HashMap<Integer, Integer>();
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        Set vbLinkMOSet = etherBridgeMo.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO : vbLinkMOSet) {
            ethPortVBLPMap.put(vbLinkMO.getPhyPortID(), vbLinkMO.getVBPortID());
        }
        return ethPortVBLPMap;
    }

    public static Map<Integer, Integer> getVBLPEthPortMap(int neID, int slotID, int vbID) {
        HashMap<Integer, Integer> vblpEthPortMap = new HashMap<Integer, Integer>();
        TEEtherBridgeMOPO etherBridgeMo = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        Set vbLinkMOSet = etherBridgeMo.getLinkList();
        for (TEEtherVBLinkMOPO vbLinkMO : vbLinkMOSet) {
            vblpEthPortMap.put(vbLinkMO.getVBPortID(), vbLinkMO.getPhyPortID());
        }
        return vblpEthPortMap;
    }

    public static Set<Integer> connectSBIForNE(QAsnVLanIndexList vlanIndexList, QAsnErrInfoList errInfoList) {
        e2eLogger.info("connectSBIForNE: connect sbi for ne begin.");
        HashSet<Integer> neIDSet = new HashSet<Integer>();
        QAsnVLanIndex vlanIndex = null;
        int len = vlanIndexList.size();
        for (int i = 0; i < len; ++i) {
            vlanIndex = (QAsnVLanIndex)vlanIndexList.get(i);
            neIDSet.add(vlanIndex.neID);
        }
        Set<Integer> normarNESet = TEEthXCUtil.connectSBIForNEImpl(errInfoList, neIDSet);
        e2eLogger.info("connectSBIForNE: connect sbi for ne end.");
        return normarNESet;
    }

    public static int delVlanFromDB(int neID, int slotID, TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO) {
        Set vlanMOSet = vbMO.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO tmpVlanMO = null;
        while (iter.hasNext()) {
            tmpVlanMO = (TECFVlanEntryMOPO)iter.next();
            if (tmpVlanMO.getVlanID() != vlanMO.getVlanID()) continue;
            iter.remove();
            break;
        }
        return TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
    }

    public static void fillEmptyQAsnVLanInfo(QAsnVLanIndex vlanIndex, QAsnVLanInfo vlanInfo) {
        vlanInfo.vlanIndex.neID = vlanIndex.neID;
        vlanInfo.vlanIndex.slotID = vlanIndex.slotID;
        vlanInfo.vlanIndex.subSlotID = vlanIndex.subSlotID;
        vlanInfo.vlanIndex.vbID = vlanIndex.vbID;
        vlanInfo.vlanIndex.vlanID = vlanIndex.vlanID;
        vlanInfo.vlanAttr.attrList = new QAsnAttrValueList();
        vlanInfo.vlanAttr.isActive = -1;
        vlanInfo.vlanAttr.portList = new QAsnVLanForwardPortList();
        vlanInfo.vlanAttr.vlanLabel = "".getBytes();
        vlanInfo.vlanAttr.vlanName = "".getBytes();
        vlanInfo.vlanAttr.vlanOwner = "".getBytes();
    }
}

