/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetAllVLanIDReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnGetAllVLanIDRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndexList;
import com.huawei.nglct.cbb.log.TEAsn1Util;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EGetAllVlanIDHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnGetAllVLanIDReq begin.");
        QAsnGetAllVLanIDReq req = (QAsnGetAllVLanIDReq)qReq;
        QAsnGetAllVLanIDRsp rsp = (QAsnGetAllVLanIDRsp)qRsp;
        if (req.vbIndexList.isEmpty()) {
            e2eLogger.error("handleRequestImpl: The vbIndexList is empty!");
            e2eLogger.info(TEAsn1Util.getAsn1String((Object)rsp));
            e2eLogger.info("handleRequestImpl: handle QAsnGetAllVLanIDReq end.");
            return 0;
        }
        QAsnVLanIndex index = null;
        int neID = -1;
        int slotID = -1;
        TENE ne = null;
        TEBoard board = null;
        rsp.result.errList = new QAsnErrInfoList();
        int length = req.vbIndexList.size();
        for (int i = 0; i < length; ++i) {
            String tipStr;
            index = (QAsnVLanIndex)req.vbIndexList.get(i);
            neID = index.neID;
            slotID = index.slotID;
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                tipStr = "handleRequestImpl: The ne is not exist! ";
                tipStr = tipStr + String.format("[neID:%d]", neID);
                e2eLogger.error(tipStr);
                this.constructNEError(rsp, neID);
                continue;
            }
            board = ne.getBoard(slotID);
            if (null == board) {
                tipStr = "handleRequestImpl: The board is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
                e2eLogger.error(tipStr);
                this.constructBoardError(rsp, neID, slotID);
                continue;
            }
            List<TEEtherBridgeMOPO> bridgeMOList = TEE2EVBUtil.getVBMOFromDB(neID, slotID);
            rsp.vlanIndexList.addAll((Collection)this.getVlanList(neID, slotID, bridgeMOList));
        }
        this.constructGlobalErrCode(rsp);
        e2eLogger.info("handleRequestImpl: handle QAsnGetAllVLanIDReq end.");
        return 0;
    }

    private QAsnVLanIndexList getVlanList(int neID, int slotID, List<TEEtherBridgeMOPO> bridgeMOList) {
        QAsnVLanIndexList vbIndexList = new QAsnVLanIndexList();
        if (null == bridgeMOList) {
            String tipStr = "getVlanList: The bridgeMOList is null! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            return vbIndexList;
        }
        QAsnVLanIndex rspIndex = null;
        Set vlanMOSet = null;
        for (TEEtherBridgeMOPO etherBridgeMO : bridgeMOList) {
            vlanMOSet = etherBridgeMO.getVlanFibDB();
            for (TECFVlanEntryMOPO vlanMO : vlanMOSet) {
                rspIndex = new QAsnVLanIndex();
                rspIndex.neID = neID;
                rspIndex.slotID = slotID;
                rspIndex.subSlotID = 255;
                rspIndex.vbID = etherBridgeMO.getVBID();
                rspIndex.vlanID = vlanMO.getVlanID();
                vbIndexList.add((Object)rspIndex);
            }
        }
        return vbIndexList;
    }

    private void constructGlobalErrCode(QAsnGetAllVLanIDRsp rsp) {
        rsp.result.result = rsp.result.errList == null || rsp.result.errList.isEmpty() ? 0 : (rsp.vlanIndexList.isEmpty() ? 1090650122 : 1090650121);
    }

    private void constructBoardError(QAsnGetAllVLanIDRsp rsp, int neID, int slotID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = 1090646021;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.objID.add((Object)slotID);
        rsp.result.errList.add((Object)errInfo);
    }

    private void constructNEError(QAsnGetAllVLanIDRsp rsp, int neID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = 1090596385;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        rsp.result.errList.add((Object)errInfo);
    }
}

