/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnDeleteVLanReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnDeleteVLanRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanAddDelRpt;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2ECreateVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EDelVlanMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EDelVlanHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq begin.");
        QAsnDeleteVLanReq req = (QAsnDeleteVLanReq)qReq;
        QAsnDeleteVLanRsp rsp = (QAsnDeleteVLanRsp)qRsp;
        rsp.result.errList = new QAsnErrInfoList();
        QAsnErrInfo errInfo = null;
        int neID = req.vlanIndex.neID;
        int slotID = req.vlanIndex.slotID;
        int vbID = req.vlanIndex.vbID;
        int vlanID = req.vlanIndex.vlanID;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            String tipStr = "handleRequestImpl: The ne is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090596385;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
            return 0;
        }
        int result = TEE2EVBUtil.connectSBIForNE(neID, rsp.result.errList);
        if (0 != result) {
            e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
            return 0;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            String tipStr = "handleRequestImpl: The board is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090646021;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
            return 0;
        }
        TEEtherBridgeMOPO currentVBMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == currentVBMO) {
            String tipStr = "handleRequestImpl: The vb is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090598182;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
            return 0;
        }
        Set vlanMOSet = currentVBMO.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO vlanMO = null;
        boolean isFound = false;
        while (iter.hasNext()) {
            vlanMO = (TECFVlanEntryMOPO)iter.next();
            if (vlanMO.getVlanID() != vlanID) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            String tipStr = "handleRequestImpl: The vlan is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090598155;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
            return 0;
        }
        int retCode = this.delVlan(neID, slotID, currentVBMO, vlanMO, rsp.result);
        if (0 == retCode) {
            this.sendDelVlanMessage(neID, slotID, vbID, vlanMO);
        } else {
            String tipStr = "handleRequestImpl: del vlan fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            e2eLogger.error(tipStr);
        }
        rsp.result.result = rsp.result.errList.isEmpty() ? 0 : 1090650121;
        e2eLogger.info("handleRequestImpl: handle QAsnDeleteVLanReq end.");
        return 0;
    }

    private int delVlan(int neID, int slotID, TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO, QAsnErrInfoReturn errInfoReturn) {
        e2eLogger.info("delVlan: del vlan begin.");
        int vbID = vbMO.getVBID();
        int vlanID = vlanMO.getVlanID();
        short isActive = vlanMO.getActiveState();
        int retCode = 0;
        if (1 == isActive && 0 != (retCode = TEE2EDelVlanHandler.delVlanFromNE(neID, slotID, vbID, vlanID, vlanMO, errInfoReturn))) {
            String tipStr = "delVlan: del vlan from ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            e2eLogger.error(tipStr);
            e2eLogger.info("delVlan: del vlan end.");
            return retCode;
        }
        if (0 == retCode && 0 != (retCode = TEE2EVlanUtil.delVlanFromDB(neID, slotID, vbMO, vlanMO))) {
            String tipStr = "delVlan: del vlan from db fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfoReturn.errList.add((Object)errInfo);
            errInfoReturn.result = 1090650122;
            e2eLogger.info("delVlan: del vlan end.");
            return retCode;
        }
        return retCode;
    }

    private void sendDelVlanMessage(int neID, int slotID, int vbID, TECFVlanEntryMOPO vlanMO) {
        HashSet<TECFVlanEntryMOPO> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        vlanMOSet.add(vlanMO);
        QAsnVLanAddDelRpt addRpt = new QAsnVLanAddDelRpt();
        addRpt.isAdd = 1;
        addRpt.vlanInfoList.addAll((Collection)TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet));
        TEE2EDelVlanMsg vlanMsg = new TEE2EDelVlanMsg(addRpt);
        TEE2EVlanNoticeMgr.sendDeleteNtf(vlanMsg);
    }

    public static int delVlanFromNE(int neID, int slotID, int vbID, int vlanID, TECFVlanEntryMOPO vlanMO, QAsnErrInfoReturn errInfo) {
        e2eLogger.info("delVlanFromNE: del vlan from ne begin.");
        int cmdCode = TEE2EDelVlanHandler.getSfid();
        TENEMgrInterface manageVLanBean = TEE2ECreateVlanHandler.getManageVlanBeanNoDB(neID, cmdCode);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdCode);
        Datainterface inputData = TEE2EDelVlanHandler.createInputData(neID, slotID, vbID, vlanID, vlanMO);
        Datainterface outputData = manageVLanBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        int retCode = 0;
        if (null == outputData) {
            String tipStr = "delVlanFromNE: del vlan from ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            e2eLogger.error(tipStr);
            retCode = 1090646019;
            TEE2EVBUtil.fillErrorToRsp(errInfo.errList, neID, retCode);
            errInfo.result = 1090650122;
            e2eLogger.info("delVlanFromNE: del vlan from ne end.");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            String tipStr = "delVlanFromNE: del vlan from ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, errInfo.errList);
            errInfo.result = 1090650122;
        }
        e2eLogger.info("delVlanFromNE: del vlan from ne end.");
        return retCode;
    }

    public static int getSfid() {
        return 0x202021;
    }

    private static Datainterface createInputData(int neID, int slotID, int vbID, int vlanID, TECFVlanEntryMOPO vlanMO) {
        String[] vblpPortArr;
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam(new Param("neid", String.valueOf(neID)));
        rowparams.addParam(new Param("slotid", String.valueOf(slotID)));
        rowparams.addParam(new Param("vbid", String.valueOf(vbID)));
        rowparams.addParam(new Param("vlanid", String.valueOf(vlanID)));
        rowparams.addParam(new Param("flag", "0"));
        String portNOStr = "";
        StringBuffer portNoBuffer = new StringBuffer();
        String vblpPortStr = vlanMO.getVlanFwPort() + vlanMO.getVlanFwPortEx();
        for (String str : vblpPortArr = vblpPortStr.split(",")) {
            portNoBuffer.append(Integer.toHexString(Integer.parseInt(str)));
        }
        portNOStr = portNoBuffer.toString();
        rowparams.addParam(new Param("portNoList", portNOStr));
        rowparams.addParam(new Param("portcount", String.valueOf(vblpPortArr.length)));
        return inputData;
    }
}

