/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnDelVLanForwardPortReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnDelVLanForwardPortRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPort;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2ECreateVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EDelVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EDelVLanFwdPortHandler
extends TEWNEMgrHandler {
    private static final Logger elog = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq begin.");
        QAsnDelVLanForwardPortReq req = (QAsnDelVLanForwardPortReq)qReq;
        QAsnDelVLanForwardPortRsp rsp = (QAsnDelVLanForwardPortRsp)qRsp;
        int neID = req.vlanIndex.neID;
        int slotID = req.vlanIndex.slotID;
        int vbID = req.vlanIndex.vbID;
        int vlanID = req.vlanIndex.vlanID;
        rsp.result.errList = new QAsnErrInfoList();
        TEE2EVlanUtil.fillEmptyQAsnVLanInfo(req.vlanIndex, rsp.vlanInfo);
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            String tipStr = "handleRequestImpl: The ne is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            this.constructNEError(rsp.result.errList, neID, 1090596385);
            elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq end.");
            return 1090650122;
        }
        int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != retCode) {
            String tipStr = "handleRequestImpl: connect ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            return 1090650122;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            String tipStr = "handleRequestImpl: The board is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            this.constructBoardError(rsp.result.errList, neID, slotID);
            elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq end.");
            return 1090650122;
        }
        TEEtherBridgeMOPO vbMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMO) {
            String tipStr = "handleRequestImpl: The vb is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090598182;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq end.");
            return 0;
        }
        Set vlanMOSet = vbMO.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO vlanMO = new TECFVlanEntryMOPO();
        boolean isFound = false;
        while (iter.hasNext()) {
            vlanMO = (TECFVlanEntryMOPO)iter.next();
            if (vlanMO.getVlanID() != vlanID) continue;
            isFound = true;
            break;
        }
        if (!isFound) {
            String tipStr = "handleRequestImpl: The vlan is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090598155;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq end.");
            return 0;
        }
        if (1 == vlanMO.getActiveState()) {
            this.delVlanFwdPortOnActive(vbMO, vlanMO, req, rsp);
        } else {
            this.delVlanFwdPortOnUnActive(vbMO, vlanMO, req, rsp);
        }
        elog.info("handleRequestImpl: handle QAsnDelVLanForwardPortReq end.");
        return 0;
    }

    private int delVlanFwdPortOnActive(TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO, QAsnDelVLanForwardPortReq req, QAsnDelVLanForwardPortRsp rsp) {
        String tipStr;
        elog.info("addVlanFwdPortOnActive: begin.");
        int result = 0;
        int neID = req.vlanIndex.neID;
        int slotID = req.vlanIndex.slotID;
        int vbID = req.vlanIndex.vbID;
        int vlanID = req.vlanIndex.vlanID;
        HashSet<Object> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        vlanMOSet.add(vlanMO);
        QAsnVLanInfoList asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        rsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(neID, slotID, vbID);
        Set vblpPortSet = TEE2EVlanUtil.getVBlpPortSet(vlanMO);
        int forwardPort = -1;
        int vblpPort = -1;
        Integer vblpPortObj = null;
        QAsnVLanForwardPort qasnPort = null;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        ArrayList<Integer> delVblpPortList = new ArrayList<Integer>();
        int len = req.forwardPortList.size();
        for (int i = 0; i < len; ++i) {
            qasnPort = (QAsnVLanForwardPort)req.forwardPortList.get(i);
            forwardPort = TEEthXCUtil.getWebLCTPortID(qasnPort.portID, qasnPort.portType);
            vblpPortObj = ethPortVBLPMap.get(forwardPort);
            if (vblpPortObj == vblpPort) {
                String tipStr2 = "addVlanFwdPortOnActive: The vblp port is not exist! ";
                tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                elog.error(tipStr2);
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.errCode = 55205;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                errInfo.objID.add((Object)forwardPort);
                rsp.result.errList.add((Object)errInfo);
                result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            isAllFail = false;
            vblpPort = vblpPortObj;
            if (!vblpPortSet.contains(vblpPort)) continue;
            vblpPortSet.remove(vblpPort);
            delVblpPortList.add(vblpPort);
        }
        rsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
        ArrayList vblpPortList = new ArrayList();
        vblpPortList.addAll(vblpPortSet);
        Collections.sort(vblpPortList);
        StringBuffer vblpPortBuffer = new StringBuffer();
        for (Integer portObj : vblpPortList) {
            if (0 == vblpPortBuffer.length()) {
                vblpPortBuffer.append(portObj);
                continue;
            }
            vblpPortBuffer.append(',').append(portObj);
        }
        vlanMO.setVlanFwPort(vblpPortBuffer.toString());
        int retCode = TEE2EDelVLanFwdPortHandler.delVlanFwdPortFromNE(neID, slotID, vbID, vlanID, delVblpPortList, rsp.result);
        if (0 != retCode) {
            tipStr = "addVlanFwdPortOnActive: create vlan to ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = result;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfo.objID.add((Object)forwardPort);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            elog.info("addVlanFwdPortOnActive: end.");
            return 1090650122;
        }
        retCode = vlanMO.getVlanFwPort().isEmpty() ? TEE2EVlanUtil.delVlanFromDB(neID, slotID, vbMO, vlanMO) : TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            tipStr = "addVlanFwdPortOnActive: update vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfo.objID.add((Object)forwardPort);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            elog.info("addVlanFwdPortOnActive: end.");
            return 1090650122;
        }
        vlanMOSet = new HashSet();
        vlanMOSet.add(vlanMO);
        asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        rsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        elog.info("addVlanFwdPortOnActive: end.");
        return result;
    }

    public static int delVlanFwdPortFromNE(int neID, int slotID, int vbID, int vlanID, List<Integer> vblpPortList, QAsnErrInfoReturn errInfo) {
        elog.info("delVlanFwdPortFromNE: del vlan from ne begin.");
        int cmdCode = TEE2EDelVlanHandler.getSfid();
        TENEMgrInterface manageVLanBean = TEE2ECreateVlanHandler.getManageVlanBeanNoDB(neID, cmdCode);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, cmdCode);
        Datainterface inputData = TEE2EDelVLanFwdPortHandler.createInputData(neID, slotID, vbID, vlanID, vblpPortList);
        Datainterface outputData = manageVLanBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        int retCode = 0;
        if (null == outputData) {
            String tipStr = "delVlanFwdPortFromNE: del vlan from ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            elog.error(tipStr);
            retCode = 1090646019;
            TEE2EVBUtil.fillErrorToRsp(errInfo.errList, neID, retCode);
            errInfo.result = 1090650122;
            elog.info("delVlanFwdPortFromNE: del vlan from ne end.");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            String tipStr = "delVlanFwdPortFromNE: del vlan from ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d, retCode:%d]", neID, slotID, vbID, vlanID, retCode);
            elog.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, errInfo.errList);
            errInfo.result = 1090650122;
        }
        elog.info("delVlanFwdPortFromNE: del vlan from ne end.");
        return retCode;
    }

    private static Datainterface createInputData(int neID, int slotID, int vbID, int vlanID, List<Integer> vblpPortList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam(new Param("neid", String.valueOf(neID)));
        rowparams.addParam(new Param("slotid", String.valueOf(slotID)));
        rowparams.addParam(new Param("vbid", String.valueOf(vbID)));
        rowparams.addParam(new Param("vlanid", String.valueOf(vlanID)));
        rowparams.addParam(new Param("flag", "0"));
        StringBuffer portNoBuffer = new StringBuffer();
        for (Integer vblpPort : vblpPortList) {
            portNoBuffer.append(Integer.toHexString(vblpPort));
        }
        rowparams.addParam(new Param("portNoList", portNoBuffer.toString()));
        rowparams.addParam(new Param("portcount", String.valueOf(vblpPortList.size())));
        return inputData;
    }

    private int delVlanFwdPortOnUnActive(TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO, QAsnDelVLanForwardPortReq req, QAsnDelVLanForwardPortRsp rsp) {
        elog.info("delVlanFwdPortOnUnActive: begin.");
        int result = 0;
        int neID = req.vlanIndex.neID;
        int slotID = req.vlanIndex.slotID;
        int vbID = req.vlanIndex.vbID;
        int vlanID = req.vlanIndex.vlanID;
        HashSet<Object> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        vlanMOSet.add(vlanMO);
        QAsnVLanInfoList asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        rsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(neID, slotID, vbID);
        Set vblpPortSet = TEE2EVlanUtil.getVBlpPortSet(vlanMO);
        int forwardPort = -1;
        int vblpPort = -1;
        Integer vblpPortObj = null;
        QAsnVLanForwardPort qasnPort = null;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        int len = req.forwardPortList.size();
        for (int i = 0; i < len; ++i) {
            qasnPort = (QAsnVLanForwardPort)req.forwardPortList.get(i);
            forwardPort = TEEthXCUtil.getWebLCTPortID(qasnPort.portID, qasnPort.portType);
            vblpPortObj = ethPortVBLPMap.get(forwardPort);
            if (vblpPortObj == vblpPort) {
                String tipStr = "delVlanFwdPortOnUnActive: The vblp port is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                elog.error(tipStr);
                QAsnErrInfo errInfo = new QAsnErrInfo();
                errInfo.errCode = 55205;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                errInfo.objID.add((Object)forwardPort);
                rsp.result.errList.add((Object)errInfo);
                result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            isAllFail = false;
            vblpPort = vblpPortObj;
            if (!vblpPortSet.contains(vblpPort)) continue;
            vblpPortSet.remove(vblpPort);
        }
        rsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
        ArrayList vblpPortList = new ArrayList();
        vblpPortList.addAll(vblpPortSet);
        Collections.sort(vblpPortList);
        StringBuffer vblpPortBuffer = new StringBuffer();
        for (Integer portObj : vblpPortList) {
            if (0 == vblpPortBuffer.length()) {
                vblpPortBuffer.append(portObj);
                continue;
            }
            vblpPortBuffer.append(',').append(portObj);
        }
        vlanMO.setVlanFwPort(vblpPortBuffer.toString());
        int retCode = 0;
        retCode = vlanMO.getVlanFwPort().isEmpty() ? TEE2EVlanUtil.delVlanFromDB(neID, slotID, vbMO, vlanMO) : TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            String tipStr = "delVlanFwdPortOnUnActive: update vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            elog.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfo.objID.add((Object)forwardPort);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            return 1090650122;
        }
        vlanMOSet = new HashSet();
        vlanMOSet.add(vlanMO);
        asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        rsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        elog.info("delVlanFwdPortOnUnActive: end.");
        return result;
    }

    private void constructBoardError(QAsnErrInfoList errInfoList, int neID, int slotID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = 1090646021;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.objID.add((Object)slotID);
        errInfoList.add((Object)errInfo);
    }

    private void constructNEError(QAsnErrInfoList errInfoList, int neID, int errCode) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.errCode = errCode;
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfoList.add((Object)errInfo);
    }
}

