/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateVLanReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnCreateVLanRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVBIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanAddDelRpt;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanCreateInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPort;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPortList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EDelVlanMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanNoticeMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEVBMgrWriteLogSuperBean;
import com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c02.TEManageVLANBean;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2ECreateVlanHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnCreateVLanReq begin.");
        QAsnCreateVLanReq req = (QAsnCreateVLanReq)qReq;
        QAsnCreateVLanRsp rsp = (QAsnCreateVLanRsp)qRsp;
        int neID = req.vbIndex.neID;
        int slotID = req.vbIndex.slotID;
        int vbID = req.vbIndex.vbID;
        int vlanID = -1;
        rsp.result.errList = new QAsnErrInfoList();
        if (!this.checkCondition(req.vbIndex, rsp)) {
            e2eLogger.info("handleRequestImpl: handle QAsnCreateVLanReq end.");
            return 0;
        }
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        int result = 0;
        QAsnVLanCreateInfo createInfo = null;
        Iterator iter = req.vlanCreateInfoList.iterator();
        while (iter.hasNext()) {
            createInfo = (QAsnVLanCreateInfo)iter.next();
            int isActive = createInfo.vlanattr.isActive;
            if (isActive == 1) {
                result = this.createVLanToNENoDB(createInfo, req.vbIndex, rsp);
            }
            if (0 != result) {
                String tipStr = "handleRequestImpl: create vlan to ne fail! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr);
                isAllSuccess = false;
                iter.remove();
                continue;
            }
            isAllFail = false;
        }
        HashSet<TECFVlanEntryMOPO> successVlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        int iLength = req.vlanCreateInfoList.size();
        for (int i = 0; i < iLength; ++i) {
            createInfo = (QAsnVLanCreateInfo)req.vlanCreateInfoList.get(i);
            vlanID = createInfo.vlanID;
            result = TEE2EVlanUtil.saveVlanToDB(neID, slotID, vbID, createInfo, rsp);
            if (0 != result) {
                String tipStr = "handleRequestImpl: save vlan to db fail! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr);
                isAllSuccess = false;
                continue;
            }
            Set<TECFVlanEntryMOPO> vlanMOSet = TEE2EVlanUtil.convertVlanAsnToMO(neID, slotID, vbID, createInfo);
            successVlanMOSet.addAll(vlanMOSet);
            isAllFail = false;
        }
        if (!successVlanMOSet.isEmpty()) {
            this.sendCreateVlanMessage(neID, slotID, vbID, successVlanMOSet);
        }
        this.constructGlobalErrCode(rsp, isAllSuccess, isAllFail);
        e2eLogger.info("handleRequestImpl: handle QAsnCreateVLanReq end.");
        return 0;
    }

    private void sendCreateVlanMessage(int neID, int slotID, int vbID, Set<TECFVlanEntryMOPO> vlanMOSet) {
        QAsnVLanAddDelRpt addRpt = new QAsnVLanAddDelRpt();
        addRpt.isAdd = 1;
        addRpt.vlanInfoList.addAll((Collection)TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet));
        TEE2EDelVlanMsg vlanMsg = new TEE2EDelVlanMsg(addRpt);
        TEE2EVlanNoticeMgr.sendCreateNtf(vlanMsg);
    }

    private void constructGlobalErrCode(QAsnCreateVLanRsp rsp, boolean isAllSuccess, boolean isAllFail) {
        rsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
    }

    private int createVLanToNENoDB(QAsnVLanCreateInfo createInfo, QAsnVBIndex vbIndex, QAsnCreateVLanRsp rsp) {
        e2eLogger.info("createVLanToNE: create vlan to ne begin...");
        int neID = vbIndex.neID;
        int slotID = vbIndex.slotID;
        int vbID = vbIndex.vbID;
        TENEMgrInterface manageVLanBean = TEE2ECreateVlanHandler.getManageVlanBeanNoDB(neID, 0x202022);
        SubFunc subFunction = TEEthXCUtil.createSubFunc(neID, 0x202022);
        Datainterface inputData = this.createInputData(createInfo, vbIndex);
        Datainterface output = manageVLanBean.performBussinessProcess(neID, subFunction, inputData, null, null, null);
        int retCode = 0;
        if (null == output) {
            String tipStr = "createVLanToNE: create vlan to ne fail! outputData is null!!!!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(tipStr);
            retCode = 1090646019;
            TEE2EVBUtil.fillErrorToRsp(rsp.result.errList, neID, retCode);
            rsp.result.result = 1090650122;
            e2eLogger.info("createVLanToNE: create vlan to ne end...");
            return retCode;
        }
        retCode = Integer.parseInt(output.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            String tipStr = "createVLanToNE: create vb to ne fail! outputData is null!!!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(tipStr);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, output, rsp.result.errList);
            rsp.result.result = 1090650122;
        }
        e2eLogger.info("createVLanToNE: create vlan to ne end...");
        return retCode;
    }

    public static int createVLanToNENoDB(int neID, int slotID, int vbID, int vlanID, TECFVlanEntryMOPO vlanMO, QAsnErrInfoReturn errInfoReturn) {
        e2eLogger.info("createVLanToNENoDB: create vlan to ne begin...");
        TENEMgrInterface manageVLanBean = TEE2ECreateVlanHandler.getManageVlanBeanNoDB(neID, 0x202022);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, 0x202022);
        Datainterface inputData = TEE2ECreateVlanHandler.createInputData(neID, slotID, vbID, vlanID, vlanMO);
        Datainterface outputData = manageVLanBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        int code = 0;
        if (null == outputData) {
            String strTip = "createVLanToNENoDB: create vlan to ne fail! outputData is null!!!";
            strTip = strTip + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(strTip);
            code = 1090646019;
            TEE2EVBUtil.fillErrorToRsp(errInfoReturn.errList, neID, code);
            errInfoReturn.result = 1090650122;
            e2eLogger.info("createVLanToNENoDB: create vlan to ne end.");
            return code;
        }
        code = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != code) {
            String tipStr = "createVLanToNENoDB: create vb to ne fail! outputData is null!!!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, errInfoReturn.errList);
            errInfoReturn.result = 1090650122;
        }
        e2eLogger.info("createVLanToNENoDB: create vlan to ne end...");
        return code;
    }

    private static Datainterface createInputData(int neID, int slotID, int vbID, int vlanID, TECFVlanEntryMOPO vlanMO) {
        String[] vblpPortArr;
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams row = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(row);
        row.addParam(new Param("neid", String.valueOf(neID)));
        row.addParam(new Param("slotid", String.valueOf(slotID)));
        row.addParam(new Param("vlanid", String.valueOf(vlanID)));
        row.addParam(new Param("flag", "1"));
        row.addParam(new Param("vbid", String.valueOf(vbID)));
        String portNOStr = "";
        StringBuffer sb = new StringBuffer();
        String vblpPortStr = vlanMO.getVlanFwPort() + vlanMO.getVlanFwPortEx();
        for (String str : vblpPortArr = vblpPortStr.split(",")) {
            sb.append(Integer.toHexString(Integer.parseInt(str)));
        }
        portNOStr = sb.toString();
        row.addParam(new Param("portNoList", portNOStr));
        row.addParam(new Param("portcount", String.valueOf(vblpPortArr.length)));
        return inputData;
    }

    private Datainterface createInputData(QAsnVLanCreateInfo createInfo, QAsnVBIndex vbIndex) {
        int vbNEID = vbIndex.neID;
        int slotID = vbIndex.slotID;
        int vbID = vbIndex.vbID;
        int vlanID = createInfo.vlanID;
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(vbNEID, slotID, vbID);
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams);
        rowparams.addParam(new Param("neid", String.valueOf(vbNEID)));
        rowparams.addParam(new Param("slotid", String.valueOf(slotID)));
        rowparams.addParam(new Param("vbid", String.valueOf(vbID)));
        rowparams.addParam(new Param("vlanid", String.valueOf(vlanID)));
        rowparams.addParam(new Param("flag", "1"));
        QAsnVLanForwardPortList portList = createInfo.vlanattr.portList;
        StringBuffer portStrBuf = new StringBuffer();
        int vblpPortID = -1;
        int portcount = 0;
        int iLength = portList.size();
        for (int i = 0; i < iLength; ++i) {
            QAsnVLanForwardPort port = (QAsnVLanForwardPort)portList.get(i);
            vblpPortID = TEE2EVlanUtil.getVblpPortFromEthPort(vbNEID, slotID, port, ethPortVBLPMap);
            if (-1 == vblpPortID) {
                String tipStr = "createInputData: vblpPortID is -1! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", vbNEID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr);
                continue;
            }
            portStrBuf.append(Integer.toHexString(vblpPortID));
            ++portcount;
        }
        rowparams.addParam(new Param("portNoList", portStrBuf.toString()));
        rowparams.addParam(new Param("portcount", String.valueOf(portcount)));
        return inputData;
    }

    public static TENEMgrInterface getManageVlanBeanNoDB(int neID, int cmdID) {
        TEVBMgrWriteLogSuperBean manageVlanBean = null;
        int vbCodeVersion = TEE2EVBUtil.getVBCodeVersion(neID, cmdID);
        manageVlanBean = 1 == vbCodeVersion ? new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice_v2r7c01.TEManageVLANBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isSaveVlanToDB() {
                return false;
            }

            @Override
            public boolean isDelVlanFromDB() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        } : (2 == vbCodeVersion ? new TEManageVLANBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isSaveVlanToDB() {
                return false;
            }

            @Override
            public boolean isDelVlanFromDB() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        } : new com.huawei.nglct.nemgr.ip.ngwdm.ethlanservice.TEManageVLANBean(){

            public boolean isNeedOperationlog() {
                return false;
            }

            @Override
            public boolean isSaveVlanToDB() {
                return false;
            }

            @Override
            public boolean isDelVlanFromDB() {
                return false;
            }

            @Override
            public boolean isTriggerByE2E() {
                return true;
            }
        });
        return manageVlanBean;
    }

    private boolean checkCondition(QAsnVBIndex vbIndex, QAsnCreateVLanRsp rsp) {
        int neID = vbIndex.neID;
        int slotID = vbIndex.slotID;
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            String tipStr = "checkCondition: The ne is not exist! ";
            tipStr = tipStr + String.format("[neID:%d]", neID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090596385;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            return false;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            String tipStr = "checkCondition: The board is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = 1090646021;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            return false;
        }
        int result = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
        if (0 != result) {
            String tipStr = "checkCondition: connect ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d]", neID, slotID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = result;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            rsp.result.errList.add((Object)errInfo);
            rsp.result.result = 1090650122;
            return false;
        }
        return true;
    }
}

