/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnAddVLanForwardPortReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnAddVLanForwardPortRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanForwardPort;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfo;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanInfoList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.common.TENEMgrInterface;
import com.huawei.nglct.common.datainterface.BussinessParams;
import com.huawei.nglct.common.datainterface.Datainterface;
import com.huawei.nglct.common.datainterface.Param;
import com.huawei.nglct.common.datainterface.RowParams;
import com.huawei.nglct.common.functions.SubFunc;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.ethxc.TEEthXCUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2ECreateVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import com.huawei.nglct.sysmanager.TEHandleSbiInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EAddVLanFwdPortHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq begin...");
        QAsnAddVLanForwardPortReq req = (QAsnAddVLanForwardPortReq)qReq;
        QAsnAddVLanForwardPortRsp rsp = (QAsnAddVLanForwardPortRsp)qRsp;
        TEE2EVlanUtil.fillEmptyQAsnVLanInfo(req.vlanIndex, rsp.vlanInfo);
        int neID = req.vlanIndex.neID;
        int slotID = req.vlanIndex.slotID;
        int vbID = req.vlanIndex.vbID;
        int vlanID = req.vlanIndex.vlanID;
        rsp.result.errList = new QAsnErrInfoList();
        TENE ne = TENEListMgr.getInstance().getNE(neID);
        if (null == ne) {
            String tipStr = "handleRequestImpl: The ne is not exist!!!!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            this.constructNEError(rsp.result.errList, neID, 1090596385);
            e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq end...");
            return 1090650122;
        }
        TEBoard board = ne.getBoard(slotID);
        if (null == board) {
            String tipStr1 = "handleRequestImpl: The board is not exist! ";
            tipStr1 = tipStr1 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr1);
            this.constructBoardError(rsp.result.errList, neID, slotID);
            e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq end.");
            return 1090650122;
        }
        TEEtherBridgeMOPO vbMOObj = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
        if (null == vbMOObj) {
            String tipStr = "handleRequestImpl: The vb is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo1 = new QAsnErrInfo();
            errInfo1.errCode = 1090598182;
            errInfo1.objID = new QAsnTinyIntList();
            errInfo1.objID.add((Object)neID);
            errInfo1.objID.add((Object)slotID);
            errInfo1.objID.add((Object)vbID);
            errInfo1.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo1);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq end.");
            return 0;
        }
        Set vlanMOSet = vbMOObj.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO vlanMO = new TECFVlanEntryMOPO();
        boolean hasFound = false;
        while (iter.hasNext()) {
            vlanMO = (TECFVlanEntryMOPO)iter.next();
            if (vlanMO.getVlanID() != vlanID) continue;
            hasFound = true;
            break;
        }
        if (!hasFound) {
            String tipStr = "handleRequestImpl: The vlan is not exist! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo1 = new QAsnErrInfo();
            errInfo1.errCode = 1090598155;
            errInfo1.objID = new QAsnTinyIntList();
            errInfo1.objID.add((Object)neID);
            errInfo1.objID.add((Object)slotID);
            errInfo1.objID.add((Object)vbID);
            errInfo1.objID.add((Object)vlanID);
            rsp.result.errList.add((Object)errInfo1);
            rsp.result.result = 1090650122;
            e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq end.");
            return 0;
        }
        if (1 == vlanMO.getActiveState()) {
            int retCode = TEHandleSbiInfo.getInstance().handleSBIConnectOnInter2(neID);
            if (0 != retCode) {
                String tipStr = "addVlanFwdPortOnActive: connect ne fail! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr);
                QAsnErrInfo errInfo1 = new QAsnErrInfo();
                errInfo1.errCode = retCode;
                errInfo1.objID = new QAsnTinyIntList();
                errInfo1.objID.add((Object)neID);
                errInfo1.objID.add((Object)slotID);
                errInfo1.objID.add((Object)vbID);
                errInfo1.objID.add((Object)vlanID);
                rsp.result.errList.add((Object)errInfo1);
                rsp.result.result = 1090650122;
                return 1090650122;
            }
            this.addVlanFwdPortOnActive(vbMOObj, vlanMO, req, rsp);
        } else {
            this.addVlanFwdPortOnUnActive(vbMOObj, vlanMO, req, rsp);
        }
        e2eLogger.info("handleRequestImpl: handle QAsnAddVLanForwardPortReq end.");
        return 0;
    }

    private int addVlanFwdPortOnActive(TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO, QAsnAddVLanForwardPortReq qreq, QAsnAddVLanForwardPortRsp qrsp) {
        String tipStr;
        e2eLogger.info("addVlanFwdPortOnActive: begin.");
        int result = 0;
        int vbID = qreq.vlanIndex.vbID;
        int vlanID = qreq.vlanIndex.vlanID;
        int neID = qreq.vlanIndex.neID;
        int slotID = qreq.vlanIndex.slotID;
        HashSet<Object> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        vlanMOSet.add(vlanMO);
        QAsnVLanInfoList asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        qrsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(neID, slotID, vbID);
        Set vblpPortSet = TEE2EVlanUtil.getVBlpPortSet(vlanMO);
        Integer vblpPortObj = null;
        QAsnVLanForwardPort qasnPort = null;
        int forwardPort = -1;
        int vblpPort = -1;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        ArrayList<Integer> addVblpPortList = new ArrayList<Integer>();
        int len = qreq.forwardPortList.size();
        for (int i = 0; i < len; ++i) {
            qasnPort = (QAsnVLanForwardPort)qreq.forwardPortList.get(i);
            forwardPort = TEEthXCUtil.getWebLCTPortID(qasnPort.portID, qasnPort.portType);
            vblpPortObj = ethPortVBLPMap.get(forwardPort);
            if (null == vblpPortObj) {
                String tipStr2 = "addVlanFwdPortOnActive: The vblp port is not exist! ";
                tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr2);
                QAsnErrInfo errorInfo = new QAsnErrInfo();
                errorInfo.errCode = 55205;
                errorInfo.objID = new QAsnTinyIntList();
                errorInfo.objID.add((Object)neID);
                errorInfo.objID.add((Object)slotID);
                errorInfo.objID.add((Object)vbID);
                errorInfo.objID.add((Object)vlanID);
                errorInfo.objID.add((Object)forwardPort);
                qrsp.result.errList.add((Object)errorInfo);
                result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            isAllFail = false;
            vblpPort = vblpPortObj;
            if (vblpPortSet.contains(vblpPort)) continue;
            addVblpPortList.add(vblpPort);
            vblpPortSet.add(vblpPort);
        }
        qrsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
        ArrayList vblpPortList = new ArrayList();
        vblpPortList.addAll(vblpPortSet);
        Collections.sort(vblpPortList);
        StringBuffer vblpPortSb = new StringBuffer();
        for (Integer portObj : vblpPortList) {
            if (0 == vblpPortSb.length()) {
                vblpPortSb.append(portObj);
                continue;
            }
            vblpPortSb.append(',').append(portObj);
        }
        vlanMO.setVlanFwPort(vblpPortSb.toString());
        int retCode = TEE2EAddVLanFwdPortHandler.createVLanFwdPortToNENoDB(neID, slotID, vbID, vlanID, addVblpPortList, qrsp.result);
        if (0 != retCode) {
            tipStr = "addVlanFwdPortOnActive: create vlan to ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo terrInfo = new QAsnErrInfo();
            terrInfo.errCode = result;
            terrInfo.objID = new QAsnTinyIntList();
            terrInfo.objID.add((Object)neID);
            terrInfo.objID.add((Object)slotID);
            terrInfo.objID.add((Object)vbID);
            terrInfo.objID.add((Object)vlanID);
            terrInfo.objID.add((Object)forwardPort);
            qrsp.result.errList.add((Object)terrInfo);
            qrsp.result.result = 1090650122;
            e2eLogger.info("addVlanFwdPortOnActive: end.");
            return 1090650122;
        }
        retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            tipStr = "addVlanFwdPortOnActive: update vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfo.objID.add((Object)forwardPort);
            qrsp.result.errList.add((Object)errInfo);
            qrsp.result.result = 1090650122;
            e2eLogger.info("addVlanFwdPortOnActive: end.");
            return 1090650122;
        }
        vlanMOSet = new HashSet();
        vlanMOSet.add(vlanMO);
        asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        qrsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        e2eLogger.info("addVlanFwdPortOnActive: end.");
        return result;
    }

    public static int createVLanFwdPortToNENoDB(int neID, int slotID, int vbID, int vlanID, List<Integer> addVblpPortList, QAsnErrInfoReturn errInfoReturn) {
        e2eLogger.info("createVLanToNENoDB: create vlan to ne begin.");
        TENEMgrInterface manageVLanBean = TEE2ECreateVlanHandler.getManageVlanBeanNoDB(neID, 0x202022);
        SubFunc subFunc = TEEthXCUtil.createSubFunc(neID, 0x202022);
        Datainterface inputData = TEE2EAddVLanFwdPortHandler.createInputData(neID, slotID, vbID, vlanID, addVblpPortList);
        Datainterface outputData = manageVLanBean.performBussinessProcess(neID, subFunc, inputData, null, null, null);
        int retCode = 0;
        if (null == outputData) {
            String tipStr = "createVLanToNENoDB: create vlan to ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(tipStr);
            retCode = 1090646019;
            TEE2EVBUtil.fillErrorToRsp(errInfoReturn.errList, neID, retCode);
            errInfoReturn.result = 1090650122;
            e2eLogger.info("createVLanToNENoDB: create vlan to ne end.");
            return retCode;
        }
        retCode = Integer.parseInt(outputData.getErrorMessage().getErrorcode());
        if (0 != retCode) {
            String tipStr = "createVLanToNENoDB: create vb to ne fail! outputData is null!";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, newVBID:%d]", neID, slotID, vbID);
            e2eLogger.error(tipStr);
            TEE2EVBUtil.printRowError(outputData);
            TEEthXCUtil.fillErrorToRsp(neID, slotID, outputData, errInfoReturn.errList);
            errInfoReturn.result = 1090650122;
        }
        e2eLogger.info("createVLanToNENoDB: create vlan to ne end.");
        return retCode;
    }

    private static Datainterface createInputData(int neID, int slotID, int vbID, int vlanID, List<Integer> addVblpPortList) {
        Datainterface inputData = new Datainterface();
        BussinessParams bussiness = new BussinessParams();
        RowParams rowparams11 = new RowParams();
        inputData.setBussinessParams(bussiness);
        bussiness.addRowParams(rowparams11);
        rowparams11.addParam(new Param("neid", String.valueOf(neID)));
        rowparams11.addParam(new Param("slotid", String.valueOf(slotID)));
        rowparams11.addParam(new Param("vbid", String.valueOf(vbID)));
        rowparams11.addParam(new Param("vlanid", String.valueOf(vlanID)));
        rowparams11.addParam(new Param("flag", "1"));
        StringBuffer portNoBuffer = new StringBuffer();
        for (Integer vblpPort : addVblpPortList) {
            portNoBuffer.append(Integer.toHexString(vblpPort));
        }
        rowparams11.addParam(new Param("portNoList", portNoBuffer.toString()));
        rowparams11.addParam(new Param("portcount", String.valueOf(addVblpPortList.size())));
        return inputData;
    }

    private int addVlanFwdPortOnUnActive(TEEtherBridgeMOPO vbMO, TECFVlanEntryMOPO vlanMO, QAsnAddVLanForwardPortReq areq, QAsnAddVLanForwardPortRsp qrsp) {
        e2eLogger.info("addVlanFwdPortOnUnActive: begin.");
        int result = 0;
        int neID = areq.vlanIndex.neID;
        int slotID = areq.vlanIndex.slotID;
        int vbID = areq.vlanIndex.vbID;
        int vlanID = areq.vlanIndex.vlanID;
        HashSet<Object> vlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        vlanMOSet.add(vlanMO);
        QAsnVLanInfoList asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        qrsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        Map<Integer, Integer> ethPortVBLPMap = TEE2EVlanUtil.getEthPortVBLPMap(neID, slotID, vbID);
        Set vblpPortSet = TEE2EVlanUtil.getVBlpPortSet(vlanMO);
        int forwardPort = -1;
        int vblpPort = -1;
        Integer vblpPortObj = null;
        QAsnVLanForwardPort qasnPort = null;
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        int len = areq.forwardPortList.size();
        for (int i = 0; i < len; ++i) {
            qasnPort = (QAsnVLanForwardPort)areq.forwardPortList.get(i);
            forwardPort = TEEthXCUtil.getWebLCTPortID(qasnPort.portID, qasnPort.portType);
            vblpPortObj = ethPortVBLPMap.get(forwardPort);
            if (vblpPortObj == vblpPort) {
                String tipStr = "addVlanFwdPortOnUnActive: The vblp port is not exist! ";
                tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr);
                QAsnErrInfo errInfo1 = new QAsnErrInfo();
                errInfo1.errCode = 55205;
                errInfo1.objID = new QAsnTinyIntList();
                errInfo1.objID.add((Object)neID);
                errInfo1.objID.add((Object)slotID);
                errInfo1.objID.add((Object)vbID);
                errInfo1.objID.add((Object)vlanID);
                errInfo1.objID.add((Object)forwardPort);
                qrsp.result.errList.add((Object)errInfo1);
                result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            isAllFail = false;
            vblpPort = vblpPortObj;
            if (vblpPortSet.contains(vblpPort)) continue;
            vblpPortSet.add(vblpPort);
        }
        qrsp.result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
        ArrayList vblpPortList = new ArrayList();
        vblpPortList.addAll(vblpPortSet);
        Collections.sort(vblpPortList);
        StringBuffer vblpPortSB = new StringBuffer();
        for (Integer portObj : vblpPortList) {
            if (0 == vblpPortSB.length()) {
                vblpPortSB.append(portObj);
                continue;
            }
            vblpPortSB.append(',').append(portObj);
        }
        vlanMO.setVlanFwPort(vblpPortSB.toString());
        int retCode = TEE2EVBUtil.updateVBMOToDB(neID, slotID, vbMO);
        if (0 != retCode) {
            String tipStr = "addVlanFwdPortOnUnActive: update vb mo fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo1 = new QAsnErrInfo();
            errInfo1.errCode = retCode;
            errInfo1.objID = new QAsnTinyIntList();
            errInfo1.objID.add((Object)neID);
            errInfo1.objID.add((Object)slotID);
            errInfo1.objID.add((Object)vbID);
            errInfo1.objID.add((Object)vlanID);
            errInfo1.objID.add((Object)forwardPort);
            qrsp.result.errList.add((Object)errInfo1);
            qrsp.result.result = 1090650122;
            return 1090650122;
        }
        vlanMOSet = new HashSet();
        vlanMOSet.add(vlanMO);
        asnVlanList = TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, vlanMOSet);
        qrsp.vlanInfo = (QAsnVLanInfo)asnVlanList.get(0);
        e2eLogger.info("addVlanFwdPortOnUnActive: end.");
        return result;
    }

    private void constructBoardError(QAsnErrInfoList errInfoList, int neID, int slotID) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.objID.add((Object)slotID);
        errInfo.errCode = 1090646021;
        errInfoList.add((Object)errInfo);
    }

    private void constructNEError(QAsnErrInfoList errInfoList, int neID, int errCode) {
        QAsnErrInfo errInfo = new QAsnErrInfo();
        errInfo.objID = new QAsnTinyIntList();
        errInfo.objID.add((Object)neID);
        errInfo.errCode = errCode;
        errInfoList.add((Object)errInfo);
    }
}

