/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan;

import com.huawei.commextend.taskmgr.TaskMgr;
import com.huawei.network.qasn.m_q_common.QAsnErrInfo;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoList;
import com.huawei.network.qasn.m_q_common.QAsnErrInfoReturn;
import com.huawei.network.qasn.m_q_common.QAsnTinyIntList;
import com.huawei.network.qasn.m_q_ipservice.QAsnActivateVLanReq;
import com.huawei.network.qasn.m_q_ipservice.QAsnActivateVLanRsp;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanActiveRpt;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndex;
import com.huawei.network.qasn.m_q_ipservice.QAsnVLanIndexList;
import com.huawei.nglct.cbb.log.TELogFactory;
import com.huawei.nglct.core.taskmgr.handler.TEWNEMgrHandler;
import com.huawei.nglct.nelist.TEBoard;
import com.huawei.nglct.nelist.TENE;
import com.huawei.nglct.nelist.TENEListMgr;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vb.TEE2EVBUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2ECreateVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EDelVlanHandler;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.TEE2EVlanUtil;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EActiveVlanMsg;
import com.huawei.nglct.nemgr.ip.ngwdm.ethe2e.vlan.event.TEE2EVlanNoticeMgr;
import com.huawei.nglct.po.embeddednemgrmo.otn.TECFVlanEntryMOPO;
import com.huawei.nglct.po.embeddednemgrmo.otn.TEEtherBridgeMOPO;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import net.commustru.fstru.FStruct;
import org.slf4j.Logger;

public class TEE2EActivateVLanHandler
extends TEWNEMgrHandler {
    private static final Logger e2eLogger = TELogFactory.getE2ELogger();

    public int handleRequestImpl(FStruct qReq, FStruct qRsp, TaskMgr tm) {
        e2eLogger.info("handleRequestImpl: handle QAsnActivateVLanReq begin.");
        QAsnActivateVLanReq req = (QAsnActivateVLanReq)qReq;
        QAsnActivateVLanRsp rsp = (QAsnActivateVLanRsp)qRsp;
        QAsnVLanIndexList vlanIndexList = req.vlanIndexList;
        int isActive = req.isActive;
        rsp.result.errList = new QAsnErrInfoList();
        int neID = -1;
        TENE ne = null;
        int slotID = -1;
        TEBoard board = null;
        int vbID = -1;
        int vlanID = -1;
        QAsnErrInfo errInfo = new QAsnErrInfo();
        boolean isAllSuccess = true;
        boolean isAllFail = true;
        Set<Integer> normalNEIDSet = TEE2EVlanUtil.connectSBIForNE(req.vlanIndexList, rsp.result.errList);
        HashSet<TECFVlanEntryMOPO> nofifyVlanMOSet = new HashSet<TECFVlanEntryMOPO>();
        int length = vlanIndexList.size();
        for (int i = 0; i < length; ++i) {
            String tipStr;
            String tipStr2;
            QAsnVLanIndex vlanIndex = (QAsnVLanIndex)vlanIndexList.get(i);
            neID = vlanIndex.neID;
            slotID = vlanIndex.slotID;
            vbID = vlanIndex.vbID;
            vlanID = vlanIndex.vlanID;
            ne = TENEListMgr.getInstance().getNE(neID);
            if (null == ne) {
                tipStr2 = "handleRequestImpl: The ne is not exist!";
                tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr2);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090596385;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                rsp.result.errList.add((Object)errInfo);
                isAllSuccess = false;
                continue;
            }
            if (!normalNEIDSet.contains(neID)) {
                tipStr2 = "handleRequestImpl: The ne is not connected!";
                tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr2);
                isAllSuccess = false;
                continue;
            }
            board = ne.getBoard(slotID);
            if (null == board) {
                tipStr2 = "handleRequestImpl: The board is not exist!";
                tipStr2 = tipStr2 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr2);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090646021;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                rsp.result.errList.add((Object)errInfo);
                isAllSuccess = false;
                continue;
            }
            TEEtherBridgeMOPO currentVBMO = TEE2EVBUtil.getVBMOFromDB(neID, slotID, vbID);
            if (null == currentVBMO) {
                String tipStr3 = "handleRequestImpl: The vb is not exist! ";
                tipStr3 = tipStr3 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr3);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090598182;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                rsp.result.errList.add((Object)errInfo);
                rsp.result.result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            Set vlanMOSet = currentVBMO.getVlanFibDB();
            Iterator iter = vlanMOSet.iterator();
            TECFVlanEntryMOPO vlanMO = null;
            TECFVlanEntryMOPO cloneVlanMO = null;
            boolean isFound = false;
            while (iter.hasNext()) {
                vlanMO = (TECFVlanEntryMOPO)iter.next();
                if (vlanMO.getVlanID() != vlanID) continue;
                isFound = true;
                break;
            }
            if (!isFound) {
                String tipStr4 = "handleRequestImpl: The vlan is not exist! ";
                tipStr4 = tipStr4 + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                e2eLogger.error(tipStr4);
                errInfo = new QAsnErrInfo();
                errInfo.errCode = 1090598155;
                errInfo.objID = new QAsnTinyIntList();
                errInfo.objID.add((Object)neID);
                errInfo.objID.add((Object)slotID);
                errInfo.objID.add((Object)vbID);
                errInfo.objID.add((Object)vlanID);
                rsp.result.errList.add((Object)errInfo);
                rsp.result.result = 1090650122;
                isAllSuccess = false;
                continue;
            }
            try {
                cloneVlanMO = (TECFVlanEntryMOPO)vlanMO.clone();
            }
            catch (CloneNotSupportedException e) {
                e2eLogger.error("handleRequestImpl: Clone fail!", (Throwable)e);
            }
            int retCode = 0;
            if (1 == isActive) {
                if (1 == vlanMO.getActiveState()) {
                    tipStr = "handleRequestImpl: not execute because the link is active! ";
                    tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                    e2eLogger.error(tipStr);
                    retCode = 0;
                } else {
                    retCode = this.activeVlan(neID, slotID, currentVBMO, vlanMO, rsp.result);
                }
                e2eLogger.info("handleRequestImpl: activeVlan. retCode->" + retCode);
            } else {
                if (0 == vlanMO.getActiveState()) {
                    tipStr = "handleRequestImpl: not execute because the link is unactive! ";
                    tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
                    e2eLogger.error(tipStr);
                    retCode = 0;
                } else {
                    retCode = this.unactiveVlan(neID, slotID, currentVBMO, vlanMO, rsp.result);
                }
                e2eLogger.info("handleRequestImpl: unactiveVlan. retCode->" + retCode);
            }
            if (0 == retCode) {
                isAllFail = false;
                nofifyVlanMOSet.add(cloneVlanMO);
                continue;
            }
            isAllSuccess = false;
        }
        if (!nofifyVlanMOSet.isEmpty()) {
            this.sendActiveMessage(neID, slotID, vbID, isActive, nofifyVlanMOSet);
        }
        this.constructGlobalErrCode(rsp.result, isAllSuccess, isAllFail);
        e2eLogger.info("handleRequestImpl: handle QAsnActivateVLanReq end.");
        return 0;
    }

    private void sendActiveMessage(int neID, int slotID, int vbID, int isActive, Set<TECFVlanEntryMOPO> nofifyVlanMOSet) {
        QAsnVLanActiveRpt addRpt = new QAsnVLanActiveRpt();
        addRpt.isActive = isActive;
        addRpt.vlanInfoList.addAll((Collection)TEE2EVlanUtil.mo2Asn(neID, slotID, vbID, nofifyVlanMOSet));
        TEE2EActiveVlanMsg vlanMsg = new TEE2EActiveVlanMsg(addRpt);
        TEE2EVlanNoticeMgr.sendActiveNtf(vlanMsg);
    }

    private void constructGlobalErrCode(QAsnErrInfoReturn result, boolean isAllSuccess, boolean isAllFail) {
        result.result = isAllSuccess ? 0 : (isAllFail ? 1090650122 : 1090650121);
    }

    private int activeVlan(int neID, int slotID, TEEtherBridgeMOPO currentVBMO, TECFVlanEntryMOPO vlanMO, QAsnErrInfoReturn errInfoReturn) {
        e2eLogger.info("activeVlan: active vlan begin.");
        int vbID = currentVBMO.getVBID();
        int vlanID = vlanMO.getVlanID();
        int retCode = 0;
        retCode = TEE2ECreateVlanHandler.createVLanToNENoDB(neID, slotID, vbID, vlanID, vlanMO, errInfoReturn);
        if (0 != retCode) {
            String tipStr = "activeVlan: active vlan to ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            e2eLogger.info("activeVlan: active vlan end.");
            return retCode;
        }
        retCode = TEE2EActivateVLanHandler.setVlanActiveFlagToDB(neID, slotID, currentVBMO, vlanMO, 1);
        if (0 != retCode) {
            String tipStr = "activeVlan: set vlan active flag to db fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfoReturn.errList.add((Object)errInfo);
            e2eLogger.info("activeVlan: active vlan end.");
            return retCode;
        }
        e2eLogger.info("activeVlan: active vlan end.");
        return retCode;
    }

    private int unactiveVlan(int neID, int slotID, TEEtherBridgeMOPO currentVBMO, TECFVlanEntryMOPO vlanMO, QAsnErrInfoReturn errInfoReturn) {
        e2eLogger.info("unactiveVlan: unactive vlan begin.");
        int vbID = currentVBMO.getVBID();
        int vlanID = vlanMO.getVlanID();
        short curActiveStatus = vlanMO.getActiveState();
        int retCode = 0;
        if (1 == curActiveStatus && 0 != (retCode = TEE2EDelVlanHandler.delVlanFromNE(neID, slotID, vbID, vlanID, vlanMO, errInfoReturn))) {
            String tipStr = "unactiveVlan: set vlan active flag to ne fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            e2eLogger.info("unactiveVlan: unactive vlan end.");
            return retCode;
        }
        retCode = TEE2EActivateVLanHandler.setVlanActiveFlagToDB(neID, slotID, currentVBMO, vlanMO, 0);
        if (0 != retCode) {
            String tipStr = "unactiveVlan: del vlan from db fail! ";
            tipStr = tipStr + String.format("[neID:%d, slotID:%d, vbID:%d, vlanID:%d]", neID, slotID, vbID, vlanID);
            e2eLogger.error(tipStr);
            QAsnErrInfo errInfo = new QAsnErrInfo();
            errInfo.errCode = retCode;
            errInfo.objID = new QAsnTinyIntList();
            errInfo.objID.add((Object)neID);
            errInfo.objID.add((Object)slotID);
            errInfo.objID.add((Object)vbID);
            errInfo.objID.add((Object)vlanID);
            errInfoReturn.errList.add((Object)errInfo);
            e2eLogger.info("unactiveVlan: unactive vlan end.");
            return retCode;
        }
        e2eLogger.info("unactiveVlan: unactive vlan end.");
        return retCode;
    }

    public static int setVlanActiveFlagToDB(int neID, int slotID, TEEtherBridgeMOPO currentVBMO, TECFVlanEntryMOPO vlanMO, int isActive) {
        Set vlanMOSet = currentVBMO.getVlanFibDB();
        Iterator iter = vlanMOSet.iterator();
        TECFVlanEntryMOPO tmpVlanMO = null;
        while (iter.hasNext()) {
            tmpVlanMO = (TECFVlanEntryMOPO)iter.next();
            if (tmpVlanMO.getVlanID() != vlanMO.getVlanID()) continue;
            tmpVlanMO.setActiveState((short)isActive);
        }
        return TEE2EVBUtil.updateVBMOToDB(neID, slotID, currentVBMO);
    }
}

